/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.widgets.OptionDialog;
import docking.widgets.dialogs.MultiLineMessageDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.DateUtils;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import utilities.util.FileUtilities;

public class ProjectDataDeleteTask
extends Task {
    private Component parentComponent;
    private List<DomainFile> startFiles;
    private List<DomainFolder> startFolders;
    private Set<DomainFile> failPreprocessCheckedOut = new HashSet<DomainFile>();
    private Set<DomainFile> failPreprocessReadOnly = new HashSet<DomainFile>();
    private Set<DomainFile> readOnlyOverride = new HashSet<DomainFile>();
    private Map<DomainFile, String> filesToDelete = new LinkedHashMap<DomainFile, String>();
    private Map<DomainFolder, String> foldersToDelete = new LinkedHashMap<DomainFolder, String>();
    private int erroredFileCount;
    private int erroredFolderCount;
    private long elapsedTime;
    private long fileBytesDeleted;

    public ProjectDataDeleteTask(List<DomainFile> files, List<DomainFolder> folders, Component parentComponent) {
        super("Delete Files", true, true, true);
        this.parentComponent = parentComponent;
        this.startFiles = files != null ? files : Collections.emptyList();
        this.startFolders = folders != null ? folders : Collections.emptyList();
    }

    public void run(TaskMonitor monitor) {
        if (!this.preprocessStartFilesAndFolders(monitor)) {
            return;
        }
        if (!this.failPreprocessReadOnly.isEmpty()) {
            int option = OptionDialog.showOptionDialog((Component)this.parentComponent, (String)"Delete Read-only Files?", (String)("<html>There were " + this.failPreprocessReadOnly.size() + " read-only files found in the requested set of files.  Override the read-only status and delete?"), (String)"Delete Read-only Files", (String)"Continue and Skip Read-only Files", (int)3);
            switch (option) {
                case 1: {
                    for (DomainFile f : this.failPreprocessReadOnly) {
                        this.filesToDelete.put(f, null);
                    }
                    this.readOnlyOverride.addAll(this.failPreprocessReadOnly);
                    this.failPreprocessReadOnly.clear();
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    return;
                }
            }
        }
        if (!this.failPreprocessCheckedOut.isEmpty() && !this.confirmUserSkipFailedPreprocessedFiles()) {
            return;
        }
        if (this.filesToDelete.isEmpty() && this.foldersToDelete.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.parentComponent, (String)"Delete finished", (Object)"Nothing to do, finished.");
            return;
        }
        if (!this.confirmDeleteFiles()) {
            return;
        }
        try {
            this.deleteFiles(monitor);
            this.deleteFolders(monitor);
        }
        catch (CancelledException ce) {
            Msg.info((Object)((Object)this), (Object)"Canceled delete");
        }
        if (this.hasErrors()) {
            this.showErrorSummary(monitor.isCancelled());
        }
    }

    private boolean hasErrors() {
        return this.erroredFileCount > 0 || this.erroredFolderCount > 0;
    }

    private boolean confirmUserSkipFailedPreprocessedFiles() {
        String msg = "<html><div style='margin-bottom: 20pt; text-align: center;'>There were " + this.failPreprocessCheckedOut.size() + " versioned and checked-out files in the requested set of files that cannot be deleted.</div><div style='margin-bottom: 20pt; text-align: center;'>Skip these files and continue or cancel delete operation?</div>";
        return OptionDialog.showOptionDialog((Component)this.parentComponent, (String)"Continue and Skip Problem Files?", (String)msg, (String)"Skip and Continue") == 1;
    }

    private boolean confirmDeleteFiles() {
        Object files;
        int fileCount = this.filesToDelete.size();
        Object object = files = fileCount != 1 ? fileCount + " files" : " 1 file";
        if (!this.foldersToDelete.isEmpty()) {
            int folderCount = this.foldersToDelete.size();
            files = (String)files + (String)(folderCount > 1 ? " and " + folderCount + " folders" : " and 1 folder");
        }
        StringBuilder buffy = new StringBuilder("<html>");
        buffy.append("<div style='font-size: 110%; text-align: center;'>");
        buffy.append("<span>");
        buffy.append("Are you sure you want to <u>permanently</u> delete " + (String)files + "?");
        buffy.append("</span><br><br>");
        buffy.append("<span style='color: red;'>");
        buffy.append("There is no undo operation!");
        buffy.append("</span>");
        buffy.append("</div>");
        int choice = OptionDialog.showOptionDialog((Component)this.parentComponent, (String)"Confirm Delete Files?", (String)buffy.toString(), (String)"Delete Files", (int)3, (String)"Cancel");
        return choice == 1;
    }

    private void showErrorSummary(boolean wasCancelled) {
        int successFileCount = this.filesToDelete.size() - this.erroredFileCount;
        int successFolderCount = this.foldersToDelete.size() - this.erroredFolderCount;
        String msg = "<html><div>Status: " + (wasCancelled ? "Canceled" : "Finished") + " with errors</div><div style='margin-bottom: 20pt;'>Elapsed time: " + DateUtils.formatDuration((long)this.elapsedTime) + "</div><table style='margin-bottom: 20pt;' width='100%'><tr><td></td><td style='text-align: center'>Successful</td><td style='text-align: center'>Errored</td><td style='text-align: center'>Bytes</td></tr><tr><td>Files</td><td style='text-align: center'>" + successFileCount + "</td><td style='text-align: center'>" + this.erroredFileCount + "</td><td style='text-align: center'>" + FileUtilities.formatLength((long)this.fileBytesDeleted) + "</td></tr><tr><td>Folders</td><td style='text-align: center'>" + successFolderCount + "</td><td style='text-align: center'>" + this.erroredFolderCount + "</td><td></td></tr></table></div></body></html>";
        boolean hasErrors = this.erroredFileCount > 0 || this.erroredFolderCount > 0;
        SystemUtilities.runSwingLater(() -> this.showResults(hasErrors, msg));
    }

    private void showResults(boolean hasErrors, String msg) {
        if (!hasErrors) {
            MultiLineMessageDialog.showModalMessageDialog((Component)this.parentComponent, (String)"Delete Summary", (String)"", (String)msg, (int)1);
            return;
        }
        int option = OptionDialog.showOptionNoCancelDialog((Component)this.parentComponent, (String)"Delete Summary", (String)msg, (String)"OK", (String)"Log Errored Files", (int)1);
        if (option == 2) {
            for (Map.Entry<DomainFile, String> entry : this.filesToDelete.entrySet()) {
                if (entry.getValue() == null) continue;
                Msg.error((Object)((Object)this), (Object)("Delete file failed for " + entry.getKey().getPathname() + ": " + entry.getValue()));
            }
            for (Map.Entry<Comparable<DomainFile>, String> entry : this.foldersToDelete.entrySet()) {
                if (entry.getValue() == null) continue;
                Msg.error((Object)((Object)this), (Object)("Delete folder failed for " + ((DomainFolder)entry.getKey()).getPathname() + ": " + entry.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFolders(TaskMonitor monitor) throws CancelledException {
        long start_ts = System.currentTimeMillis();
        try {
            monitor.initialize((long)this.foldersToDelete.size());
            monitor.setMessage("Deleting directories...");
            ArrayList<DomainFolder> sortedFolders = new ArrayList<DomainFolder>(this.foldersToDelete.keySet());
            Collections.sort(sortedFolders, (o1, o2) -> o2.getPathname().compareTo(o1.getPathname()));
            for (DomainFolder folder : sortedFolders) {
                monitor.checkCancelled();
                try {
                    folder.delete();
                    monitor.incrementProgress(1L);
                }
                catch (IOException e) {
                    this.foldersToDelete.put(folder, e.getMessage());
                    ++this.erroredFolderCount;
                }
            }
        }
        finally {
            long end_ts = System.currentTimeMillis();
            this.elapsedTime += end_ts - start_ts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFiles(TaskMonitor monitor) throws CancelledException {
        long start = System.currentTimeMillis();
        try {
            monitor.initialize((long)this.filesToDelete.size());
            monitor.setMessage("Deleting files...");
            ArrayList<DomainFile> snapshot = new ArrayList<DomainFile>(this.filesToDelete.keySet());
            for (DomainFile file : snapshot) {
                monitor.checkCancelled();
                try {
                    if (file.isReadOnly() && !this.readOnlyOverride.contains(file)) {
                        throw new IOException("File is marked read-only");
                    }
                    long len = file.length();
                    file.delete();
                    this.fileBytesDeleted += len;
                }
                catch (IOException e) {
                    if (e instanceof RemoteException) {
                        Msg.showError((Object)((Object)this), null, (String)"Delete File Failed", (Object)e.getMessage(), (Throwable)e);
                    }
                    this.filesToDelete.put(file, e.getMessage());
                    ++this.erroredFileCount;
                }
            }
        }
        finally {
            long end = System.currentTimeMillis();
            this.elapsedTime += end - start;
        }
    }

    private boolean preprocessStartFilesAndFolders(TaskMonitor monitor) {
        try {
            long start_ts = System.currentTimeMillis();
            monitor.initialize((long)this.startFiles.size());
            monitor.setMessage("Checking files");
            for (DomainFile file : this.startFiles) {
                monitor.checkCancelled();
                this.preprocessFile(file, monitor);
                monitor.incrementProgress(1L);
            }
            monitor = new UnknownProgressWrappingTaskMonitor(monitor, (long)Math.max(this.startFolders.size(), 1));
            monitor.setMessage("Checking folders");
            for (DomainFolder folder : this.startFolders) {
                monitor.checkCancelled();
                this.preprocessFolder(folder, monitor);
            }
            long end_ts = System.currentTimeMillis();
            this.elapsedTime += end_ts - start_ts;
            return true;
        }
        catch (CancelledException ce) {
            return false;
        }
    }

    private void preprocessFolder(DomainFolder folder, TaskMonitor monitor) throws CancelledException {
        if (this.foldersToDelete.containsKey(folder)) {
            return;
        }
        monitor.setMessage("Checking " + folder.getPathname());
        this.foldersToDelete.put(folder, null);
        for (DomainFile domainFile : folder.getFiles()) {
            monitor.checkCancelled();
            this.preprocessFile(domainFile, monitor);
            monitor.incrementProgress(1L);
        }
        for (Comparable<DomainFile> comparable : folder.getFolders()) {
            monitor.checkCancelled();
            this.preprocessFolder((DomainFolder)comparable, monitor);
        }
    }

    private void preprocessFile(DomainFile file, TaskMonitor monitor) {
        if (this.filesToDelete.containsKey(file)) {
            return;
        }
        if (file.isVersioned() && file.isCheckedOut()) {
            this.failPreprocessCheckedOut.add(file);
            return;
        }
        if (file.isReadOnly()) {
            this.failPreprocessReadOnly.add(file);
            return;
        }
        this.filesToDelete.put(file, null);
    }
}

