/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import docking.ActionContext;
import docking.action.DockingAction;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonPanel;
import ghidra.features.codecompare.decompile.DualDecompilerActionContext;
import ghidra.features.codecompare.decompile.TokenPair;
import ghidra.features.codecompare.graphanalysis.TokenBin;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Duo;
import java.util.List;

public abstract class AbstractMatchedTokensAction
extends DockingAction {
    protected DecompilerCodeComparisonPanel diffPanel;
    protected boolean disableOnReadOnly;

    public AbstractMatchedTokensAction(String actionName, String owner, DecompilerCodeComparisonPanel diffPanel, boolean disableOnReadOnly) {
        super(actionName, owner);
        this.diffPanel = diffPanel;
        this.disableOnReadOnly = disableOnReadOnly;
    }

    protected abstract boolean enabledForTokens(TokenPair var1);

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DualDecompilerActionContext)) {
            return false;
        }
        DualDecompilerActionContext compareContext = (DualDecompilerActionContext)context;
        DecompilerCodeComparisonPanel decompPanel = compareContext.getCodeComparisonPanel();
        if (this.disableOnReadOnly) {
            Duo.Side focusedSide = decompPanel.getActiveSide();
            Program program = decompPanel.getProgram(focusedSide);
            if (program == null) {
                return false;
            }
            if (!program.canSave()) {
                return false;
            }
        }
        TokenPair currentPair = this.getCurrentTokenPair(decompPanel);
        return this.enabledForTokens(currentPair);
    }

    protected TokenPair getCurrentTokenPair(DecompilerCodeComparisonPanel decompPanel) {
        DecompilerPanel focusedPanel = decompPanel.getActiveDisplay().getDecompilerPanel();
        ProgramLocation programLocation = focusedPanel.getCurrentLocation();
        if (!(programLocation instanceof DecompilerLocation)) {
            return null;
        }
        DecompilerLocation focusedLocation = (DecompilerLocation)programLocation;
        ClangToken focusedToken = focusedLocation.getToken();
        if (focusedToken == null) {
            return null;
        }
        List<TokenBin> tokenBin = this.diffPanel.getHighBins();
        if (tokenBin == null) {
            return null;
        }
        TokenBin containingBin = TokenBin.getBinContainingToken(tokenBin, focusedToken);
        if (containingBin == null) {
            return null;
        }
        TokenBin matchedBin = containingBin.getMatch();
        if (matchedBin == null) {
            return null;
        }
        for (ClangToken currentMatch : matchedBin) {
            if (!currentMatch.getClass().equals(focusedToken.getClass())) continue;
            return decompPanel.getActiveSide() == Duo.Side.LEFT ? new TokenPair(focusedToken, currentMatch) : new TokenPair(currentMatch, focusedToken);
        }
        return null;
    }
}

