/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import generic.stl.Pair;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.comments.SarifCommentWriter;
import sarif.managers.SarifMgr;

public class CommentsSarifMgr
extends SarifMgr {
    public static String KEY = "COMMENTS";
    public static String SUBKEY = "Comment";
    static String[] commentTags;
    static Map<String, CommentType> commentTypeMap;

    CommentsSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        this.processComment(result);
        return true;
    }

    private void processComment(Map<String, Object> result) throws AddressFormatException {
        try {
            Address addr = this.getLocation(result);
            String typeStr = (String)result.get("kind");
            String comment = (String)result.get("value");
            boolean standard = (Boolean)result.get("standard");
            CommentType commentType = CommentsSarifMgr.getCommentType(typeStr);
            if (commentType == null) {
                this.log.appendMsg("Unknown comment type: " + typeStr);
                return;
            }
            if (standard) {
                CodeUnit cu = this.listing.getCodeUnitContaining(addr);
                if (cu != null) {
                    String currCmt = cu.getComment(commentType);
                    if (currCmt == null || currCmt.length() == 0) {
                        cu.setComment(commentType, comment);
                    } else if (currCmt.indexOf(comment) < 0) {
                        this.log.appendMsg("Merged " + typeStr + " comment at " + String.valueOf(addr));
                        cu.setComment(commentType, currCmt + "\n" + comment);
                    }
                }
            } else {
                String currCmt = this.listing.getComment(commentType, addr);
                if (currCmt == null || currCmt.length() == 0) {
                    this.listing.setComment(addr, commentType, comment);
                } else if (currCmt.indexOf(comment) < 0) {
                    this.log.appendMsg("Merged " + typeStr + " comment at " + String.valueOf(addr));
                    this.listing.setComment(addr, commentType, currCmt + "\n" + comment);
                }
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    public static CommentType getCommentType(String typeTagStr) {
        return commentTypeMap.get(typeTagStr);
    }

    public static String getCommentTypeString(CommentType type) {
        return commentTags[type.ordinal()];
    }

    void write(JsonArray results, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing COMMENTS ...");
        if (set == null) {
            set = this.program.getMemory();
        }
        ArrayList<Pair<CodeUnit, Pair<String, String>>> request0 = new ArrayList<Pair<CodeUnit, Pair<String, String>>>();
        CodeUnitIterator iter = this.listing.getCodeUnitIterator("COMMENT__GHIDRA_", set, true);
        while (iter.hasNext()) {
            monitor.checkCancelled();
            CodeUnit cu = iter.next();
            for (CommentType type : CommentType.values()) {
                String[] comments = cu.getCommentAsArray(type);
                String typeStr = CommentsSarifMgr.getCommentTypeString(type);
                for (String c : comments) {
                    Pair pair = new Pair((Object)typeStr, (Object)c);
                    request0.add((Pair<CodeUnit, Pair<String, String>>)new Pair((Object)cu, (Object)pair));
                }
            }
        }
        CommentsSarifMgr.writeAsSARIF0(request0, results);
        ArrayList<Pair<Address, Pair<String, String>>> request1 = new ArrayList<Pair<Address, Pair<String, String>>>();
        for (CommentType type : CommentType.values()) {
            AddressIterator aiter = this.listing.getCommentAddressIterator(type, set, true);
            while (aiter.hasNext()) {
                monitor.checkCancelled();
                Address a = aiter.next();
                CodeUnit cu = this.listing.getCodeUnitContaining(a);
                if (!(cu instanceof Instruction) || a.equals((Object)cu.getMinAddress())) continue;
                String c = this.listing.getComment(type, a);
                Pair pair = new Pair((Object)CommentsSarifMgr.getCommentTypeString(type), (Object)c);
                request1.add((Pair<Address, Pair<String, String>>)new Pair((Object)a, (Object)pair));
            }
        }
        CommentsSarifMgr.writeAsSARIF1(request1, results);
    }

    public static void writeAsSARIF0(List<Pair<CodeUnit, Pair<String, String>>> request, JsonArray results) throws IOException {
        SarifCommentWriter writer = new SarifCommentWriter(request, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }

    public static void writeAsSARIF1(List<Pair<Address, Pair<String, String>>> request, JsonArray results) throws IOException {
        SarifCommentWriter writer = new SarifCommentWriter(null, request);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }

    static {
        CommentType[] commentTypes = CommentType.values();
        commentTags = new String[commentTypes.length];
        commentTypeMap = new HashMap<String, CommentType>();
        for (CommentType type : commentTypes) {
            String tag = switch (type) {
                case CommentType.PRE -> "pre";
                case CommentType.POST -> "post";
                case CommentType.EOL -> "end-of-line";
                case CommentType.PLATE -> "plate";
                case CommentType.REPEATABLE -> "repeatable";
                default -> throw new RuntimeException("Missing comment type support: " + type.name());
            };
            CommentsSarifMgr.commentTags[type.ordinal()] = tag;
            commentTypeMap.put(tag, type);
        }
    }
}

