/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.ColorValue;
import generic.theme.FontValue;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.ThemeManager;
import ghidra.util.Msg;
import java.awt.Color;
import java.awt.Font;

public class HeadlessThemeManager
extends ThemeManager {
    public static void initialize() {
        if (INSTANCE instanceof HeadlessThemeManager) {
            Msg.error(HeadlessThemeManager.class, (Object)"Attempted to initialize theming more than once!");
            return;
        }
        HeadlessThemeManager themeManager = new HeadlessThemeManager();
        themeManager.doInitialize();
    }

    public HeadlessThemeManager() {
        INSTANCE = this;
        this.installInGui();
    }

    private void doInitialize() {
        this.initializeSystemValues();
        this.buildCurrentValues();
        GColor.refreshAll(this.currentValues);
        GIcon.refreshAll(this.currentValues);
    }

    private void initializeSystemValues() {
        Font font = new Font("Arial", 0, 12);
        this.javaDefaults.addFont(new FontValue("system.font.control", font));
        this.javaDefaults.addFont(new FontValue("system.font.view", font));
        this.javaDefaults.addFont(new FontValue("system.font.menu", font));
        this.javaDefaults.addColor(new ColorValue("system.color.bg.control", Color.CYAN));
        this.javaDefaults.addColor(new ColorValue("system.color.bg.view", Color.CYAN));
        this.javaDefaults.addColor(new ColorValue("system.color.bg.tooltip", Color.CYAN));
        this.javaDefaults.addColor(new ColorValue("system.color.bg.selected.view", Color.CYAN));
        this.javaDefaults.addColor(new ColorValue("system.color.bg.border", Color.CYAN));
        this.javaDefaults.addColor(new ColorValue("system.color.fg.control", Color.CYAN));
        this.javaDefaults.addColor(new ColorValue("system.color.fg.view", Color.CYAN));
        this.javaDefaults.addColor(new ColorValue("system.color.fg.tooltip", Color.CYAN));
        this.javaDefaults.addColor(new ColorValue("system.color.fg.selected.view", Color.CYAN));
        this.javaDefaults.addColor(new ColorValue("system.color.fg.disabled", Color.CYAN));
    }
}

