/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.util;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.Table;
import db.util.ErrorHandler;
import ghidra.util.datastruct.IndexRange;
import ghidra.util.datastruct.IndexRangeIterator;
import ghidra.util.exception.NotYetImplementedException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

@Deprecated
public class SharedRangeMapDB {
    private DBHandle dbHandle;
    private ErrorHandler errHandler;
    Table rangeTable;
    Table mapTable;
    private static final String RANGES_TABLE_NAME_PREFIX = "Shared Ranges - ";
    private static final String MAP_TABLE_NAME_PREFIX = "Shared Map - ";
    private static final Schema RANGES_SCHEMA = SharedRangeMapDB.createRangesSchema();
    private static final Schema MAP_SCHEMA = SharedRangeMapDB.createMapSchema();
    static final int RANGE_TO_COL = 0;
    static final int MAP_VALUE_COL = 0;
    static final int MAP_RANGE_KEY_COL = 1;
    private static final int[] MAP_INDEXED_COLS = new int[]{0, 1};

    private static Schema createRangesSchema() {
        return new Schema(0, "From", new Field[]{LongField.INSTANCE}, new String[]{"To"});
    }

    private static Schema createMapSchema() {
        return new Schema(0, "Key", new Field[]{LongField.INSTANCE, LongField.INSTANCE}, new String[]{"Value", "Range Key"});
    }

    public SharedRangeMapDB(DBHandle dbHandle, String name, ErrorHandler errHandler, boolean create) {
        this.dbHandle = dbHandle;
        this.errHandler = errHandler;
        String rangeTableName = RANGES_TABLE_NAME_PREFIX + name;
        String mapTableName = MAP_TABLE_NAME_PREFIX + name;
        if (create) {
            try {
                this.rangeTable = dbHandle.createTable(rangeTableName, RANGES_SCHEMA);
                this.mapTable = dbHandle.createTable(mapTableName, MAP_SCHEMA, MAP_INDEXED_COLS);
            }
            catch (IOException e) {
                errHandler.dbError(e);
            }
        } else {
            this.rangeTable = dbHandle.getTable(rangeTableName);
            if (this.rangeTable == null) {
                errHandler.dbError(new IOException("Table not found: " + rangeTableName));
            }
            this.mapTable = dbHandle.getTable(mapTableName);
            if (this.mapTable == null) {
                errHandler.dbError(new IOException("Table not found: " + mapTableName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DBHandle dBHandle = this.dbHandle;
        synchronized (dBHandle) {
            if (this.rangeTable != null) {
                try {
                    this.dbHandle.deleteTable(this.rangeTable.getName());
                    this.dbHandle.deleteTable(this.mapTable.getName());
                }
                catch (IOException e) {
                    this.errHandler.dbError(e);
                }
                this.rangeTable = null;
                this.mapTable = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long start, long end, long value) {
        DBHandle dBHandle = this.dbHandle;
        synchronized (dBHandle) {
            try {
                long endRange;
                Field[] mapKeys = this.mapTable.findRecords((Field)new LongField(value), 0);
                for (int i = 0; i < mapKeys.length; ++i) {
                    Field mapKey = mapKeys[i];
                    DBRecord mapRec = this.mapTable.getRecord(mapKey);
                    long rangeKey = mapRec.getLongValue(1);
                    DBRecord rangeRec = this.rangeTable.getRecord(rangeKey);
                    long min = rangeKey;
                    long max = rangeRec.getLongValue(0);
                    if (min <= start) {
                        if (max >= end) {
                            return;
                        }
                        if (max < start - 1L) continue;
                        this.mapTable.deleteRecord(mapKey);
                        this.consolidateRange(rangeKey, max);
                        start = min;
                        continue;
                    }
                    if (min > end + 1L) continue;
                    this.mapTable.deleteRecord(mapKey);
                    this.consolidateRange(rangeKey, max);
                    if (max <= end) continue;
                    end = max;
                }
                DBRecord rangeRec = this.rangeTable.getRecordBefore(start);
                if (rangeRec != null && (endRange = rangeRec.getLongValue(0)) >= start) {
                    rangeRec = this.splitRange(rangeRec, start - 1L);
                    if (endRange >= end) {
                        if (endRange > end) {
                            this.splitRange(rangeRec, end);
                        }
                        this.insertMapEntry(start, value);
                        return;
                    }
                    this.insertMapEntry(start, value);
                    start = endRange + 1L;
                }
                RecordIterator iter = this.rangeTable.iterator(start, end, start);
                while (iter.hasNext()) {
                    rangeRec = iter.next();
                    long startRange = rangeRec.getKey();
                    long endRange2 = rangeRec.getLongValue(0);
                    if (startRange > start) {
                        this.insertRangeEntry(start, startRange - 1L);
                        this.insertMapEntry(start, value);
                        start = startRange;
                    }
                    if (endRange2 >= end) {
                        if (endRange2 > end) {
                            this.splitRange(rangeRec, end);
                        }
                        this.insertMapEntry(start, value);
                        return;
                    }
                    if (startRange != start) {
                        rangeRec = this.splitRange(rangeRec, endRange2 - 1L);
                    }
                    this.insertMapEntry(start, value);
                    start = endRange2 + 1L;
                }
                this.insertRangeEntry(start, end);
                this.insertMapEntry(start, value);
            }
            catch (IOException e) {
                this.errHandler.dbError(e);
            }
        }
    }

    private void insertMapEntry(long rangeKey, long value) throws IOException {
        DBRecord rec = MAP_SCHEMA.createRecord(this.mapTable.getMaxKey() + 1L);
        rec.setLongValue(1, rangeKey);
        rec.setLongValue(0, value);
        this.mapTable.putRecord(rec);
    }

    private void insertRangeEntry(long start, long end) throws IOException {
        DBRecord rec = RANGES_SCHEMA.createRecord(start);
        rec.setLongValue(0, end);
        this.rangeTable.putRecord(rec);
    }

    private DBRecord splitRange(DBRecord rangeRecord, long newEnd) throws IOException {
        DBRecord newRange = RANGES_SCHEMA.createRecord(newEnd + 1L);
        newRange.setField(0, rangeRecord.getFieldValue(0));
        rangeRecord.setLongValue(0, newEnd);
        this.rangeTable.putRecord(rangeRecord);
        this.rangeTable.putRecord(newRange);
        Field[] mapKeys = this.mapTable.findRecords(rangeRecord.getKeyField(), 1);
        for (int i = 0; i < mapKeys.length; ++i) {
            DBRecord mapRec = this.mapTable.getRecord(mapKeys[i]);
            mapRec.setKey(this.mapTable.getMaxKey() + 1L);
            mapRec.setField(1, newRange.getKeyField());
            this.mapTable.putRecord(mapRec);
        }
        return newRange;
    }

    private Field[] getMapValues(Field[] mapKeys) throws IOException {
        Object[] values = new Field[mapKeys.length];
        for (int i = 0; i < mapKeys.length; ++i) {
            DBRecord rec = this.mapTable.getRecord(mapKeys[i]);
            values[i] = rec.getFieldValue(0);
        }
        Arrays.sort(values);
        return values;
    }

    private void consolidateRange(long rangeKey, long end) throws IOException {
        int i;
        Field[] keys;
        Field[] mapKeys = this.mapTable.findRecords((Field)new LongField(rangeKey), 1);
        Object[] values = this.getMapValues(mapKeys);
        if (mapKeys.length == 0) {
            this.rangeTable.deleteRecord(rangeKey);
            return;
        }
        DBRecord rangeRec = this.rangeTable.getRecordBefore(rangeKey);
        if (rangeRec != null && rangeRec.getLongValue(0) == rangeKey - 1L && Arrays.equals(this.getMapValues(keys = this.mapTable.findRecords(rangeRec.getKeyField(), 1)), values)) {
            this.rangeTable.deleteRecord(rangeKey);
            rangeRec.setLongValue(0, end);
            this.rangeTable.putRecord(rangeRec);
            for (i = 0; i < mapKeys.length; ++i) {
                this.mapTable.deleteRecord(mapKeys[i]);
            }
            rangeKey = rangeRec.getKey();
        }
        if ((rangeRec = this.rangeTable.getRecordAfter(end)) != null && rangeRec.getKey() == end + 1L && Arrays.equals(this.getMapValues(keys = this.mapTable.findRecords(rangeRec.getKeyField(), 1)), values)) {
            this.rangeTable.deleteRecord(rangeRec.getKey());
            rangeRec.setKey(rangeKey);
            this.rangeTable.putRecord(rangeRec);
            for (i = 0; i < keys.length; ++i) {
                this.mapTable.deleteRecord(keys[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long value) {
        DBHandle dBHandle = this.dbHandle;
        synchronized (dBHandle) {
            try {
                Field[] mapKeys = this.mapTable.findRecords((Field)new LongField(value), 0);
                for (int i = 0; i < mapKeys.length; ++i) {
                    Field mapKey = mapKeys[i];
                    DBRecord mapRec = this.mapTable.getRecord(mapKey);
                    this.mapTable.deleteRecord(mapKey);
                    long rangeKey = mapRec.getLongValue(1);
                    DBRecord rangeRec = this.rangeTable.getRecord(rangeKey);
                    this.consolidateRange(rangeKey, rangeRec.getLongValue(0));
                }
            }
            catch (IOException e) {
                this.errHandler.dbError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Field> getValueIterator(long start, long end) {
        DBHandle dBHandle = this.dbHandle;
        synchronized (dBHandle) {
            return new ValueIterator(start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexRangeIterator getValueRangeIterator(long value) {
        DBHandle dBHandle = this.dbHandle;
        synchronized (dBHandle) {
            try {
                return new RangeIterator(value);
            }
            catch (IOException e) {
                this.errHandler.dbError(e);
                return null;
            }
        }
    }

    private class ValueIterator
    implements Iterator<Field> {
        private RecordIterator mapRecIter;
        private Field nextValue;
        private HashSet<Field> returnedValues = new HashSet();

        ValueIterator(long start, long end) {
            try {
                DBRecord rec = SharedRangeMapDB.this.rangeTable.getRecordAtOrBefore(start);
                if (rec != null && rec.getLongValue(0) >= start) {
                    start = rec.getKey();
                }
                this.mapRecIter = SharedRangeMapDB.this.mapTable.indexIterator(1, (Field)new LongField(start), (Field)new LongField(end), true);
            }
            catch (IOException e) {
                SharedRangeMapDB.this.errHandler.dbError(e);
            }
        }

        @Override
        public void remove() {
            throw new NotYetImplementedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            DBHandle dBHandle = SharedRangeMapDB.this.dbHandle;
            synchronized (dBHandle) {
                try {
                    DBRecord rec;
                    while (this.nextValue == null && (rec = this.mapRecIter.next()) != null) {
                        this.nextValue = rec.getFieldValue(0);
                        if (this.returnedValues.add(this.nextValue)) continue;
                        this.nextValue = null;
                    }
                }
                catch (IOException e) {
                    SharedRangeMapDB.this.errHandler.dbError(e);
                }
                return this.nextValue != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Field next() {
            DBHandle dBHandle = SharedRangeMapDB.this.dbHandle;
            synchronized (dBHandle) {
                if (this.nextValue != null || this.hasNext()) {
                    Field v = this.nextValue;
                    this.nextValue = null;
                    return v;
                }
                return null;
            }
        }
    }

    private class RangeIterator
    implements IndexRangeIterator {
        private RecordIterator recordIter;

        RangeIterator(long value) throws IOException {
            LongField val = new LongField(value);
            this.recordIter = SharedRangeMapDB.this.mapTable.indexIterator(0, (Field)val, (Field)val, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            DBHandle dBHandle = SharedRangeMapDB.this.dbHandle;
            synchronized (dBHandle) {
                try {
                    return this.recordIter.hasNext();
                }
                catch (IOException e) {
                    SharedRangeMapDB.this.errHandler.dbError(e);
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexRange next() {
            DBHandle dBHandle = SharedRangeMapDB.this.dbHandle;
            synchronized (dBHandle) {
                try {
                    DBRecord rec = this.recordIter.next();
                    if (rec != null) {
                        long rangeKey = rec.getLongValue(1);
                        rec = SharedRangeMapDB.this.rangeTable.getRecord(rangeKey);
                        return new IndexRange(rec.getKey(), rec.getLongValue(0));
                    }
                }
                catch (IOException e) {
                    SharedRangeMapDB.this.errHandler.dbError(e);
                }
                return null;
            }
        }
    }
}

