/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.OperandValue;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.symbol.SpecificSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import java.util.ArrayList;

public class OperandSymbol
extends SpecificSymbol {
    private int reloffset;
    private int offsetbase;
    private int minimumlength;
    private int hand;
    private OperandValue localexp;
    private TripleSymbol triple;
    private PatternExpression defexp;
    private boolean codeaddress;

    public int getRelativeOffset() {
        return this.reloffset;
    }

    public int getOffsetBase() {
        return this.offsetbase;
    }

    public int getMinimumLength() {
        return this.minimumlength;
    }

    public PatternExpression getDefiningExpression() {
        return this.defexp;
    }

    public TripleSymbol getDefiningSymbol() {
        return this.triple;
    }

    public int getIndex() {
        return this.hand;
    }

    public boolean isCodeAddress() {
        return this.codeaddress;
    }

    @Override
    public PatternExpression getPatternExpression() {
        return this.localexp;
    }

    @Override
    public void getFixedHandle(FixedHandle hnd, ParserWalker walker) {
        FixedHandle h = walker.getFixedHandle(this.hand);
        hnd.space = h.space;
        hnd.offset_space = h.offset_space;
        hnd.offset_offset = h.offset_offset;
        hnd.offset_size = h.offset_size;
        hnd.size = h.size;
        hnd.temp_space = h.temp_space;
        hnd.temp_offset = h.temp_offset;
    }

    @Override
    public String print(ParserWalker walker) throws MemoryAccessException {
        long val;
        walker.pushOperand(this.hand);
        Object res = this.triple != null ? (this.triple instanceof SubtableSymbol ? walker.getConstructor().print(walker) : this.triple.print(walker)) : ((val = this.defexp.getValue(walker)) >= 0L ? "0x" + Long.toHexString(val) : "-0x" + Long.toHexString(-val));
        walker.popOperand();
        return res;
    }

    @Override
    public void printList(ParserWalker walker, ArrayList<Object> list) throws MemoryAccessException {
        walker.pushOperand(this.hand);
        if (this.triple != null) {
            if (this.triple instanceof SubtableSymbol) {
                walker.getConstructor().printList(walker, list);
            } else {
                this.triple.printList(walker, list);
            }
        } else {
            FixedHandle handle = walker.getParentHandle();
            if (handle.offset_size == 0) {
                handle.offset_size = walker.getCurrentLength();
            }
            list.add(handle);
        }
        walker.popOperand();
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage lang) throws DecoderException {
        this.defexp = null;
        this.triple = null;
        this.codeaddress = false;
        int attrib = decoder.getNextAttributeId();
        while (attrib != 0) {
            if (attrib == SlaFormat.ATTRIB_INDEX.id()) {
                this.hand = (int)decoder.readSignedInteger();
            } else if (attrib == SlaFormat.ATTRIB_OFF.id()) {
                this.reloffset = (int)decoder.readSignedInteger();
            } else if (attrib == SlaFormat.ATTRIB_BASE.id()) {
                this.offsetbase = (int)decoder.readSignedInteger();
            } else if (attrib == SlaFormat.ATTRIB_MINLEN.id()) {
                this.minimumlength = (int)decoder.readSignedInteger();
            } else if (attrib == SlaFormat.ATTRIB_SUBSYM.id()) {
                int id = (int)decoder.readUnsignedInteger();
                this.triple = (TripleSymbol)lang.getSymbolTable().findSymbol(id);
            } else if (attrib == SlaFormat.ATTRIB_CODE.id()) {
                this.codeaddress = decoder.readBool();
            }
            attrib = decoder.getNextAttributeId();
        }
        this.localexp = (OperandValue)PatternExpression.decodeExpression(decoder, lang);
        if (decoder.peekElement() != 0) {
            this.defexp = PatternExpression.decodeExpression(decoder, lang);
        }
        decoder.closeElement(SlaFormat.ELEM_OPERAND_SYM.id());
    }

    public String toString() {
        return this.getName() + " : " + this.getId();
    }
}

