/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.parse;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

public class AssemblyParseStateItem
implements Comparable<AssemblyParseStateItem> {
    private final AssemblyProduction prod;
    private final int pos;

    public AssemblyParseStateItem(AssemblyProduction prod) {
        this(prod, 0);
    }

    public AssemblyParseStateItem(AssemblyProduction prod, int pos) {
        this.prod = prod;
        this.pos = pos;
        if (pos > prod.getRHS().size()) {
            throw new AssertionError((Object)"INTERNAL: Attempt to advance beyond end of RHS");
        }
    }

    public AssemblyParseStateItem read() {
        return new AssemblyParseStateItem(this.prod, this.pos + 1);
    }

    public AssemblySymbol getNext() {
        if (this.completed()) {
            return null;
        }
        return this.prod.getRHS().getSymbol(this.pos);
    }

    public Collection<AssemblyParseStateItem> getClosure(AssemblyGrammar grammar) {
        AssemblySymbol next = this.getNext();
        if (next == null) {
            return Collections.emptySet();
        }
        if (!(next instanceof AssemblyNonTerminal)) {
            return Collections.emptySet();
        }
        AssemblyNonTerminal nt = (AssemblyNonTerminal)next;
        TreeSet<AssemblyParseStateItem> result = new TreeSet<AssemblyParseStateItem>();
        for (AssemblyProduction subst : grammar.productionsOf(nt)) {
            result.add(new AssemblyParseStateItem(subst, 0));
        }
        return result;
    }

    public boolean equals(Object that) {
        if (!(that instanceof AssemblyParseStateItem)) {
            return false;
        }
        AssemblyParseStateItem apsi = (AssemblyParseStateItem)that;
        if (this.prod.getIndex() != apsi.prod.getIndex()) {
            return false;
        }
        return this.pos == apsi.pos;
    }

    @Override
    public int compareTo(AssemblyParseStateItem that) {
        int result = this.prod.getIndex() - that.prod.getIndex();
        if (result != 0) {
            return result;
        }
        result = this.pos - that.pos;
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public int hashCode() {
        int result = 0;
        result += this.prod.getIndex();
        result *= 31;
        return result += this.pos;
    }

    public String toString() {
        AssemblySentential rhs = this.prod.getRHS();
        AssemblySentential prec = rhs.sub(0, this.pos);
        AssemblySentential proc = rhs.sub(this.pos, rhs.size());
        StringBuilder sb = new StringBuilder(this.prod.getIndex() + ". " + String.valueOf(this.prod.getLHS()) + " => ");
        if (prec.size() != 0) {
            sb.append(String.valueOf(prec) + " ");
        }
        sb.append("*");
        if (proc.size() != 0) {
            sb.append(" " + String.valueOf(proc));
        }
        return sb.toString();
    }

    public boolean completed() {
        return this.pos == this.prod.getRHS().size();
    }

    public int getPos() {
        return this.pos;
    }

    public AssemblyProduction getProduction() {
        return this.prod;
    }
}

