/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.hyper;

import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.spatial.AbstractConstraintsTree;
import ghidra.util.database.spatial.AbstractConstraintsTreeSpatialMap;
import ghidra.util.database.spatial.AbstractRStarConstraintsTree;
import ghidra.util.database.spatial.BoundedShape;
import ghidra.util.database.spatial.DBTreeDataRecord;
import ghidra.util.database.spatial.DBTreeNodeRecord;
import ghidra.util.database.spatial.hyper.AbstractHyperBoxQuery;
import ghidra.util.database.spatial.hyper.Dimension;
import ghidra.util.database.spatial.hyper.EuclideanHyperSpace;
import ghidra.util.database.spatial.hyper.HyperBox;
import ghidra.util.database.spatial.hyper.HyperPoint;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractHyperRStarTree<P extends HyperPoint, DS extends BoundedShape<NS>, DR extends DBTreeDataRecord<DS, NS, T>, NS extends HyperBox<P, NS>, NR extends DBTreeNodeRecord<NS>, T, Q extends AbstractHyperBoxQuery<P, DS, NS, Q>>
extends AbstractRStarConstraintsTree<DS, DR, NS, NR, T, Q> {
    protected final EuclideanHyperSpace<P, NS> space;
    protected final List<Comparator<NS>> axes;

    protected <V> Comparator<NS> dimComparator(Dimension<V, P, NS> dim) {
        return Comparator.comparing(dim::lower, dim::compare);
    }

    public AbstractHyperRStarTree(DBCachedObjectStoreFactory storeFactory, String tableName, EuclideanHyperSpace<P, NS> space, Class<DR> dataType, Class<NR> nodeType, boolean upgradeable, int maxChildren) throws VersionException, IOException {
        super(storeFactory, tableName, dataType, nodeType, upgradeable, maxChildren);
        this.space = space;
        this.axes = space.getDimensions().stream().map(this::dimComparator).toList();
    }

    @Override
    protected List<Comparator<NS>> getSplitAxes() {
        return this.axes;
    }

    @Override
    protected Comparator<NS> getDefaultBoundsComparator() {
        return this.axes.get(0);
    }

    @Override
    public AbstractConstraintsTreeSpatialMap<DS, DR, NS, T, Q> asSpatialMap() {
        return new AsSpatialMap(this, null);
    }

    protected static class AsSpatialMap<DS extends BoundedShape<NS>, DR extends DBTreeDataRecord<DS, NS, T>, NS extends HyperBox<?, NS>, T, Q extends AbstractHyperBoxQuery<?, DS, NS, Q>>
    extends AbstractConstraintsTreeSpatialMap<DS, DR, NS, T, Q> {
        public AsSpatialMap(AbstractConstraintsTree<DS, DR, NS, ?, T, Q> tree, Q query) {
            super(tree, query);
        }

        public AsSpatialMap<DS, DR, NS, T, Q> reduce(Q andQuery) {
            return new AsSpatialMap<DS, DR, NS, T, Q>(this.tree, this.query == null ? andQuery : ((AbstractHyperBoxQuery)this.query).and(andQuery));
        }
    }
}

