/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.model;

import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.MathUtilities;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class GAddressRangeField
extends JPanel {
    private static final Font MONOSPACED = Font.decode("monospaced");
    private final JComboBox<String> fieldSpace = new JComboBox();
    private final JTextField fieldMin = new JTextField("0");
    private final JTextField fieldMax = new JTextField("0");
    private final DefaultComboBoxModel<String> modelSpace = new DefaultComboBoxModel();
    private AddressFactory factory;

    public GAddressRangeField() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel("["));
        this.fieldSpace.setFont(MONOSPACED);
        this.add(this.fieldSpace);
        this.add(new JLabel(":"));
        this.fieldMin.setFont(MONOSPACED);
        this.add(this.fieldMin);
        this.add(new JLabel(", "));
        this.fieldMax.setFont(MONOSPACED);
        this.add(this.fieldMax);
        this.add(new JLabel("]"));
        this.fieldSpace.setEditable(false);
        this.fieldSpace.setModel(this.modelSpace);
        this.fieldSpace.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GAddressRangeField.this.spaceFocusLost(e);
                GAddressRangeField.this.checkDispatchFocus(e);
            }
        });
        this.fieldMin.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GAddressRangeField.this.minFocusLost(e);
                GAddressRangeField.this.checkDispatchFocus(e);
            }
        });
        this.fieldMax.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GAddressRangeField.this.maxFocusLost(e);
                GAddressRangeField.this.checkDispatchFocus(e);
            }
        });
    }

    protected void checkDispatchFocus(FocusEvent e) {
        Component opp = e.getOppositeComponent();
        if (opp == null || !SwingUtilities.isDescendingFrom(opp, this)) {
            this.dispatchEvent(e);
        }
    }

    public void setAddressFactory(AddressFactory factory) {
        this.factory = factory;
        this.modelSpace.removeAllElements();
        if (factory != null) {
            for (AddressSpace space : factory.getAddressSpaces()) {
                this.modelSpace.addElement(space.getName());
            }
            this.modelSpace.setSelectedItem(factory.getDefaultAddressSpace().getName());
            this.revalidateMin();
            this.revalidateMax();
            this.adjustMaxToMin();
        }
    }

    protected AddressSpace getSpace(boolean required) {
        AddressSpace space = this.factory.getAddressSpace((String)this.fieldSpace.getSelectedItem());
        if (required) {
            return Objects.requireNonNull(space);
        }
        return space;
    }

    protected long parseLong(String text, long defaultVal) {
        try {
            return Long.parseUnsignedLong(text, 16);
        }
        catch (NumberFormatException ex) {
            return defaultVal;
        }
    }

    protected void revalidateMin() {
        AddressSpace space = this.getSpace(true);
        long spaceMin = space.getMinAddress().getOffset();
        long min = MathUtilities.unsignedMax((long)this.parseLong(this.fieldMin.getText(), spaceMin), (long)spaceMin);
        this.fieldMin.setText(Long.toUnsignedString(min, 16));
    }

    protected void revalidateMax() {
        AddressSpace space = this.getSpace(true);
        long spaceMax = space.getMaxAddress().getOffset();
        long max = MathUtilities.unsignedMin((long)this.parseLong(this.fieldMax.getText(), spaceMax), (long)spaceMax);
        this.fieldMax.setText(Long.toUnsignedString(max, 16));
    }

    protected void adjustMaxToMin() {
        AddressSpace space = this.getSpace(true);
        long spaceMin = space.getMinAddress().getOffset();
        long min = this.parseLong(this.fieldMin.getText(), spaceMin);
        long max = MathUtilities.unsignedMax((long)min, (long)this.parseLong(this.fieldMax.getText(), min));
        this.fieldMax.setText(Long.toUnsignedString(max, 16));
    }

    protected void adjustMinToMax() {
        AddressSpace space = this.getSpace(true);
        long spaceMax = space.getMaxAddress().getOffset();
        long max = this.parseLong(this.fieldMax.getText(), spaceMax);
        long min = MathUtilities.unsignedMin((long)max, (long)this.parseLong(this.fieldMin.getText(), max));
        this.fieldMin.setText(Long.toUnsignedString(min, 16));
    }

    protected void spaceFocusLost(FocusEvent e) {
        if (this.factory == null) {
            return;
        }
        this.revalidateMin();
        this.revalidateMax();
        this.adjustMaxToMin();
    }

    protected void minFocusLost(FocusEvent e) {
        if (this.factory == null) {
            return;
        }
        this.revalidateMin();
        this.adjustMaxToMin();
    }

    protected void maxFocusLost(FocusEvent e) {
        if (this.factory == null) {
            return;
        }
        this.revalidateMax();
        this.adjustMinToMax();
    }

    public void setRange(AddressRange range) {
        if (this.factory == null) {
            throw new IllegalStateException("Must set address factory first.");
        }
        if (!List.of(this.factory.getAddressSpaces()).contains(range.getAddressSpace())) {
            throw new IllegalArgumentException("Given range's space must be in the factory's physical spaces");
        }
        this.fieldSpace.setSelectedItem(range.getAddressSpace().getName());
        this.fieldMin.setText(Long.toUnsignedString(range.getMinAddress().getOffset(), 16));
        this.fieldMax.setText(Long.toUnsignedString(range.getMaxAddress().getOffset(), 16));
    }

    public AddressRange getRange() {
        String name = (String)this.fieldSpace.getSelectedItem();
        if (name == null) {
            return null;
        }
        AddressSpace space = Objects.requireNonNull(this.factory.getAddressSpace(name));
        long min = Long.parseUnsignedLong(this.fieldMin.getText(), 16);
        long max = Long.parseUnsignedLong(this.fieldMax.getText(), 16);
        return new AddressRangeImpl(space.getAddress(min), space.getAddress(max));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fieldSpace.setEnabled(enabled);
        this.fieldMin.setEnabled(enabled);
        this.fieldMax.setEnabled(enabled);
    }
}

