/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.add;

import docking.widgets.checkbox.GCheckBox;
import ghidra.feature.vt.api.main.VTProgramCorrelatorAddressRestrictionPreference;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.gui.wizard.add.AddToSessionData;
import ghidra.util.HTMLUtilities;
import ghidra.util.layout.VerticalLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AddressSetOptionsPanel
extends JPanel {
    private JCheckBox excludeCheckbox;
    private JCheckBox limitAddressSetsCheckbox;

    public AddressSetOptionsPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(40, 40, 0, 0));
        this.excludeCheckbox = new GCheckBox("Exclude accepted matches", false);
        String excludeAcceptedTooltip = "This option will cause the correlator algorithm to <b>not</b> consider any functions or data that have already been accepted. Using this option can greatly speed up the processing time of the correlator algorithm; however, this options should only be used when you trust that your accepted matches are correct.";
        this.excludeCheckbox.setToolTipText(HTMLUtilities.toWrappedHTML((String)excludeAcceptedTooltip));
        this.limitAddressSetsCheckbox = new GCheckBox("Limit source and destination address sets");
        String manuallyLimitTooltip = "Selecting this checkbox will trigger additional wizard  panels allowing you to customize the address sets used  by the selected algorithm.  When not selected, the entire address space is used.";
        this.limitAddressSetsCheckbox.setToolTipText(HTMLUtilities.toWrappedHTML((String)manuallyLimitTooltip));
        this.add(this.excludeCheckbox);
        this.add(this.limitAddressSetsCheckbox);
        this.setLayout((LayoutManager)new VerticalLayout(20));
    }

    public void initialize(AddToSessionData data) {
        this.excludeCheckbox.setSelected(data.shouldExcludeAcceptedMatches());
        this.limitAddressSetsCheckbox.setSelected(data.shouldLimitAddressSets());
        if (this.allowRestrictions(data.getCorrelators())) {
            this.excludeCheckbox.setEnabled(true);
        } else {
            this.excludeCheckbox.setSelected(false);
            this.excludeCheckbox.setEnabled(false);
        }
    }

    private boolean allowRestrictions(List<VTProgramCorrelatorFactory> list) {
        for (VTProgramCorrelatorFactory factory : list) {
            if (factory.getAddressRestrictionPreference() == VTProgramCorrelatorAddressRestrictionPreference.RESTRICTION_NOT_ALLOWED) continue;
            return true;
        }
        return false;
    }

    void updateChoices(AddToSessionData data) {
        data.setShouldExcludeAcceptedMatches(this.excludeCheckbox.isSelected());
        data.setShouldLimitAddressSets(this.limitAddressSetsCheckbox.isSelected());
    }
}

