/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import ghidra.feature.vt.gui.editors.DisplayableAddress;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;

public class DisplayableLocalVariableAddress
implements DisplayableAddress {
    protected final Function function;
    protected Address localVariableAddress;

    public DisplayableLocalVariableAddress(Function function, Address localVariableAddress) {
        this.function = function;
        this.localVariableAddress = localVariableAddress;
    }

    @Override
    public Program getProgram() {
        return this.function.getProgram();
    }

    @Override
    public Address getAddress() {
        return this.localVariableAddress;
    }

    @Override
    public String getDisplayString() {
        Variable localVariable = this.getLocalVariable(this.function, this.localVariableAddress);
        return this.getDisplayValue(localVariable);
    }

    public String getDisplayValue(Variable localVariable) {
        if (localVariable == null) {
            return "No Address";
        }
        return this.getString(localVariable) + localVariable.getVariableStorage().toString();
    }

    private Variable getLocalVariable(Function functionToUse, Address localAddressToGet) {
        Variable[] localVariables;
        if (functionToUse == null || localAddressToGet == null) {
            return null;
        }
        for (Variable local : localVariables = functionToUse.getLocalVariables()) {
            if (!local.getMinAddress().equals((Object)localAddressToGet)) continue;
            return local;
        }
        return null;
    }

    private String getString(Variable localVariable) {
        return localVariable != null ? "Local @ " : "";
    }

    public String toString() {
        return this.getDisplayString();
    }

    @Override
    public int compareTo(DisplayableAddress otherDisplayableAddress) {
        if (otherDisplayableAddress == null) {
            return 1;
        }
        Address otherAddress = otherDisplayableAddress.getAddress();
        if (this.localVariableAddress == null) {
            return otherAddress == null ? 0 : -1;
        }
        if (otherAddress == null) {
            return 1;
        }
        return this.localVariableAddress.compareTo((Object)otherAddress);
    }
}

