/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import generic.lsh.LSHMemoryModel;
import ghidra.feature.vt.api.main.VTProgramCorrelatorAddressRestrictionPreference;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.util.HelpLocation;

public abstract class VTAbstractReferenceProgramCorrelatorFactory
extends VTAbstractProgramCorrelatorFactory {
    public static final String MEMORY_MODEL = "Memory model";
    public static final LSHMemoryModel MEMORY_MODEL_DEFAULT = LSHMemoryModel.LARGE;
    public static final String MEMORY_MODEL_DESC = "Larger memory model results in faster runtime.";
    public static final String CONFIDENCE_THRESHOLD = "Confidence threshold (info content)";
    public static final double CONFIDENCE_THRESHOLD_DEFAULT = 1.0;
    public static final String CONFIDENCE_THRESHOLD_DESC = "Minimum bit threshold should be > 0.0";
    public static final String SIMILARITY_THRESHOLD = "Minimum similarity threshold (score)";
    public static final String SIMILARITY_THRESHOLD_DESC = "Similarity should be between 0 and 1";
    public static final double SIMILARITY_THRESHOLD_DEFAULT = 0.5;
    public static final String REFINE_RESULTS = "Refine Results";
    public static final boolean REFINE_RESULTS_DEFAULT = true;
    public static final String REFINE_RESULTS_DESC = "Remove results that have conflicting scores.";
    private static final String helpLocationTopic = "VersionTrackingPlugin";
    public String correlatorName = "CORRELATOR_NAME";
    protected String correlatorDescription = "DECRIBE_HOW_THE_CORRELATORS_MAKE_MATCHES.";
    protected String helpLocationAnchor = "Options_Panel";

    public VTAbstractReferenceProgramCorrelatorFactory() {
        super(VTProgramCorrelatorAddressRestrictionPreference.RESTRICTION_NOT_ALLOWED);
    }

    @Override
    public VTOptions createDefaultOptions() {
        VTOptions options = new VTOptions(this.correlatorName);
        HelpLocation help = new HelpLocation(helpLocationTopic, this.helpLocationAnchor);
        options.setOptionsHelpLocation(help);
        options.registerOption(MEMORY_MODEL, MEMORY_MODEL_DEFAULT, help, MEMORY_MODEL_DESC);
        options.registerOption(CONFIDENCE_THRESHOLD, 1.0, help, CONFIDENCE_THRESHOLD_DESC);
        options.registerOption(SIMILARITY_THRESHOLD, 0.5, help, SIMILARITY_THRESHOLD_DESC);
        options.registerOption(REFINE_RESULTS, true, help, REFINE_RESULTS_DESC);
        options.setDouble(CONFIDENCE_THRESHOLD, 1.0);
        options.setDouble(SIMILARITY_THRESHOLD, 0.5);
        options.setEnum(MEMORY_MODEL, (Enum)MEMORY_MODEL_DEFAULT);
        options.setBoolean(REFINE_RESULTS, true);
        return options;
    }

    @Override
    public String getDescription() {
        return this.correlatorDescription;
    }

    public void setName(String name) {
        this.correlatorName = name;
    }

    @Override
    public String getName() {
        return this.correlatorName;
    }

    @Override
    public int getPriority() {
        return 49;
    }
}

