/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data.ISF;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ISF.AbstractIsfWriter;
import ghidra.program.model.data.ISF.IsfBuiltIn;
import ghidra.program.model.data.ISF.IsfComposite;
import ghidra.program.model.data.ISF.IsfDataTypeArray;
import ghidra.program.model.data.ISF.IsfDataTypeBitField;
import ghidra.program.model.data.ISF.IsfDataTypeDefault;
import ghidra.program.model.data.ISF.IsfDataTypeNull;
import ghidra.program.model.data.ISF.IsfDataTypeTypeDef;
import ghidra.program.model.data.ISF.IsfDynamicComponent;
import ghidra.program.model.data.ISF.IsfEnum;
import ghidra.program.model.data.ISF.IsfFunctionPointer;
import ghidra.program.model.data.ISF.IsfLinuxOS;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.data.ISF.IsfProducer;
import ghidra.program.model.data.ISF.IsfTypedObject;
import ghidra.program.model.data.ISF.IsfTypedefBase;
import ghidra.program.model.data.ISF.IsfTypedefPointer;
import ghidra.program.model.data.ISF.IsfUtilities;
import ghidra.program.model.data.ISF.IsfWinOS;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IsfDataTypeWriter
extends AbstractIsfWriter {
    protected Map<DataType, IsfObject> resolved = new HashMap<DataType, IsfObject>();
    private Map<String, DataType> resolvedTypeMap = new HashMap<String, DataType>();
    public List<String> deferredKeys = new ArrayList<String>();
    private Writer baseWriter;
    protected DataTypeManager dtm;
    private DataOrganization dataOrganization;
    protected JsonObject data = new JsonObject();
    protected JsonElement metadata;
    protected JsonElement baseTypes;
    protected JsonElement userTypes;
    protected JsonElement enums;
    protected JsonElement functions;
    protected JsonElement symbols;
    private List<Address> requestedAddresses = new ArrayList<Address>();
    private List<String> requestedSymbols = new ArrayList<String>();
    private List<DataType> requestedDataTypes = new ArrayList<DataType>();
    private boolean skipSymbols = false;
    private boolean skipTypes = false;

    public IsfDataTypeWriter(DataTypeManager dtm, List<DataType> target, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.baseWriter = baseWriter;
        this.dtm = dtm;
        if (dtm != null) {
            this.dataOrganization = dtm.getDataOrganization();
        }
        if (this.dataOrganization == null) {
            this.dataOrganization = DataOrganizationImpl.getDefaultOrganization();
        }
        this.metadata = new JsonObject();
        this.baseTypes = new JsonObject();
        this.userTypes = new JsonObject();
        this.enums = new JsonObject();
        this.functions = new JsonObject();
        this.symbols = new JsonObject();
        this.requestedDataTypes = target == null ? new ArrayList() : target;
        this.STRICT = true;
    }

    @Override
    public JsonObject getRootObject(TaskMonitor monitor) throws CancelledException, IOException {
        this.genRoot(monitor);
        return this.data;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genMetadata();
        this.genTypes(monitor);
        this.genSymbols(monitor);
        this.data.add("metadata", this.metadata);
        this.data.add("base_types", this.baseTypes);
        this.data.add("user_types", this.userTypes);
        this.data.add("enums", this.enums);
        this.data.add("symbols", this.symbols);
    }

    public void add(JsonElement parent, String optKey, JsonElement child) {
        JsonObject p;
        if (parent instanceof JsonObject) {
            p = (JsonObject)parent;
            p.add(optKey, child);
        }
        if (parent instanceof JsonArray) {
            p = (JsonArray)parent;
            p.add(child);
        }
    }

    private void genMetadata() {
        String oskey = "UNKNOWN";
        if (this.dtm instanceof ProgramDataTypeManager) {
            ProgramDataTypeManager pgmDtm = (ProgramDataTypeManager)this.dtm;
            Program program = pgmDtm.getProgram();
            Map metaData = program.getMetadata();
            JsonElement producer = this.gson.toJsonTree((Object)new IsfProducer(program));
            JsonObject os = new JsonObject();
            oskey = (String)metaData.get("Compiler ID");
            if (metaData.containsKey("PDB Loaded")) {
                os = this.gson.toJsonTree((Object)new IsfWinOS(metaData));
            } else if (metaData.containsKey("Executable Format") && ((String)metaData.get("Executable Format")).contains("ELF")) {
                oskey = "linux";
                os = this.gson.toJsonTree((Object)new IsfLinuxOS(this.gson, metaData));
            }
            if (this.metadata instanceof JsonObject) {
                ((JsonObject)this.metadata).addProperty("format", "6.2.0");
            }
            this.add(this.metadata, "producer", producer);
            this.add(this.metadata, oskey, (JsonElement)os);
        }
    }

    private void genSymbols(TaskMonitor monitor) {
        if (!this.skipSymbols && this.dtm instanceof ProgramDataTypeManager) {
            ProgramDataTypeManager pgmDtm = (ProgramDataTypeManager)this.dtm;
            Program program = pgmDtm.getProgram();
            Address imageBase = program.getImageBase();
            SymbolTable symbolTable = program.getSymbolTable();
            ReferenceManager referenceManager = program.getReferenceManager();
            ReferenceIterator xrefs = referenceManager.getExternalReferences();
            HashMap<String, Symbol> linkages = new HashMap<String, Symbol>();
            for (Reference reference : xrefs) {
                Address address = reference.getFromAddress();
                Address toAddress = reference.getToAddress();
                Symbol[] fromSymbol = symbolTable.getPrimarySymbol(address);
                Symbol toSymbol = symbolTable.getPrimarySymbol(toAddress);
                if (fromSymbol == null) continue;
                linkages.put(toSymbol.getName(), (Symbol)fromSymbol);
            }
            HashMap<String, JsonObject> map = new HashMap<String, JsonObject>();
            if (this.requestedSymbols.isEmpty()) {
                if (this.requestedAddresses.isEmpty()) {
                    SymbolIterator iterator = symbolTable.getSymbolIterator();
                    while (iterator.hasNext()) {
                        Symbol symbol = iterator.next();
                        this.symbolToJson(imageBase, symbolTable, linkages, map, symbol);
                    }
                } else {
                    for (Address address : this.requestedAddresses) {
                        Symbol[] symsFromAddr;
                        for (Symbol symbol : symsFromAddr = symbolTable.getSymbols(address.add(imageBase.getOffset()))) {
                            this.symbolToJson(imageBase, symbolTable, linkages, map, symbol);
                        }
                    }
                }
            } else {
                for (String string : this.requestedSymbols) {
                    SymbolIterator iter = symbolTable.getSymbols(string);
                    while (iter.hasNext()) {
                        Symbol symbol = iter.next();
                        this.symbolToJson(imageBase, symbolTable, linkages, map, symbol);
                    }
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                this.add(this.symbols, (String)entry.getKey(), (JsonElement)entry.getValue());
            }
            for (Map.Entry entry : map.entrySet()) {
                if (!((String)entry.getKey()).startsWith("_")) continue;
                String nu = ((String)entry.getKey()).substring(1);
                this.add(this.symbols, nu, (JsonElement)entry.getValue());
            }
        }
    }

    private void genTypes(TaskMonitor monitor) throws CancelledException, IOException {
        if (this.skipTypes) {
            return;
        }
        HashMap<String, DataType> map = new HashMap<String, DataType>();
        if (this.requestedDataTypes.isEmpty()) {
            this.dtm.getAllDataTypes(this.requestedDataTypes);
            this.addSingletons();
        }
        monitor.initialize((long)this.requestedDataTypes.size());
        for (DataType dataType : this.requestedDataTypes) {
            String key = dataType.getPathName();
            map.put(key, dataType);
        }
        ArrayList<String> keylist = new ArrayList<String>(map.keySet());
        Collections.sort(keylist);
        this.processMap(map, keylist, monitor);
        if (!this.deferredKeys.isEmpty()) {
            Msg.warn((Object)this, (Object)"Processing .conflict objects");
            ArrayList<String> defkeys = new ArrayList<String>();
            defkeys.addAll(this.deferredKeys);
            this.processMap(map, defkeys, monitor);
        }
    }

    private void processMap(Map<String, DataType> map, List<String> keylist, TaskMonitor monitor) throws CancelledException, IOException {
        JsonObject obj = new JsonObject();
        monitor.setMaximum((long)keylist.size());
        for (String key : keylist) {
            DataType dataType = map.get(key);
            if (DataTypeUtilities.isConflictDataType((DataType)dataType) || (obj = this.getObjectForDataType(dataType, monitor)) == null) continue;
            if (dataType instanceof FunctionDefinition) {
                this.add(this.functions, dataType.getPathName(), (JsonElement)obj);
            } else if (IsfUtilities.isBaseDataType(dataType)) {
                this.add(this.baseTypes, dataType.getPathName(), (JsonElement)obj);
            } else if (dataType instanceof TypeDef) {
                DataType baseDataType = ((TypeDef)dataType).getBaseDataType();
                if (IsfUtilities.isBaseDataType(baseDataType)) {
                    this.add(this.baseTypes, dataType.getPathName(), (JsonElement)obj);
                } else if (baseDataType instanceof Enum) {
                    this.add(this.enums, dataType.getPathName(), (JsonElement)obj);
                } else {
                    this.add(this.userTypes, dataType.getPathName(), (JsonElement)obj);
                }
            } else if (dataType instanceof Enum) {
                this.add(this.enums, dataType.getPathName(), (JsonElement)obj);
            } else if (dataType instanceof Composite) {
                this.add(this.userTypes, dataType.getPathName(), (JsonElement)obj);
            }
            monitor.increment();
        }
    }

    private void symbolToJson(Address imageBase, SymbolTable symbolTable, Map<String, Symbol> linkages, Map<String, JsonObject> map, Symbol symbol) {
        JsonObject sym;
        String key = symbol.getName();
        Address address = symbol.getAddress();
        JsonObject jsonObject = sym = map.containsKey(key) ? map.get(key) : new JsonObject();
        if (address.isExternalAddress()) {
            sym.addProperty("address", (Number)address.getOffset());
            if (linkages.containsKey(key)) {
                Symbol linkage = linkages.get(key);
                sym.addProperty("linkage_name", linkage.getName());
                sym.addProperty("address", (Number)linkage.getAddress().getOffset());
            }
        } else if (address.getAddressSpace().equals((Object)imageBase.getAddressSpace())) {
            sym.addProperty("address", (Number)address.subtract(imageBase));
        } else {
            sym.addProperty("address", (Number)address.getOffset());
        }
        map.put(symbol.getName(), sym);
        if (!symbol.isPrimary()) {
            Symbol primarySymbol = symbolTable.getPrimarySymbol(address);
            String primaryName = primarySymbol.getName();
            if (symbol.getName().contains(primaryName)) {
                sym.addProperty("linkage_name", symbol.getName());
                map.put(primaryName, sym);
            }
        }
    }

    @Override
    public void write(JsonObject obj) {
        this.gson.toJson((JsonElement)obj, this.writer);
    }

    protected void addSingletons() {
        this.add(this.baseTypes, "pointer", this.getTree(this.newTypedefPointer(null)));
        this.add(this.baseTypes, "undefined", this.getTree(this.newTypedefPointer(null)));
    }

    protected JsonObject getObjectForDataType(DataType dt, TaskMonitor monitor) throws IOException, CancelledException {
        IsfObject isf = this.getIsfObject(dt, monitor);
        if (isf != null) {
            JsonObject jobj = (JsonObject)this.getTree(isf);
            this.resolved.put(dt, isf);
            return jobj;
        }
        return null;
    }

    protected IsfObject getIsfObject(DataType dt, TaskMonitor monitor) throws IOException, CancelledException {
        if (dt == null) {
            throw new IOException("Null datatype passed to getIsfObject");
        }
        if (dt instanceof FactoryDataType) {
            Msg.error((Object)this, (Object)("Factory data types may not be written - type: " + String.valueOf(dt)));
        }
        if (dt instanceof BitFieldDataType) {
            Msg.error((Object)this, (Object)("BitField data types may not be written - type: " + String.valueOf(dt)));
        }
        if (dt instanceof Pointer || dt instanceof Array) {
            IsfObject type = this.getObjectDataType(IsfUtilities.getBaseDataType(dt));
            IsfTypedObject obj = this.newTypedObject(dt, type);
            return obj;
        }
        IsfObject res = this.resolve(dt = dt.clone(this.dtm));
        if (res != null) {
            return res;
        }
        if (dt instanceof Dynamic) {
            Dynamic dynamic = (Dynamic)dt;
            DataType rep = dynamic.getReplacementBaseType();
            return rep == null ? null : this.getIsfObject(rep, monitor);
        }
        if (dt instanceof TypeDef) {
            TypeDef typedef = (TypeDef)dt;
            return this.getObjectTypeDef(typedef, monitor);
        }
        if (dt instanceof Composite) {
            Composite composite = (Composite)dt;
            return new IsfComposite(composite, this, monitor);
        }
        if (dt instanceof Enum) {
            Enum enumm = (Enum)dt;
            return new IsfEnum(enumm);
        }
        if (dt instanceof BuiltInDataType) {
            BuiltInDataType builtin = (BuiltInDataType)dt;
            return new IsfBuiltIn(builtin);
        }
        if (!(dt instanceof BitFieldDataType || dt instanceof FunctionDefinition || dt.equals((Object)DataType.DEFAULT))) {
            Msg.warn((Object)this, (Object)("Unable to write datatype. Type unrecognized: " + String.valueOf(dt.getClass())));
        }
        return null;
    }

    public IsfObject resolve(DataType dt) {
        if (this.resolved.containsKey(dt)) {
            return this.resolved.get(dt);
        }
        DataType resolvedType = this.resolvedTypeMap.get(dt.getPathName());
        if (resolvedType != null) {
            if (resolvedType.isEquivalent(dt)) {
                return this.resolved.get(dt);
            }
            if (dt instanceof TypeDef) {
                DataType baseType = ((TypeDef)dt).getBaseDataType();
                if ((resolvedType instanceof Composite || resolvedType instanceof Enum) && baseType.isEquivalent(resolvedType)) {
                    return this.resolved.get(dt);
                }
            }
            Msg.warn((Object)this, (Object)("WARNING! conflicting data type names: " + dt.getPathName() + " - " + resolvedType.getPathName()));
            return this.resolved.get(dt);
        }
        this.resolvedTypeMap.put(dt.getPathName(), dt);
        return null;
    }

    private void clearResolve(String typedefName, DataType baseType) {
        if (baseType instanceof Composite || baseType instanceof Enum) {
            if (typedefName.equals(baseType.getPathName())) {
                this.resolvedTypeMap.remove(typedefName);
                return;
            }
        } else if (baseType instanceof Pointer && typedefName.startsWith("P")) {
            DataType dt = ((Pointer)baseType).getDataType();
            if (dt instanceof TypeDef) {
                dt = ((TypeDef)dt).getBaseDataType();
            }
            if (dt instanceof Composite && dt.getPathName().equals(typedefName.substring(1))) {
                this.resolvedTypeMap.remove(typedefName);
                return;
            }
        }
    }

    public IsfObject getObjectTypeDeclaration(DataTypeComponent component) {
        DataType dataType = component.getDataType();
        if (dataType instanceof Dynamic) {
            DataType replacementBaseType;
            Dynamic dynamic = (Dynamic)dataType;
            if (dynamic.canSpecifyLength() && (replacementBaseType = dynamic.getReplacementBaseType()) != null) {
                replacementBaseType = replacementBaseType.clone(this.dtm);
                IsfObject type = this.getObjectDataType(replacementBaseType);
                int elementLen = replacementBaseType.getLength();
                if (elementLen > 0) {
                    int elementCnt = (component.getLength() + elementLen - 1) / elementLen;
                    return this.newIsfDynamicComponent(dynamic, type, elementCnt);
                }
                Msg.error((Object)this, (Object)(dynamic.getClass().getSimpleName() + " returned bad replacementBaseType: " + replacementBaseType.getClass().getSimpleName()));
            }
            return null;
        }
        DataType baseDataType = IsfUtilities.getBaseDataType(dataType);
        if (baseDataType instanceof FunctionDefinition) {
            FunctionDefinition def = (FunctionDefinition)baseDataType;
            return new IsfFunctionPointer(def, baseDataType);
        }
        return this.getObjectDataType(dataType, component.getOffset());
    }

    public IsfObject getObjectDataType(DataType dataType) {
        return this.getObjectDataType(dataType, -1);
    }

    public IsfObject getObjectDataType(DataType dataType, int componentOffset) {
        if (dataType == null) {
            return new IsfDataTypeNull();
        }
        DataType baseType = IsfUtilities.getBaseDataType(dataType);
        if (!dataType.equals((Object)baseType)) {
            if (dataType instanceof Array) {
                Array arr = (Array)dataType;
                IsfObject type = this.getObjectDataType(arr.getDataType());
                return new IsfDataTypeArray(arr, type);
            }
            if (dataType instanceof BitFieldDataType) {
                BitFieldDataType bf = (BitFieldDataType)dataType;
                IsfObject type = this.getObjectDataType(bf.getBaseDataType());
                return new IsfDataTypeBitField(bf, componentOffset, type);
            }
            IsfObject baseObject = this.getObjectDataType(IsfUtilities.getBaseDataType(dataType));
            return new IsfDataTypeTypeDef(dataType, baseObject);
        }
        if (DataTypeUtilities.isConflictDataType((DataType)dataType) && !this.deferredKeys.contains(dataType.getPathName())) {
            this.deferredKeys.add(dataType.getPathName());
        }
        return new IsfDataTypeDefault(dataType);
    }

    protected IsfObject getObjectTypeDef(TypeDef typeDef, TaskMonitor monitor) throws CancelledException {
        DataType dataType = typeDef.getDataType();
        String typedefName = typeDef.getPathName();
        DataType baseType = typeDef.getDataType();
        try {
            if (baseType instanceof BuiltInDataType) {
                BuiltInDataType builtin = (BuiltInDataType)baseType;
                return this.newTypedefBase(typeDef);
            }
            if (!(baseType instanceof Pointer)) {
                IsfObject isfObject = this.getIsfObject(dataType, monitor);
                return this.newTypedefUser(typeDef, isfObject);
            }
            return this.newTypedefPointer(typeDef);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("TypeDef error: " + String.valueOf(e)));
            this.clearResolve(typedefName, baseType);
            return null;
        }
    }

    public void requestAddress(String key) throws IOException {
        DataTypeManager dataTypeManager = this.dtm;
        if (dataTypeManager instanceof ProgramDataTypeManager) {
            ProgramDataTypeManager pgmDtm = (ProgramDataTypeManager)dataTypeManager;
            try {
                Address address = pgmDtm.getProgram().getMinAddress().getAddress(key);
                if (address == null) {
                    Msg.error((Object)this, (Object)(String.valueOf(address) + " not found"));
                    return;
                }
                this.requestedAddresses.add(address);
            }
            catch (AddressFormatException e) {
                throw new IOException("Bad address format: " + key);
            }
        }
    }

    public void requestSymbol(String symbol) {
        if (symbol == null) {
            Msg.error((Object)this, (Object)(symbol + " not found"));
            return;
        }
        this.requestedSymbols.add(symbol);
    }

    public JsonWriter getWriter() {
        return this.writer;
    }

    public String toString() {
        return this.baseWriter.toString();
    }

    public void setSkipSymbols(boolean val) {
        this.skipSymbols = val;
    }

    public void setSkipTypes(boolean val) {
        this.skipTypes = val;
    }

    public IsfTypedefBase newTypedefBase(TypeDef typeDef) {
        return new IsfTypedefBase(typeDef);
    }

    public IsfTypedefPointer newTypedefPointer(TypeDef typeDef) {
        return new IsfTypedefPointer(typeDef);
    }

    public IsfObject newTypedefUser(TypeDef typeDef, IsfObject object) {
        return object;
    }

    public IsfTypedObject newTypedObject(DataType dt, IsfObject type) {
        return new IsfTypedObject(dt, type);
    }

    public IsfObject newIsfDynamicComponent(Dynamic dynamic, IsfObject type, int elementCnt) {
        return new IsfDynamicComponent(dynamic, type, elementCnt);
    }
}

