/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.IOException;
import java.nio.charset.Charset;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeConsole;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.ShellConsole;

class ShellConsolePrinter
implements NativeConsole.ConsolePrinter {
    private static final long serialVersionUID = 5869832740127501857L;

    ShellConsolePrinter() {
    }

    @Override
    public void print(Context context, Scriptable scriptable, NativeConsole.Level level, Object[] objectArray, ScriptStackElement[] scriptStackElementArray) {
        if (objectArray.length == 0) {
            return;
        }
        String string = NativeConsole.format(context, scriptable, objectArray);
        ShellConsole shellConsole = Main.getGlobal().getConsole(Charset.defaultCharset());
        try {
            shellConsole.println((Object)((Object)level) + " " + string);
            if (scriptStackElementArray != null) {
                for (ScriptStackElement scriptStackElement : scriptStackElementArray) {
                    shellConsole.println(scriptStackElement.toString());
                }
            }
        }
        catch (IOException iOException) {
            throw Context.reportRuntimeError(iOException.getMessage());
        }
    }
}

