/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.HheaTable;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;

public class HmtxTable
implements Table {
    private int[] _hMetrics;
    private short[] _leftSideBearing;
    private int _length;

    public HmtxTable(DataInput dataInput, int n, HheaTable hheaTable, MaxpTable maxpTable) throws IOException {
        int n2;
        this._hMetrics = new int[hheaTable.getNumberOfHMetrics()];
        for (n2 = 0; n2 < hheaTable.getNumberOfHMetrics(); ++n2) {
            this._hMetrics[n2] = dataInput.readUnsignedByte() << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
        }
        n2 = maxpTable.getNumGlyphs() - hheaTable.getNumberOfHMetrics();
        this._leftSideBearing = new short[n2];
        for (int i = 0; i < n2; ++i) {
            this._leftSideBearing[i] = dataInput.readShort();
        }
        this._length = n;
    }

    public int getAdvanceWidth(int n) {
        if (this._hMetrics == null) {
            return 0;
        }
        if (n < this._hMetrics.length) {
            return this._hMetrics[n] >> 16;
        }
        return this._hMetrics[this._hMetrics.length - 1] >> 16;
    }

    public short getLeftSideBearing(int n) {
        if (this._hMetrics == null) {
            return 0;
        }
        if (n < this._hMetrics.length) {
            return (short)(this._hMetrics[n] & 0xFFFF);
        }
        return this._leftSideBearing[n - this._hMetrics.length];
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'hmtx' Table - Horizontal Metrics\n---------------------------------\n");
        stringBuilder.append("Size = ").append(this._length).append(" bytes, ").append(this._hMetrics.length).append(" entries\n");
        for (n = 0; n < this._hMetrics.length; ++n) {
            stringBuilder.append("        ").append(n).append(". advWid: ").append(this.getAdvanceWidth(n)).append(", LSdBear: ").append(this.getLeftSideBearing(n)).append("\n");
        }
        for (n = 0; n < this._leftSideBearing.length; ++n) {
            stringBuilder.append("        LSdBear ").append(n + this._hMetrics.length).append(": ").append(this._leftSideBearing[n]).append("\n");
        }
        return stringBuilder.toString();
    }
}

