/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableForeignKey;
import org.jkiss.dbeaver.ext.db2.model.DB2TableKeyColumn;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2DeleteUpdateRule;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.utils.CommonUtils;

public class DB2TableReference
extends JDBCTableConstraint<DB2Table, DB2TableKeyColumn>
implements DBSTableForeignKey {
    private static final Log log = Log.getLog(DB2TableReference.class);
    private DB2Table refTable;
    private DB2DeleteUpdateRule deleteRule;
    private DB2DeleteUpdateRule updateRule;
    private List<DB2TableKeyColumn> columns;
    private DB2TableForeignKey referencedKey;

    public DB2TableReference(DBRProgressMonitor monitor, DB2Table db2Table, ResultSet dbResult) throws DBException {
        super((JDBCTable)db2Table, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTNAME"), null, DBSEntityConstraintType.FOREIGN_KEY, true);
        String refSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TABSCHEMA");
        String refTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABNAME");
        String constName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTNAME");
        this.refTable = DB2Utils.findTableBySchemaNameAndName(monitor, (DB2DataSource)db2Table.getDataSource(), refSchemaName, refTableName);
        if (this.refTable == null) {
            log.debug((Object)("Reference table '" + refTableName + "' not found in schema '" + refSchemaName + "'"));
        } else {
            this.referencedKey = this.refTable.getAssociation(monitor, constName);
            if (this.referencedKey == null) {
                log.debug((Object)("Foreign key '" + constName + "' not found in table '" + this.refTable.getName() + "'"));
            }
        }
        this.deleteRule = (DB2DeleteUpdateRule)CommonUtils.valueOf(DB2DeleteUpdateRule.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DELETERULE"));
        this.updateRule = (DB2DeleteUpdateRule)CommonUtils.valueOf(DB2DeleteUpdateRule.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"UPDATERULE"));
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return ((DB2Table)this.getTable()).getDataSource();
    }

    @Nullable
    public DB2Table getAssociatedEntity() {
        return this.refTable;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((DB2Table)this.getTable()).getContainer(), this.getTable(), this});
    }

    public List<DB2TableKeyColumn> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return this.columns;
    }

    public void setAttributeReferences(List<DB2TableKeyColumn> columns) {
        this.columns = columns;
    }

    @Property(viewable=true, order=3)
    public DB2Table getReferencedTable() {
        return this.refTable;
    }

    @Property(id="reference", viewable=false)
    @Nullable
    public DB2TableForeignKey getReferencedConstraint() {
        return this.referencedKey;
    }

    @Property(viewable=true, editable=false)
    @NotNull
    public DBSForeignKeyModifyRule getUpdateRule() {
        return this.updateRule.getRule();
    }

    @Property(viewable=true, editable=false)
    @NotNull
    public DBSForeignKeyModifyRule getDeleteRule() {
        return this.deleteRule.getRule();
    }
}

