/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.j2se.system;

import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Date;
import bt747.sys.interfaces.BT747File;
import bt747.sys.interfaces.BT747HashSet;
import bt747.sys.interfaces.BT747Hashtable;
import bt747.sys.interfaces.BT747HttpSender;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747RAFile;
import bt747.sys.interfaces.BT747Semaphore;
import bt747.sys.interfaces.BT747StringTokenizer;
import bt747.sys.interfaces.BT747Thread;
import bt747.sys.interfaces.BT747Time;
import bt747.sys.interfaces.BT747Vector;
import bt747.sys.interfaces.JavaLibImplementation;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Locale;
import net.sf.bt747.j2se.system.J2SEDate;
import net.sf.bt747.j2se.system.J2SEGeneric;
import net.sf.bt747.j2se.system.J2SEHashSet;
import net.sf.bt747.j2se.system.J2SEHashtable;
import net.sf.bt747.j2se.system.J2SEHttpSenderImpl;
import net.sf.bt747.j2se.system.J2SERAFile;
import net.sf.bt747.j2se.system.J2SESemaphore;
import net.sf.bt747.j2se.system.J2SEStringTokenizer;
import net.sf.bt747.j2se.system.J2SETime;
import net.sf.bt747.j2se.system.J2SEVector;
import net.sf.bt747.j2se.system.NRCDecoder;

public final class J2SEJavaTranslations
implements JavaLibImplementation {
    private static J2SEJavaTranslations singleton;
    private static final DecimalFormat[] nf;
    private static final long appStartTime;
    private static String appSettings;
    private BT747HttpSender httpSenderInstance = null;

    private J2SEJavaTranslations() {
    }

    public static final J2SEJavaTranslations getInstance() {
        if (singleton == null) {
            singleton = new J2SEJavaTranslations();
        }
        return singleton;
    }

    @Override
    public final BT747Date getDateInstance() {
        return new J2SEDate();
    }

    @Override
    public final BT747Date getDateInstance(int n, int n2, int n3) {
        return new J2SEDate(n, n2, n3);
    }

    @Override
    public final BT747Date getDateInstance(String string, byte by) {
        return new J2SEDate(string, by);
    }

    @Override
    public final BT747Hashtable getHashtableInstance(int n) {
        return new J2SEHashtable(n);
    }

    @Override
    public final BT747Vector getVectorInstance() {
        return new J2SEVector();
    }

    @Override
    public final BT747Time getTimeInstance() {
        return new J2SETime();
    }

    @Override
    public final BT747RAFile getRAFileInstance(BT747Path bT747Path) {
        return new J2SERAFile(bT747Path.getPath());
    }

    @Override
    public final BT747RAFile getRAFileInstance(BT747Path bT747Path, int n) {
        return new J2SERAFile(bT747Path.getPath(), n);
    }

    @Override
    public final BT747File getFileInstance(BT747Path bT747Path) {
        return new J2SERAFile(bT747Path.getPath());
    }

    @Override
    public final BT747File getFileInstance(BT747Path bT747Path, int n) {
        return this.getRAFileInstance(bT747Path, n);
    }

    @Override
    public final boolean isAvailable() {
        return true;
    }

    @Override
    public final void debug(String string, Throwable throwable) {
        J2SEGeneric.debug(string, throwable);
    }

    @Override
    public final double pow(double d, double d2) {
        return Math.pow(d, d2);
    }

    @Override
    public final double acos(double d) {
        return Math.acos(d);
    }

    @Override
    public final void addThread(BT747Thread bT747Thread, boolean bl) {
        J2SEGeneric.addThread(bT747Thread, bl);
    }

    @Override
    public final void removeThread(BT747Thread bT747Thread) {
        J2SEGeneric.removeThread(bT747Thread);
    }

    @Override
    public final String toString(boolean bl) {
        return String.valueOf(bl);
    }

    @Override
    public final String toString(float f) {
        return Float.toString(f);
    }

    @Override
    public final String toString(double d) {
        return Double.toString(d);
    }

    @Override
    public final synchronized String toString(double d, int n) {
        return nf[n].format(d);
    }

    @Override
    public final String unsigned2hex(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == n2) {
            return string;
        }
        if (string.length() < n2) {
            return "0000000000000000".substring(16 - n2 + string.length()).concat(string);
        }
        return string.substring(string.length() - n2);
    }

    @Override
    public final int toInt(String string) {
        return Integer.valueOf(string);
    }

    @Override
    public final float toFloat(String string) {
        return Float.parseFloat(string);
    }

    @Override
    public final double toDouble(String string) {
        return Double.parseDouble(string);
    }

    @Override
    public final double longBitsToDouble(long l) {
        return Double.longBitsToDouble(l);
    }

    @Override
    public final float toFloatBitwise(int n) {
        return Float.intBitsToFloat(n);
    }

    @Override
    public final int toIntBitwise(float f) {
        return Float.floatToIntBits(f);
    }

    @Override
    public final void debug(String string) {
        this.debug(string, null);
    }

    @Override
    public final int getTimeStamp() {
        return (int)(System.currentTimeMillis() - appStartTime);
    }

    @Override
    public final String getAppSettings() {
        return appSettings;
    }

    @Override
    public final void setAppSettings(String string) {
        appSettings = string;
    }

    @Override
    public final BT747Semaphore getSemaphoreInstance(int n) {
        return new J2SESemaphore(n);
    }

    @Override
    public final BT747StringTokenizer getStringTokenizer(String string, char c) {
        return new J2SEStringTokenizer(string, c);
    }

    @Override
    public final BT747HashSet getHashSetInstance() {
        return new J2SEHashSet();
    }

    @Override
    public final BT747HttpSender getHttpSenderInstance() {
        if (this.httpSenderInstance == null) {
            this.httpSenderInstance = new J2SEHttpSenderImpl();
        }
        return this.httpSenderInstance;
    }

    @Override
    public final double atan(double d) {
        return Math.atan(d);
    }

    @Override
    public final double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    @Override
    public final String convertHTMLtoUTF8(String string) {
        return NRCDecoder.decode(string);
    }

    @Override
    public final byte[] getUTF8Bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Generic.debug("Issue converting string to UTF8", unsupportedEncodingException);
            return new byte[0];
        }
    }

    static {
        nf = new DecimalFormat[17];
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        for (int i = 0; i < 17; ++i) {
            J2SEJavaTranslations.nf[i] = new DecimalFormat("#######0.0000000000000000".substring(0, i + 9));
            nf[i].setGroupingUsed(false);
        }
        Locale.setDefault(locale);
        appStartTime = System.currentTimeMillis();
        appSettings = "";
    }
}

