/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.util.Date;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;

public class DirEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long lastChanged;
    private long lastChangedRevision;
    private boolean hasProps;
    private String lastAuthor;
    private NodeKind nodeKind;
    private long size;
    private String path;
    private String absPath;

    public DirEntry(String string, String string2, NodeKind nodeKind, long l, boolean bl, long l2, long l3, String string3) {
        this.path = string;
        this.absPath = string2;
        this.nodeKind = nodeKind;
        this.size = l;
        this.hasProps = bl;
        this.lastChangedRevision = l2;
        this.lastChanged = l3;
        this.lastAuthor = string3;
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsPath() {
        return this.absPath;
    }

    public Date getLastChanged() {
        return new Date(this.lastChanged / 1000L);
    }

    public Revision.Number getLastChangedRevision() {
        return Revision.createNumber(this.lastChangedRevision);
    }

    public long getLastChangedRevisionNumber() {
        return this.lastChangedRevision;
    }

    public boolean getHasProps() {
        return this.hasProps;
    }

    public String getLastAuthor() {
        return this.lastAuthor;
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    public long getSize() {
        return this.size;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String toString() {
        return this.getPath() + '@' + this.getLastChangedRevision();
    }

    public class Fields {
        public static final int nodeKind = 1;
        public static final int size = 2;
        public static final int hasProps = 4;
        public static final int lastChangeRevision = 8;
        public static final int lastChanged = 16;
        public static final int lastAuthor = 32;
        public static final int all = -1;
    }
}

