/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.Flags;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import java.util.List;

public class ForEachStatement
extends Statement {
    public static final TokenRole FOR_KEYWORD_ROLE = ForStatement.FOR_KEYWORD_ROLE;
    public static final TokenRole COLON_ROLE = new TokenRole(":", 2);

    public ForEachStatement(int offset) {
        super(offset);
    }

    public final JavaTokenNode getForToken() {
        return this.getChildByRole(FOR_KEYWORD_ROLE);
    }

    public final Statement getEmbeddedStatement() {
        return this.getChildByRole(Roles.EMBEDDED_STATEMENT);
    }

    public final void setEmbeddedStatement(Statement value) {
        this.setChildByRole(Roles.EMBEDDED_STATEMENT, value);
    }

    public final AstType getVariableType() {
        return this.getChildByRole(Roles.TYPE);
    }

    public final void setVariableType(AstType value) {
        this.setChildByRole(Roles.TYPE, value);
    }

    public final String getVariableName() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setVariableName(String value) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(value));
    }

    public final Identifier getVariableNameToken() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setVariableNameToken(Identifier value) {
        this.setChildByRole(Roles.IDENTIFIER, value);
    }

    public final List<Flags.Flag> getVariableModifiers() {
        return EntityDeclaration.getModifiers(this);
    }

    public final void addVariableModifier(Flags.Flag modifier) {
        EntityDeclaration.addModifier(this, modifier);
    }

    public final void removeVariableModifier(Flags.Flag modifier) {
        EntityDeclaration.removeModifier(this, modifier);
    }

    public final void setVariableModifiers(List<Flags.Flag> modifiers) {
        EntityDeclaration.setModifiers(this, modifiers);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    public final Expression getInExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setInExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitForEachStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof ForEachStatement) {
            ForEachStatement otherStatement = (ForEachStatement)other;
            return !other.isNull() && this.getVariableType().matches(otherStatement.getVariableType(), match) && ForEachStatement.matchString(this.getVariableName(), otherStatement.getVariableName()) && this.getInExpression().matches(otherStatement.getInExpression(), match) && this.getEmbeddedStatement().matches(otherStatement.getEmbeddedStatement(), match);
        }
        return false;
    }
}

