/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import org.scilab.forge.jlatexmath.Box;

public class FcscoreBox
extends Box {
    private int N;
    private boolean strike;
    private float space;
    private float thickness;

    public FcscoreBox(int N2, float h2, float thickness, float space, boolean strike) {
        this.N = N2;
        this.width = (float)N2 * (thickness + space) + 2.0f * space;
        this.height = h2;
        this.depth = 0.0f;
        this.strike = strike;
        this.space = space;
        this.thickness = thickness;
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        AffineTransform transf = g2.getTransform();
        Stroke oldStroke = g2.getStroke();
        double sx = transf.getScaleX();
        double sy = transf.getScaleY();
        double s2 = 1.0;
        if (sx == sy) {
            s2 = sx;
            AffineTransform t2 = (AffineTransform)transf.clone();
            t2.scale(1.0 / sx, 1.0 / sy);
            g2.setTransform(t2);
        }
        g2.setStroke(new BasicStroke((float)(s2 * (double)this.thickness), 0, 0));
        float th = this.thickness / 2.0f;
        Line2D.Float line = new Line2D.Float();
        float xx = x + this.space;
        xx = (float)((double)xx * s2 + (double)(this.space / 2.0f) * s2);
        int inc = (int)Math.round((double)(this.space + this.thickness) * s2);
        for (int i = 0; i < this.N; ++i) {
            line.setLine((double)xx + (double)th * s2, (double)(y - this.height) * s2, (double)xx + (double)th * s2, (double)y * s2);
            g2.draw(line);
            xx += (float)inc;
        }
        if (this.strike) {
            line.setLine((double)(x + this.space) * s2, (double)(y - this.height / 2.0f) * s2, (double)xx - s2 * (double)this.space / 2.0, (double)(y - this.height / 2.0f) * s2);
            g2.draw(line);
        }
        g2.setTransform(transf);
        g2.setStroke(oldStroke);
    }

    @Override
    public int getLastFontId() {
        return -1;
    }
}

