/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tribuo.Feature;
import org.tribuo.data.text.FeatureAggregator;

public class UniqueAggregator
implements FeatureAggregator {
    private final ThreadLocal<Map<String, Double>> map = ThreadLocal.withInitial(HashMap::new);
    @Config(description="Value to emit, if unset emits the last value observed for that token.")
    private double value = Double.NaN;

    public UniqueAggregator(double value) {
        this.value = value;
    }

    public UniqueAggregator() {
    }

    @Override
    public List<Feature> aggregate(List<Feature> input) {
        Map<String, Double> curMap = this.map.get();
        curMap.clear();
        for (Feature f : input) {
            curMap.put(f.getName(), f.getValue());
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Map.Entry<String, Double> e : curMap.entrySet()) {
            double tmpValue = Double.isNaN(this.value) ? e.getValue() : this.value;
            features.add(new Feature(e.getKey(), tmpValue));
        }
        return features;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FeatureAggregator");
    }
}

