/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.rescore;

import lombok.Generated;

public final class RescoreContext {
    public static final float DEFAULT_OVERSAMPLE_FACTOR = 1.0f;
    public static final float MAX_OVERSAMPLE_FACTOR = 100.0f;
    public static final float MIN_OVERSAMPLE_FACTOR = 1.0f;
    public static final int MAX_FIRST_PASS_RESULTS = 10000;
    public static final int DIMENSION_THRESHOLD = 1000;
    public static final float OVERSAMPLE_FACTOR_BELOW_DIMENSION_THRESHOLD = 5.0f;
    public static final int DIMENSION_THRESHOLD_1000 = 1000;
    public static final int DIMENSION_THRESHOLD_768 = 768;
    public static final float OVERSAMPLE_FACTOR_1000 = 1.0f;
    public static final float OVERSAMPLE_FACTOR_768 = 2.0f;
    public static final float OVERSAMPLE_FACTOR_BELOW_768 = 3.0f;
    public static final int MIN_FIRST_PASS_RESULTS = 100;
    private float oversampleFactor;
    private boolean userProvided;
    private boolean rescoreEnabled;
    public static final RescoreContext EXPLICITLY_DISABLED_RESCORE_CONTEXT = RescoreContext.builder().oversampleFactor(1.0f).rescoreEnabled(false).build();

    public static RescoreContext getDefault() {
        return RescoreContext.builder().oversampleFactor(1.0f).userProvided(false).build();
    }

    public int getFirstPassK(int finalK, boolean isShardLevelRescoringDisabled, int dimension) {
        if (isShardLevelRescoringDisabled && !this.userProvided) {
            this.oversampleFactor = dimension >= 1000 ? 1.0f : (dimension >= 768 ? 2.0f : 3.0f);
        }
        return Math.min(10000, Math.max(100, (int)Math.ceil((float)finalK * this.oversampleFactor)));
    }

    @Generated
    private static float $default$oversampleFactor() {
        return 1.0f;
    }

    @Generated
    private static boolean $default$userProvided() {
        return true;
    }

    @Generated
    private static boolean $default$rescoreEnabled() {
        return true;
    }

    @Generated
    public static RescoreContextBuilder builder() {
        return new RescoreContextBuilder();
    }

    @Generated
    public float getOversampleFactor() {
        return this.oversampleFactor;
    }

    @Generated
    public boolean isUserProvided() {
        return this.userProvided;
    }

    @Generated
    public boolean isRescoreEnabled() {
        return this.rescoreEnabled;
    }

    @Generated
    public RescoreContext(float oversampleFactor, boolean userProvided, boolean rescoreEnabled) {
        this.oversampleFactor = oversampleFactor;
        this.userProvided = userProvided;
        this.rescoreEnabled = rescoreEnabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RescoreContext)) {
            return false;
        }
        RescoreContext other = (RescoreContext)o;
        if (Float.compare(this.getOversampleFactor(), other.getOversampleFactor()) != 0) {
            return false;
        }
        if (this.isUserProvided() != other.isUserProvided()) {
            return false;
        }
        return this.isRescoreEnabled() == other.isRescoreEnabled();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getOversampleFactor());
        result = result * 59 + (this.isUserProvided() ? 79 : 97);
        result = result * 59 + (this.isRescoreEnabled() ? 79 : 97);
        return result;
    }

    @Generated
    public static class RescoreContextBuilder {
        @Generated
        private boolean oversampleFactor$set;
        @Generated
        private float oversampleFactor$value;
        @Generated
        private boolean userProvided$set;
        @Generated
        private boolean userProvided$value;
        @Generated
        private boolean rescoreEnabled$set;
        @Generated
        private boolean rescoreEnabled$value;

        @Generated
        RescoreContextBuilder() {
        }

        @Generated
        public RescoreContextBuilder oversampleFactor(float oversampleFactor) {
            this.oversampleFactor$value = oversampleFactor;
            this.oversampleFactor$set = true;
            return this;
        }

        @Generated
        public RescoreContextBuilder userProvided(boolean userProvided) {
            this.userProvided$value = userProvided;
            this.userProvided$set = true;
            return this;
        }

        @Generated
        public RescoreContextBuilder rescoreEnabled(boolean rescoreEnabled) {
            this.rescoreEnabled$value = rescoreEnabled;
            this.rescoreEnabled$set = true;
            return this;
        }

        @Generated
        public RescoreContext build() {
            float oversampleFactor$value = this.oversampleFactor$value;
            if (!this.oversampleFactor$set) {
                oversampleFactor$value = RescoreContext.$default$oversampleFactor();
            }
            boolean userProvided$value = this.userProvided$value;
            if (!this.userProvided$set) {
                userProvided$value = RescoreContext.$default$userProvided();
            }
            boolean rescoreEnabled$value = this.rescoreEnabled$value;
            if (!this.rescoreEnabled$set) {
                rescoreEnabled$value = RescoreContext.$default$rescoreEnabled();
            }
            return new RescoreContext(oversampleFactor$value, userProvided$value, rescoreEnabled$value);
        }

        @Generated
        public String toString() {
            return "RescoreContext.RescoreContextBuilder(oversampleFactor$value=" + this.oversampleFactor$value + ", userProvided$value=" + this.userProvided$value + ", rescoreEnabled$value=" + this.rescoreEnabled$value + ")";
        }
    }
}

