/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityBlockExtension;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionHistoryResponse;

public class DescribeCapacityBlockExtensionHistoryPublisher
implements SdkPublisher<DescribeCapacityBlockExtensionHistoryResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCapacityBlockExtensionHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCapacityBlockExtensionHistoryPublisher(Ec2AsyncClient client, DescribeCapacityBlockExtensionHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCapacityBlockExtensionHistoryPublisher(Ec2AsyncClient client, DescribeCapacityBlockExtensionHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCapacityBlockExtensionHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCapacityBlockExtensionHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityBlockExtension> capacityBlockExtensions() {
        Function<DescribeCapacityBlockExtensionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityBlockExtensions() != null) {
                return response.capacityBlockExtensions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCapacityBlockExtensionHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCapacityBlockExtensionHistoryResponseFetcher
    implements AsyncPageFetcher<DescribeCapacityBlockExtensionHistoryResponse> {
        private DescribeCapacityBlockExtensionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityBlockExtensionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCapacityBlockExtensionHistoryResponse> nextPage(DescribeCapacityBlockExtensionHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityBlockExtensionHistoryPublisher.this.client.describeCapacityBlockExtensionHistory(DescribeCapacityBlockExtensionHistoryPublisher.this.firstRequest);
            }
            return DescribeCapacityBlockExtensionHistoryPublisher.this.client.describeCapacityBlockExtensionHistory((DescribeCapacityBlockExtensionHistoryRequest)((Object)DescribeCapacityBlockExtensionHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

