// api-body.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "OAIEducationSchoolApi.h"
#include "OAIServerConfiguration.h"
#include <QJsonArray>
#include <QJsonDocument>

namespace OpenAPI {

OAIEducationSchoolApi::OAIEducationSchoolApi(const int timeOut)
    : _timeOut(timeOut),
      _manager(nullptr),
      _isResponseCompressionEnabled(false),
      _isRequestCompressionEnabled(false) {
    initializeServerConfigs();
}

OAIEducationSchoolApi::~OAIEducationSchoolApi() {
}

void OAIEducationSchoolApi::initializeServerConfigs() {
    //Default server
    QList<OAIServerConfiguration> defaultConf = QList<OAIServerConfiguration>();
    //varying endpoint server
    defaultConf.append(OAIServerConfiguration(
    QUrl("https://ocis.ocis-traefik.latest.owncloud.works/graph/v1.0"),
    "ownCloud Infinite Scale Latest",
    QMap<QString, OAIServerVariable>()));
    defaultConf.append(OAIServerConfiguration(
    QUrl("https://localhost:9200/graph/v1.0"),
    "ownCloud Infinite Scale Development Setup",
    QMap<QString, OAIServerVariable>()));
    _serverConfigs.insert("addClassToSchool", defaultConf);
    _serverIndices.insert("addClassToSchool", 0);
    _serverConfigs.insert("addUserToSchool", defaultConf);
    _serverIndices.insert("addUserToSchool", 0);
    _serverConfigs.insert("createSchool", defaultConf);
    _serverIndices.insert("createSchool", 0);
    _serverConfigs.insert("deleteClassFromSchool", defaultConf);
    _serverIndices.insert("deleteClassFromSchool", 0);
    _serverConfigs.insert("deleteSchool", defaultConf);
    _serverIndices.insert("deleteSchool", 0);
    _serverConfigs.insert("deleteUserFromSchool", defaultConf);
    _serverIndices.insert("deleteUserFromSchool", 0);
    _serverConfigs.insert("getSchool", defaultConf);
    _serverIndices.insert("getSchool", 0);
    _serverConfigs.insert("listSchoolClasses", defaultConf);
    _serverIndices.insert("listSchoolClasses", 0);
    _serverConfigs.insert("listSchoolUsers", defaultConf);
    _serverIndices.insert("listSchoolUsers", 0);
    _serverConfigs.insert("listSchools", defaultConf);
    _serverIndices.insert("listSchools", 0);
    _serverConfigs.insert("updateSchool", defaultConf);
    _serverIndices.insert("updateSchool", 0);
}

/**
* returns 0 on success and -1, -2 or -3 on failure.
* -1 when the variable does not exist and -2 if the value is not defined in the enum and -3 if the operation or server index is not found
*/
int OAIEducationSchoolApi::setDefaultServerValue(int serverIndex, const QString &operation, const QString &variable, const QString &value) {
    auto it = _serverConfigs.find(operation);
    if (it != _serverConfigs.end() && serverIndex < it.value().size()) {
      return _serverConfigs[operation][serverIndex].setDefaultValue(variable,value);
    }
    return -3;
}
void OAIEducationSchoolApi::setServerIndex(const QString &operation, int serverIndex) {
    if (_serverIndices.contains(operation) && serverIndex < _serverConfigs.find(operation).value().size()) {
        _serverIndices[operation] = serverIndex;
    }
}

void OAIEducationSchoolApi::setApiKey(const QString &apiKeyName, const QString &apiKey) {
    _apiKeys.insert(apiKeyName,apiKey);
}

void OAIEducationSchoolApi::setBearerToken(const QString &token) {
    _bearerToken = token;
}

void OAIEducationSchoolApi::setUsername(const QString &username) {
    _username = username;
}

void OAIEducationSchoolApi::setPassword(const QString &password) {
    _password = password;
}


void OAIEducationSchoolApi::setTimeOut(const int timeOut) {
    _timeOut = timeOut;
}

void OAIEducationSchoolApi::setWorkingDirectory(const QString &path) {
    _workingDirectory = path;
}

void OAIEducationSchoolApi::setNetworkAccessManager(QNetworkAccessManager* manager) {
    _manager = manager;
}

/**
    * Appends a new ServerConfiguration to the config map for a specific operation.
    * @param operation The id to the target operation.
    * @param url A string that contains the URL of the server
    * @param description A String that describes the server
    * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
    * returns the index of the new server config on success and -1 if the operation is not found
    */
int OAIEducationSchoolApi::addServerConfiguration(const QString &operation, const QUrl &url, const QString &description, const QMap<QString, OAIServerVariable> &variables) {
    if (_serverConfigs.contains(operation)) {
        _serverConfigs[operation].append(OAIServerConfiguration(
                    url,
                    description,
                    variables));
        return _serverConfigs[operation].size()-1;
    } else {
        return -1;
    }
}

/**
    * Appends a new ServerConfiguration to the config map for a all operations and sets the index to that server.
    * @param url A string that contains the URL of the server
    * @param description A String that describes the server
    * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
    */
void OAIEducationSchoolApi::setNewServerForAllOperations(const QUrl &url, const QString &description, const QMap<QString, OAIServerVariable> &variables) {
#if QT_VERSION >= QT_VERSION_CHECK(5, 12, 0)
    for (auto keyIt = _serverIndices.keyBegin(); keyIt != _serverIndices.keyEnd(); keyIt++) {
        setServerIndex(*keyIt, addServerConfiguration(*keyIt, url, description, variables));
    }
#else
    for (auto &e : _serverIndices.keys()) {
        setServerIndex(e, addServerConfiguration(e, url, description, variables));
    }
#endif
}

/**
    * Appends a new ServerConfiguration to the config map for an operations and sets the index to that server.
    * @param URL A string that contains the URL of the server
    * @param description A String that describes the server
    * @param variables A map between a variable name and its value. The value is used for substitution in the server's URL template.
    */
void OAIEducationSchoolApi::setNewServer(const QString &operation, const QUrl &url, const QString &description, const QMap<QString, OAIServerVariable> &variables) {
    setServerIndex(operation, addServerConfiguration(operation, url, description, variables));
}

void OAIEducationSchoolApi::addHeaders(const QString &key, const QString &value) {
    _defaultHeaders.insert(key, value);
}

void OAIEducationSchoolApi::enableRequestCompression() {
    _isRequestCompressionEnabled = true;
}

void OAIEducationSchoolApi::enableResponseCompression() {
    _isResponseCompressionEnabled = true;
}

void OAIEducationSchoolApi::abortRequests() {
    emit abortRequestsSignal();
}

QString OAIEducationSchoolApi::getParamStylePrefix(const QString &style) {
    if (style == "matrix") {
        return ";";
    } else if (style == "label") {
        return ".";
    } else if (style == "form") {
        return "&";
    } else if (style == "simple") {
        return "";
    } else if (style == "spaceDelimited") {
        return "&";
    } else if (style == "pipeDelimited") {
        return "&";
    } else {
        return "none";
    }
}

QString OAIEducationSchoolApi::getParamStyleSuffix(const QString &style) {
    if (style == "matrix") {
        return "=";
    } else if (style == "label") {
        return "";
    } else if (style == "form") {
        return "=";
    } else if (style == "simple") {
        return "";
    } else if (style == "spaceDelimited") {
        return "=";
    } else if (style == "pipeDelimited") {
        return "=";
    } else {
        return "none";
    }
}

QString OAIEducationSchoolApi::getParamStyleDelimiter(const QString &style, const QString &name, bool isExplode) {

    if (style == "matrix") {
        return (isExplode) ? ";" + name + "=" : ",";

    } else if (style == "label") {
        return (isExplode) ? "." : ",";

    } else if (style == "form") {
        return (isExplode) ? "&" + name + "=" : ",";

    } else if (style == "simple") {
        return ",";
    } else if (style == "spaceDelimited") {
        return (isExplode) ? "&" + name + "=" : " ";

    } else if (style == "pipeDelimited") {
        return (isExplode) ? "&" + name + "=" : "|";

    } else if (style == "deepObject") {
        return (isExplode) ? "&" : "none";

    } else {
        return "none";
    }
}

void OAIEducationSchoolApi::addClassToSchool(const QString &school_id, const OAIClass_Reference &oai_class_reference) {
    QString fullPath = QString(_serverConfigs["addClassToSchool"][_serverIndices.value("addClassToSchool")].URL()+"/education/schools/{school-id}/classes/$ref");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    
    {
        QString school_idPathParam("{");
        school_idPathParam.append("school-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "school-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"school-id"+pathSuffix : pathPrefix;
        fullPath.replace(school_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(school_id)));
    }
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "POST");

    {

        QByteArray output = oai_class_reference.asJson().toUtf8();
        input.request_body.append(output);
    }
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::addClassToSchoolCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::addClassToSchoolCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit addClassToSchoolSignal();
        emit addClassToSchoolSignalFull(worker);
    } else {
        emit addClassToSchoolSignalE(error_type, error_str);
        emit addClassToSchoolSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::addUserToSchool(const QString &school_id, const OAIEducationUser_Reference &oai_education_user_reference) {
    QString fullPath = QString(_serverConfigs["addUserToSchool"][_serverIndices.value("addUserToSchool")].URL()+"/education/schools/{school-id}/users/$ref");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    
    {
        QString school_idPathParam("{");
        school_idPathParam.append("school-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "school-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"school-id"+pathSuffix : pathPrefix;
        fullPath.replace(school_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(school_id)));
    }
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "POST");

    {

        QByteArray output = oai_education_user_reference.asJson().toUtf8();
        input.request_body.append(output);
    }
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::addUserToSchoolCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::addUserToSchoolCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit addUserToSchoolSignal();
        emit addUserToSchoolSignalFull(worker);
    } else {
        emit addUserToSchoolSignalE(error_type, error_str);
        emit addUserToSchoolSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::createSchool(const OAIEducationSchool &oai_education_school) {
    QString fullPath = QString(_serverConfigs["createSchool"][_serverIndices.value("createSchool")].URL()+"/education/schools");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "POST");

    {

        QByteArray output = oai_education_school.asJson().toUtf8();
        input.request_body.append(output);
    }
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::createSchoolCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::createSchoolCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    OAIEducationSchool output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit createSchoolSignal(output);
        emit createSchoolSignalFull(worker, output);
    } else {
        emit createSchoolSignalE(output, error_type, error_str);
        emit createSchoolSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::deleteClassFromSchool(const QString &school_id, const QString &class_id) {
    QString fullPath = QString(_serverConfigs["deleteClassFromSchool"][_serverIndices.value("deleteClassFromSchool")].URL()+"/education/schools/{school-id}/classes/{class-id}/$ref");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    
    {
        QString school_idPathParam("{");
        school_idPathParam.append("school-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "school-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"school-id"+pathSuffix : pathPrefix;
        fullPath.replace(school_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(school_id)));
    }
    
    {
        QString class_idPathParam("{");
        class_idPathParam.append("class-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "class-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"class-id"+pathSuffix : pathPrefix;
        fullPath.replace(class_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(class_id)));
    }
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "DELETE");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::deleteClassFromSchoolCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::deleteClassFromSchoolCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit deleteClassFromSchoolSignal();
        emit deleteClassFromSchoolSignalFull(worker);
    } else {
        emit deleteClassFromSchoolSignalE(error_type, error_str);
        emit deleteClassFromSchoolSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::deleteSchool(const QString &school_id) {
    QString fullPath = QString(_serverConfigs["deleteSchool"][_serverIndices.value("deleteSchool")].URL()+"/education/schools/{school-id}");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    
    {
        QString school_idPathParam("{");
        school_idPathParam.append("school-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "school-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"school-id"+pathSuffix : pathPrefix;
        fullPath.replace(school_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(school_id)));
    }
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "DELETE");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::deleteSchoolCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::deleteSchoolCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit deleteSchoolSignal();
        emit deleteSchoolSignalFull(worker);
    } else {
        emit deleteSchoolSignalE(error_type, error_str);
        emit deleteSchoolSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::deleteUserFromSchool(const QString &school_id, const QString &user_id) {
    QString fullPath = QString(_serverConfigs["deleteUserFromSchool"][_serverIndices.value("deleteUserFromSchool")].URL()+"/education/schools/{school-id}/users/{user-id}/$ref");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    
    {
        QString school_idPathParam("{");
        school_idPathParam.append("school-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "school-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"school-id"+pathSuffix : pathPrefix;
        fullPath.replace(school_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(school_id)));
    }
    
    {
        QString user_idPathParam("{");
        user_idPathParam.append("user-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "user-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"user-id"+pathSuffix : pathPrefix;
        fullPath.replace(user_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(user_id)));
    }
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "DELETE");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::deleteUserFromSchoolCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::deleteUserFromSchoolCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit deleteUserFromSchoolSignal();
        emit deleteUserFromSchoolSignalFull(worker);
    } else {
        emit deleteUserFromSchoolSignalE(error_type, error_str);
        emit deleteUserFromSchoolSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::getSchool(const QString &school_id) {
    QString fullPath = QString(_serverConfigs["getSchool"][_serverIndices.value("getSchool")].URL()+"/education/schools/{school-id}");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    
    {
        QString school_idPathParam("{");
        school_idPathParam.append("school-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "school-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"school-id"+pathSuffix : pathPrefix;
        fullPath.replace(school_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(school_id)));
    }
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::getSchoolCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::getSchoolCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    OAIEducationSchool output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit getSchoolSignal(output);
        emit getSchoolSignalFull(worker, output);
    } else {
        emit getSchoolSignalE(output, error_type, error_str);
        emit getSchoolSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::listSchoolClasses(const QString &school_id) {
    QString fullPath = QString(_serverConfigs["listSchoolClasses"][_serverIndices.value("listSchoolClasses")].URL()+"/education/schools/{school-id}/classes");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    
    {
        QString school_idPathParam("{");
        school_idPathParam.append("school-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "school-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"school-id"+pathSuffix : pathPrefix;
        fullPath.replace(school_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(school_id)));
    }
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::listSchoolClassesCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::listSchoolClassesCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    OAICollection_of_educationClass output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit listSchoolClassesSignal(output);
        emit listSchoolClassesSignalFull(worker, output);
    } else {
        emit listSchoolClassesSignalE(output, error_type, error_str);
        emit listSchoolClassesSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::listSchoolUsers(const QString &school_id) {
    QString fullPath = QString(_serverConfigs["listSchoolUsers"][_serverIndices.value("listSchoolUsers")].URL()+"/education/schools/{school-id}/users");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    
    {
        QString school_idPathParam("{");
        school_idPathParam.append("school-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "school-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"school-id"+pathSuffix : pathPrefix;
        fullPath.replace(school_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(school_id)));
    }
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::listSchoolUsersCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::listSchoolUsersCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    OAICollection_of_educationUser_1 output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit listSchoolUsersSignal(output);
        emit listSchoolUsersSignalFull(worker, output);
    } else {
        emit listSchoolUsersSignalE(output, error_type, error_str);
        emit listSchoolUsersSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::listSchools() {
    QString fullPath = QString(_serverConfigs["listSchools"][_serverIndices.value("listSchools")].URL()+"/education/schools");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "GET");


#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::listSchoolsCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::listSchoolsCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    OAICollection_of_schools output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit listSchoolsSignal(output);
        emit listSchoolsSignalFull(worker, output);
    } else {
        emit listSchoolsSignalE(output, error_type, error_str);
        emit listSchoolsSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::updateSchool(const QString &school_id, const OAIEducationSchool &oai_education_school) {
    QString fullPath = QString(_serverConfigs["updateSchool"][_serverIndices.value("updateSchool")].URL()+"/education/schools/{school-id}");
    
    if (!_bearerToken.isEmpty())
        addHeaders("Authorization", "Bearer " + _bearerToken);
    
    
    {
        QString school_idPathParam("{");
        school_idPathParam.append("school-id").append("}");
        QString pathPrefix, pathSuffix, pathDelimiter;
        QString pathStyle = "simple";
        if (pathStyle == "")
            pathStyle = "simple";
        pathPrefix = getParamStylePrefix(pathStyle);
        pathSuffix = getParamStyleSuffix(pathStyle);
        pathDelimiter = getParamStyleDelimiter(pathStyle, "school-id", false);
        QString paramString = (pathStyle == "matrix") ? pathPrefix+"school-id"+pathSuffix : pathPrefix;
        fullPath.replace(school_idPathParam, paramString+QUrl::toPercentEncoding(::OpenAPI::toStringValue(school_id)));
    }
    OAIHttpRequestWorker *worker = new OAIHttpRequestWorker(this, _manager);
    worker->setTimeOut(_timeOut);
    worker->setWorkingDirectory(_workingDirectory);
    OAIHttpRequestInput input(fullPath, "PATCH");

    {

        QByteArray output = oai_education_school.asJson().toUtf8();
        input.request_body.append(output);
    }
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
    for (auto keyValueIt = _defaultHeaders.keyValueBegin(); keyValueIt != _defaultHeaders.keyValueEnd(); keyValueIt++) {
        input.headers.insert(keyValueIt->first, keyValueIt->second);
    }
#else
    for (auto key : _defaultHeaders.keys()) {
        input.headers.insert(key, _defaultHeaders[key]);
    }
#endif

    connect(worker, &OAIHttpRequestWorker::on_execution_finished, this, &OAIEducationSchoolApi::updateSchoolCallback);
    connect(this, &OAIEducationSchoolApi::abortRequestsSignal, worker, &QObject::deleteLater);
    connect(worker, &QObject::destroyed, this, [this]() {
        if (findChildren<OAIHttpRequestWorker*>().count() == 0) {
            emit allPendingRequestsCompleted();
        }
    });

    worker->execute(&input);
}

void OAIEducationSchoolApi::updateSchoolCallback(OAIHttpRequestWorker *worker) {
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type != QNetworkReply::NoError) {
        error_str = QString("%1, %2").arg(worker->error_str, QString(worker->response));
    }
    OAIEducationSchool output(QString(worker->response));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit updateSchoolSignal(output);
        emit updateSchoolSignalFull(worker, output);
    } else {
        emit updateSchoolSignalE(output, error_type, error_str);
        emit updateSchoolSignalEFull(worker, error_type, error_str);
    }
}

void OAIEducationSchoolApi::tokenAvailable(){
  
    oauthToken token; 
    switch (_OauthMethod) {
    case 1: //implicit flow
        token = _implicitFlow.getToken(_latestScope.join(" "));
        if(token.isValid()){
            _latestInput.headers.insert("Authorization", "Bearer " + token.getToken());
            _latestWorker->execute(&_latestInput);
        }else{
            _implicitFlow.removeToken(_latestScope.join(" "));
            qDebug() << "Could not retreive a valid token";
        }
        break;
    case 2: //authorization flow
        token = _authFlow.getToken(_latestScope.join(" "));
        if(token.isValid()){
            _latestInput.headers.insert("Authorization", "Bearer " + token.getToken());
            _latestWorker->execute(&_latestInput);
        }else{
            _authFlow.removeToken(_latestScope.join(" "));    
            qDebug() << "Could not retreive a valid token";
        }
        break;
    case 3: //client credentials flow
        token = _credentialFlow.getToken(_latestScope.join(" "));
        if(token.isValid()){
            _latestInput.headers.insert("Authorization", "Bearer " + token.getToken());
            _latestWorker->execute(&_latestInput);
        }else{
            _credentialFlow.removeToken(_latestScope.join(" "));    
            qDebug() << "Could not retreive a valid token";
        }
        break;
    case 4: //resource owner password flow
        token = _passwordFlow.getToken(_latestScope.join(" "));
        if(token.isValid()){
            _latestInput.headers.insert("Authorization", "Bearer " + token.getToken());
            _latestWorker->execute(&_latestInput);
        }else{
            _credentialFlow.removeToken(_latestScope.join(" "));    
            qDebug() << "Could not retreive a valid token";
        }
        break;
    default:
        qDebug() << "No Oauth method set!";
        break;
    }
}
} // namespace OpenAPI
