// model-body.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "OAIDriveItem.h"

#include <QDebug>
#include <QJsonArray>
#include <QJsonDocument>
#include <QObject>

#include "OAIHelpers.h"

namespace OpenAPI {

class OAIDriveItemPrivate {
    friend class OAIDriveItem;

     QString id;
     bool id_isSet;
     bool id_isValid;

     OAIIdentitySet created_by;
     bool created_by_isSet;
     bool created_by_isValid;

     QDateTime created_date_time;
     bool created_date_time_isSet;
     bool created_date_time_isValid;

     QString description;
     bool description_isSet;
     bool description_isValid;

     QString e_tag;
     bool e_tag_isSet;
     bool e_tag_isValid;

     OAIIdentitySet last_modified_by;
     bool last_modified_by_isSet;
     bool last_modified_by_isValid;

     QDateTime last_modified_date_time;
     bool last_modified_date_time_isSet;
     bool last_modified_date_time_isValid;

     QString name;
     bool name_isSet;
     bool name_isValid;

     OAIItemReference parent_reference;
     bool parent_reference_isSet;
     bool parent_reference_isValid;

     QString web_url;
     bool web_url_isSet;
     bool web_url_isValid;

     QString content;
     bool content_isSet;
     bool content_isValid;

     QString c_tag;
     bool c_tag_isSet;
     bool c_tag_isValid;

     OAIDeleted deleted;
     bool deleted_isSet;
     bool deleted_isValid;

     OAIOpenGraphFile file;
     bool file_isSet;
     bool file_isValid;

     OAIFileSystemInfo file_system_info;
     bool file_system_info_isSet;
     bool file_system_info_isValid;

     OAIFolder folder;
     bool folder_isSet;
     bool folder_isValid;

     OAIImage image;
     bool image_isSet;
     bool image_isValid;

     OAIObject root;
     bool root_isSet;
     bool root_isValid;

     OAITrash trash;
     bool trash_isSet;
     bool trash_isValid;

     OAISpecialFolder special_folder;
     bool special_folder_isSet;
     bool special_folder_isValid;

     OAIRemoteItem remote_item;
     bool remote_item_isSet;
     bool remote_item_isValid;

     qint64 size;
     bool size_isSet;
     bool size_isValid;

     QString web_dav_url;
     bool web_dav_url_isSet;
     bool web_dav_url_isValid;

     QList<OAIDriveItem> children;
     bool children_isSet;
     bool children_isValid;

     QList<OAIPermission> permissions;
     bool permissions_isSet;
     bool permissions_isValid;
};

OAIDriveItem::OAIDriveItem()
    : d_ptr()
{
}

OAIDriveItem::OAIDriveItem(const OAIDriveItem& other)
    : d_ptr(other.d_ptr)
{
}

OAIDriveItem::OAIDriveItem(QString json)
    : d_ptr(nullptr)
{
    this->fromJson(json);
}

OAIDriveItem::~OAIDriveItem() = default;

void OAIDriveItem::initializeModel() {
    if (d_ptr == nullptr) {
        d_ptr.reset(new OAIDriveItemPrivate{});

        Q_D(OAIDriveItem);


        d->id_isSet = false;
        d->id_isValid = false;

        d->created_by_isSet = false;
        d->created_by_isValid = false;

        d->created_date_time_isSet = false;
        d->created_date_time_isValid = false;

        d->description_isSet = false;
        d->description_isValid = false;

        d->e_tag_isSet = false;
        d->e_tag_isValid = false;

        d->last_modified_by_isSet = false;
        d->last_modified_by_isValid = false;

        d->last_modified_date_time_isSet = false;
        d->last_modified_date_time_isValid = false;

        d->name_isSet = false;
        d->name_isValid = false;

        d->parent_reference_isSet = false;
        d->parent_reference_isValid = false;

        d->web_url_isSet = false;
        d->web_url_isValid = false;

        d->content_isSet = false;
        d->content_isValid = false;

        d->c_tag_isSet = false;
        d->c_tag_isValid = false;

        d->deleted_isSet = false;
        d->deleted_isValid = false;

        d->file_isSet = false;
        d->file_isValid = false;

        d->file_system_info_isSet = false;
        d->file_system_info_isValid = false;

        d->folder_isSet = false;
        d->folder_isValid = false;

        d->image_isSet = false;
        d->image_isValid = false;

        d->root_isSet = false;
        d->root_isValid = false;

        d->trash_isSet = false;
        d->trash_isValid = false;

        d->special_folder_isSet = false;
        d->special_folder_isValid = false;

        d->remote_item_isSet = false;
        d->remote_item_isValid = false;

        d->size_isSet = false;
        d->size_isValid = false;

        d->web_dav_url_isSet = false;
        d->web_dav_url_isValid = false;

        d->children_isSet = false;
        d->children_isValid = false;

        d->permissions_isSet = false;
        d->permissions_isValid = false;
    }
}

void OAIDriveItem::fromJson(QString jsonString) {
    QByteArray array(jsonString.toUtf8());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
}

void OAIDriveItem::fromJsonObject(QJsonObject json) {
    initializeModel();

    Q_D(OAIDriveItem);

    d->id_isValid = ::OpenAPI::fromJsonValue(d->id, json[QString("id")]);
    d->id_isSet = !json[QString("id")].isNull() && d->id_isValid;

    d->created_by_isValid = ::OpenAPI::fromJsonValue(d->created_by, json[QString("createdBy")]);
    d->created_by_isSet = !json[QString("createdBy")].isNull() && d->created_by_isValid;

    d->created_date_time_isValid = ::OpenAPI::fromJsonValue(d->created_date_time, json[QString("createdDateTime")]);
    d->created_date_time_isSet = !json[QString("createdDateTime")].isNull() && d->created_date_time_isValid;

    d->description_isValid = ::OpenAPI::fromJsonValue(d->description, json[QString("description")]);
    d->description_isSet = !json[QString("description")].isNull() && d->description_isValid;

    d->e_tag_isValid = ::OpenAPI::fromJsonValue(d->e_tag, json[QString("eTag")]);
    d->e_tag_isSet = !json[QString("eTag")].isNull() && d->e_tag_isValid;

    d->last_modified_by_isValid = ::OpenAPI::fromJsonValue(d->last_modified_by, json[QString("lastModifiedBy")]);
    d->last_modified_by_isSet = !json[QString("lastModifiedBy")].isNull() && d->last_modified_by_isValid;

    d->last_modified_date_time_isValid = ::OpenAPI::fromJsonValue(d->last_modified_date_time, json[QString("lastModifiedDateTime")]);
    d->last_modified_date_time_isSet = !json[QString("lastModifiedDateTime")].isNull() && d->last_modified_date_time_isValid;

    d->name_isValid = ::OpenAPI::fromJsonValue(d->name, json[QString("name")]);
    d->name_isSet = !json[QString("name")].isNull() && d->name_isValid;

    d->parent_reference_isValid = ::OpenAPI::fromJsonValue(d->parent_reference, json[QString("parentReference")]);
    d->parent_reference_isSet = !json[QString("parentReference")].isNull() && d->parent_reference_isValid;

    d->web_url_isValid = ::OpenAPI::fromJsonValue(d->web_url, json[QString("webUrl")]);
    d->web_url_isSet = !json[QString("webUrl")].isNull() && d->web_url_isValid;

    d->content_isValid = ::OpenAPI::fromJsonValue(d->content, json[QString("content")]);
    d->content_isSet = !json[QString("content")].isNull() && d->content_isValid;

    d->c_tag_isValid = ::OpenAPI::fromJsonValue(d->c_tag, json[QString("cTag")]);
    d->c_tag_isSet = !json[QString("cTag")].isNull() && d->c_tag_isValid;

    d->deleted_isValid = ::OpenAPI::fromJsonValue(d->deleted, json[QString("deleted")]);
    d->deleted_isSet = !json[QString("deleted")].isNull() && d->deleted_isValid;

    d->file_isValid = ::OpenAPI::fromJsonValue(d->file, json[QString("file")]);
    d->file_isSet = !json[QString("file")].isNull() && d->file_isValid;

    d->file_system_info_isValid = ::OpenAPI::fromJsonValue(d->file_system_info, json[QString("fileSystemInfo")]);
    d->file_system_info_isSet = !json[QString("fileSystemInfo")].isNull() && d->file_system_info_isValid;

    d->folder_isValid = ::OpenAPI::fromJsonValue(d->folder, json[QString("folder")]);
    d->folder_isSet = !json[QString("folder")].isNull() && d->folder_isValid;

    d->image_isValid = ::OpenAPI::fromJsonValue(d->image, json[QString("image")]);
    d->image_isSet = !json[QString("image")].isNull() && d->image_isValid;

    d->root_isValid = ::OpenAPI::fromJsonValue(d->root, json[QString("root")]);
    d->root_isSet = !json[QString("root")].isNull() && d->root_isValid;

    d->trash_isValid = ::OpenAPI::fromJsonValue(d->trash, json[QString("trash")]);
    d->trash_isSet = !json[QString("trash")].isNull() && d->trash_isValid;

    d->special_folder_isValid = ::OpenAPI::fromJsonValue(d->special_folder, json[QString("specialFolder")]);
    d->special_folder_isSet = !json[QString("specialFolder")].isNull() && d->special_folder_isValid;

    d->remote_item_isValid = ::OpenAPI::fromJsonValue(d->remote_item, json[QString("remoteItem")]);
    d->remote_item_isSet = !json[QString("remoteItem")].isNull() && d->remote_item_isValid;

    d->size_isValid = ::OpenAPI::fromJsonValue(d->size, json[QString("size")]);
    d->size_isSet = !json[QString("size")].isNull() && d->size_isValid;

    d->web_dav_url_isValid = ::OpenAPI::fromJsonValue(d->web_dav_url, json[QString("webDavUrl")]);
    d->web_dav_url_isSet = !json[QString("webDavUrl")].isNull() && d->web_dav_url_isValid;

    d->children_isValid = ::OpenAPI::fromJsonValue(d->children, json[QString("children")]);
    d->children_isSet = !json[QString("children")].isNull() && d->children_isValid;

    d->permissions_isValid = ::OpenAPI::fromJsonValue(d->permissions, json[QString("permissions")]);
    d->permissions_isSet = !json[QString("permissions")].isNull() && d->permissions_isValid;
}

QString OAIDriveItem::asJson() const {
    QJsonObject obj = this->asJsonObject();
    QJsonDocument doc(obj);
    QByteArray bytes = doc.toJson();
    return QString(bytes);
}

QJsonObject OAIDriveItem::asJsonObject() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    QJsonObject obj;
    if (d->id_isSet) {
        obj.insert(QString("id"), ::OpenAPI::toJsonValue(d->id));
    }
    if (d->created_by.isSet()) {
        obj.insert(QString("createdBy"), ::OpenAPI::toJsonValue(d->created_by));
    }
    if (d->created_date_time_isSet) {
        obj.insert(QString("createdDateTime"), ::OpenAPI::toJsonValue(d->created_date_time));
    }
    if (d->description_isSet) {
        obj.insert(QString("description"), ::OpenAPI::toJsonValue(d->description));
    }
    if (d->e_tag_isSet) {
        obj.insert(QString("eTag"), ::OpenAPI::toJsonValue(d->e_tag));
    }
    if (d->last_modified_by.isSet()) {
        obj.insert(QString("lastModifiedBy"), ::OpenAPI::toJsonValue(d->last_modified_by));
    }
    if (d->last_modified_date_time_isSet) {
        obj.insert(QString("lastModifiedDateTime"), ::OpenAPI::toJsonValue(d->last_modified_date_time));
    }
    if (d->name_isSet) {
        obj.insert(QString("name"), ::OpenAPI::toJsonValue(d->name));
    }
    if (d->parent_reference.isSet()) {
        obj.insert(QString("parentReference"), ::OpenAPI::toJsonValue(d->parent_reference));
    }
    if (d->web_url_isSet) {
        obj.insert(QString("webUrl"), ::OpenAPI::toJsonValue(d->web_url));
    }
    if (d->content_isSet) {
        obj.insert(QString("content"), ::OpenAPI::toJsonValue(d->content));
    }
    if (d->c_tag_isSet) {
        obj.insert(QString("cTag"), ::OpenAPI::toJsonValue(d->c_tag));
    }
    if (d->deleted.isSet()) {
        obj.insert(QString("deleted"), ::OpenAPI::toJsonValue(d->deleted));
    }
    if (d->file.isSet()) {
        obj.insert(QString("file"), ::OpenAPI::toJsonValue(d->file));
    }
    if (d->file_system_info.isSet()) {
        obj.insert(QString("fileSystemInfo"), ::OpenAPI::toJsonValue(d->file_system_info));
    }
    if (d->folder.isSet()) {
        obj.insert(QString("folder"), ::OpenAPI::toJsonValue(d->folder));
    }
    if (d->image.isSet()) {
        obj.insert(QString("image"), ::OpenAPI::toJsonValue(d->image));
    }
    if (d->root_isSet) {
        obj.insert(QString("root"), ::OpenAPI::toJsonValue(d->root));
    }
    if (d->trash.isSet()) {
        obj.insert(QString("trash"), ::OpenAPI::toJsonValue(d->trash));
    }
    if (d->special_folder.isSet()) {
        obj.insert(QString("specialFolder"), ::OpenAPI::toJsonValue(d->special_folder));
    }
    if (d->remote_item.isSet()) {
        obj.insert(QString("remoteItem"), ::OpenAPI::toJsonValue(d->remote_item));
    }
    if (d->size_isSet) {
        obj.insert(QString("size"), ::OpenAPI::toJsonValue(d->size));
    }
    if (d->web_dav_url_isSet) {
        obj.insert(QString("webDavUrl"), ::OpenAPI::toJsonValue(d->web_dav_url));
    }
    if (d->children.size() > 0) {
        obj.insert(QString("children"), ::OpenAPI::toJsonValue(d->children));
    }
    if (d->permissions.size() > 0) {
        obj.insert(QString("permissions"), ::OpenAPI::toJsonValue(d->permissions));
    }
    return obj;
}

QString OAIDriveItem::getId() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->id;
}
void OAIDriveItem::setId(const QString &id) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->id = id;
    d->id_isSet = true;
}

bool OAIDriveItem::is_id_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->id_isSet;
}

bool OAIDriveItem::is_id_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->id_isValid;
}

OAIIdentitySet OAIDriveItem::getCreatedBy() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->created_by;
}
void OAIDriveItem::setCreatedBy(const OAIIdentitySet &created_by) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->created_by = created_by;
    d->created_by_isSet = true;
}

bool OAIDriveItem::is_created_by_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->created_by_isSet;
}

bool OAIDriveItem::is_created_by_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->created_by_isValid;
}

QDateTime OAIDriveItem::getCreatedDateTime() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->created_date_time;
}
void OAIDriveItem::setCreatedDateTime(const QDateTime &created_date_time) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->created_date_time = created_date_time;
    d->created_date_time_isSet = true;
}

bool OAIDriveItem::is_created_date_time_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->created_date_time_isSet;
}

bool OAIDriveItem::is_created_date_time_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->created_date_time_isValid;
}

QString OAIDriveItem::getDescription() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->description;
}
void OAIDriveItem::setDescription(const QString &description) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->description = description;
    d->description_isSet = true;
}

bool OAIDriveItem::is_description_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->description_isSet;
}

bool OAIDriveItem::is_description_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->description_isValid;
}

QString OAIDriveItem::getETag() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->e_tag;
}
void OAIDriveItem::setETag(const QString &e_tag) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->e_tag = e_tag;
    d->e_tag_isSet = true;
}

bool OAIDriveItem::is_e_tag_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->e_tag_isSet;
}

bool OAIDriveItem::is_e_tag_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->e_tag_isValid;
}

OAIIdentitySet OAIDriveItem::getLastModifiedBy() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->last_modified_by;
}
void OAIDriveItem::setLastModifiedBy(const OAIIdentitySet &last_modified_by) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->last_modified_by = last_modified_by;
    d->last_modified_by_isSet = true;
}

bool OAIDriveItem::is_last_modified_by_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->last_modified_by_isSet;
}

bool OAIDriveItem::is_last_modified_by_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->last_modified_by_isValid;
}

QDateTime OAIDriveItem::getLastModifiedDateTime() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->last_modified_date_time;
}
void OAIDriveItem::setLastModifiedDateTime(const QDateTime &last_modified_date_time) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->last_modified_date_time = last_modified_date_time;
    d->last_modified_date_time_isSet = true;
}

bool OAIDriveItem::is_last_modified_date_time_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->last_modified_date_time_isSet;
}

bool OAIDriveItem::is_last_modified_date_time_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->last_modified_date_time_isValid;
}

QString OAIDriveItem::getName() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->name;
}
void OAIDriveItem::setName(const QString &name) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->name = name;
    d->name_isSet = true;
}

bool OAIDriveItem::is_name_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->name_isSet;
}

bool OAIDriveItem::is_name_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->name_isValid;
}

OAIItemReference OAIDriveItem::getParentReference() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->parent_reference;
}
void OAIDriveItem::setParentReference(const OAIItemReference &parent_reference) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->parent_reference = parent_reference;
    d->parent_reference_isSet = true;
}

bool OAIDriveItem::is_parent_reference_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->parent_reference_isSet;
}

bool OAIDriveItem::is_parent_reference_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->parent_reference_isValid;
}

QString OAIDriveItem::getWebUrl() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->web_url;
}
void OAIDriveItem::setWebUrl(const QString &web_url) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->web_url = web_url;
    d->web_url_isSet = true;
}

bool OAIDriveItem::is_web_url_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->web_url_isSet;
}

bool OAIDriveItem::is_web_url_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->web_url_isValid;
}

QString OAIDriveItem::getContent() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->content;
}
void OAIDriveItem::setContent(const QString &content) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->content = content;
    d->content_isSet = true;
}

bool OAIDriveItem::is_content_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->content_isSet;
}

bool OAIDriveItem::is_content_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->content_isValid;
}

QString OAIDriveItem::getCTag() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->c_tag;
}
void OAIDriveItem::setCTag(const QString &c_tag) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->c_tag = c_tag;
    d->c_tag_isSet = true;
}

bool OAIDriveItem::is_c_tag_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->c_tag_isSet;
}

bool OAIDriveItem::is_c_tag_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->c_tag_isValid;
}

OAIDeleted OAIDriveItem::getDeleted() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->deleted;
}
void OAIDriveItem::setDeleted(const OAIDeleted &deleted) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->deleted = deleted;
    d->deleted_isSet = true;
}

bool OAIDriveItem::is_deleted_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->deleted_isSet;
}

bool OAIDriveItem::is_deleted_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->deleted_isValid;
}

OAIOpenGraphFile OAIDriveItem::getFile() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->file;
}
void OAIDriveItem::setFile(const OAIOpenGraphFile &file) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->file = file;
    d->file_isSet = true;
}

bool OAIDriveItem::is_file_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->file_isSet;
}

bool OAIDriveItem::is_file_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->file_isValid;
}

OAIFileSystemInfo OAIDriveItem::getFileSystemInfo() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->file_system_info;
}
void OAIDriveItem::setFileSystemInfo(const OAIFileSystemInfo &file_system_info) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->file_system_info = file_system_info;
    d->file_system_info_isSet = true;
}

bool OAIDriveItem::is_file_system_info_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->file_system_info_isSet;
}

bool OAIDriveItem::is_file_system_info_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->file_system_info_isValid;
}

OAIFolder OAIDriveItem::getFolder() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->folder;
}
void OAIDriveItem::setFolder(const OAIFolder &folder) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->folder = folder;
    d->folder_isSet = true;
}

bool OAIDriveItem::is_folder_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->folder_isSet;
}

bool OAIDriveItem::is_folder_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->folder_isValid;
}

OAIImage OAIDriveItem::getImage() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->image;
}
void OAIDriveItem::setImage(const OAIImage &image) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->image = image;
    d->image_isSet = true;
}

bool OAIDriveItem::is_image_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->image_isSet;
}

bool OAIDriveItem::is_image_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->image_isValid;
}

OAIObject OAIDriveItem::getRoot() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->root;
}
void OAIDriveItem::setRoot(const OAIObject &root) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->root = root;
    d->root_isSet = true;
}

bool OAIDriveItem::is_root_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->root_isSet;
}

bool OAIDriveItem::is_root_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->root_isValid;
}

OAITrash OAIDriveItem::getTrash() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->trash;
}
void OAIDriveItem::setTrash(const OAITrash &trash) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->trash = trash;
    d->trash_isSet = true;
}

bool OAIDriveItem::is_trash_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->trash_isSet;
}

bool OAIDriveItem::is_trash_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->trash_isValid;
}

OAISpecialFolder OAIDriveItem::getSpecialFolder() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->special_folder;
}
void OAIDriveItem::setSpecialFolder(const OAISpecialFolder &special_folder) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->special_folder = special_folder;
    d->special_folder_isSet = true;
}

bool OAIDriveItem::is_special_folder_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->special_folder_isSet;
}

bool OAIDriveItem::is_special_folder_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->special_folder_isValid;
}

OAIRemoteItem OAIDriveItem::getRemoteItem() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->remote_item;
}
void OAIDriveItem::setRemoteItem(const OAIRemoteItem &remote_item) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->remote_item = remote_item;
    d->remote_item_isSet = true;
}

bool OAIDriveItem::is_remote_item_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->remote_item_isSet;
}

bool OAIDriveItem::is_remote_item_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->remote_item_isValid;
}

qint64 OAIDriveItem::getSize() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->size;
}
void OAIDriveItem::setSize(const qint64 &size) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->size = size;
    d->size_isSet = true;
}

bool OAIDriveItem::is_size_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->size_isSet;
}

bool OAIDriveItem::is_size_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->size_isValid;
}

QString OAIDriveItem::getWebDavUrl() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->web_dav_url;
}
void OAIDriveItem::setWebDavUrl(const QString &web_dav_url) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->web_dav_url = web_dav_url;
    d->web_dav_url_isSet = true;
}

bool OAIDriveItem::is_web_dav_url_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->web_dav_url_isSet;
}

bool OAIDriveItem::is_web_dav_url_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->web_dav_url_isValid;
}

QList<OAIDriveItem> OAIDriveItem::getChildren() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->children;
}
void OAIDriveItem::setChildren(const QList<OAIDriveItem> &children) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->children = children;
    d->children_isSet = true;
}

bool OAIDriveItem::is_children_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->children_isSet;
}

bool OAIDriveItem::is_children_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->children_isValid;
}

QList<OAIPermission> OAIDriveItem::getPermissions() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return {};
    }
    return d->permissions;
}
void OAIDriveItem::setPermissions(const QList<OAIPermission> &permissions) {
    Q_D(OAIDriveItem);
    Q_ASSERT(d);

    d->permissions = permissions;
    d->permissions_isSet = true;
}

bool OAIDriveItem::is_permissions_Set() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }

    return d->permissions_isSet;
}

bool OAIDriveItem::is_permissions_Valid() const{
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    return d->permissions_isValid;
}

bool OAIDriveItem::isSet() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    bool isObjectUpdated = false;
    do {
        if (d->id_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->created_by.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->created_date_time_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->description_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->e_tag_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->last_modified_by.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->last_modified_date_time_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->name_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->parent_reference.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->web_url_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->content_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->c_tag_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->deleted.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->file.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->file_system_info.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->folder.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->image.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->root_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->trash.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->special_folder.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->remote_item.isSet()) {
            isObjectUpdated = true;
            break;
        }

        if (d->size_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->web_dav_url_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->children.size() > 0) {
            isObjectUpdated = true;
            break;
        }

        if (d->permissions.size() > 0) {
            isObjectUpdated = true;
            break;
        }
    } while (false);
    return isObjectUpdated;
}

bool OAIDriveItem::isValid() const {
    Q_D(const OAIDriveItem);
    if(!d){
        return false;
    }
    // only required properties are required for the object to be considered valid
    return true;
}

} // namespace OpenAPI
