<#--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->
<html>
<head>
<title>FreeMarker: Boolean Values Test</title>
</head>
<body>

<p>A simple test follows:</p>

<p>${message}</p>

<#assign b=true>

<p>Now perform scalar boolean tests:</p>

<p><#if b>
    b is true.<br />
<#else>
    b is false.<br />
</#if></p>

<p><#if false>
    This can't be!<br />
<#else>
    This makes sense.<br />
</#if></p>

<p><#if boolean3>
    boolean3 succeeded.<br />
<#else>
    boolean3 failed.<br />
</#if></p>

<p><#if boolean4>
    boolean4 succeeded.<br />
<#else>
    boolean4 failed.<br />
</#if></p>

<p><#if boolean4 || boolean5>
    boolean4 || boolean5 succeeded.<br />
<#else>
    boolean4 || boolean5 failed.<br />
</#if></p>

<p><#if boolean5 || boolean4 || boolean5>
    boolean5 || boolean4 || boolean5 succeeded.<br />
<#else>
    boolean5 || boolean4 || boolean5 failed.<br />
</#if></p>

<p><#if boolean4 && boolean5>
    boolean4 && boolean5 succeeded.<br />
<#else>
    boolean4 && boolean5 failed.<br />
</#if></p>
<@assert test=true &amp;&amp; true />
<@assert test=!(false &amp;&amp; true) />
<@assert test=true \and true />
<@assert test=!(false \and true) />
 
<p>Now test list models:</p>

<p><#if list1?exists>
    list1 succeeded.<br />
<#else>
    list1 failed.<br />
</#if></p>

<p><#if list2?exists>
    list2 succeeded.<br />
<#else>
    list2 failed.<br />
</#if></p>

<p>Test hash models:</p>

<p><#if hash1?exists>
    hash1 succeeded: ${hash1.temp}<br />
<#else>
    hash1 failed: ${hash1.temp}<br />
</#if></p>

<p><#if hash2?exists>
    hash2 succeeded.<br />
<#else>
    hash2 failed.<br />
</#if></p>

<p>Test not operator:</p>

<p><#if ! boolean1>
   Not boolean1 succeeded
<#else>
   Not boolean1 failed
</#if></p>

<p><#if !boolean1>
   Not boolean1 succeeded
<#else>
   Not boolean1 failed
</#if></p>

<p><#if ! boolean2>
   Not boolean2 succeeded
<#else>
   Not boolean2 failed
</#if></p>

<p><#if !boolean2>
   Not boolean2 succeeded
<#else>
   Not boolean2 failed
</#if></p>

<p><#if message == "Hello, world!">
   Message is "Hello, world!"
<#else>
   Message is something else (${message})
</#if></p>

<p><#if message != "Hello, world!">
   Message is not "Hello, world!" -- it's ${message}
<#else>
   Message is "Hello, world!"
</#if></p>

</body>
</html>
