/**********************************************************************
This software program is available to you under a choice of one of two 
licenses. You may choose to be licensed under either the GNU General Public 
License (GPL) Version 2, June 1991, available at 
http://www.fsf.org/copyleft/gpl.html, or the Intel BSD + Patent License, the 
text of which follows:

Recipient has requested a license and Intel Corporation ("Intel") is willing
to grant a license for the software entitled Linux Base Driver for the 
Intel(R) PRO/100 Family of Adapters (e100) (the "Software") being provided 
by Intel Corporation. The following definitions apply to this license:

"Licensed Patents" means patent claims licensable by Intel Corporation which 
are necessarily infringed by the use of sale of the Software alone or when 
combined with the operating system referred to below.

"Recipient" means the party to whom Intel delivers this Software.

"Licensee" means Recipient and those third parties that receive a license to 
any operating system available under the GNU Public License version 2.0 or 
later.

Copyright (c) 1999 - 2002 Intel Corporation.
All rights reserved.

The license is provided to Recipient and Recipient's Licensees under the 
following terms.

Redistribution and use in source and binary forms of the Software, with or 
without modification, are permitted provided that the following conditions 
are met:

Redistributions of source code of the Software may retain the above 
copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form of the Software may reproduce the above 
copyright notice, this list of conditions and the following disclaimer in 
the documentation and/or materials provided with the distribution.

Neither the name of Intel Corporation nor the names of its contributors 
shall be used to endorse or promote products derived from this Software 
without specific prior written permission.

Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
royalty-free patent license under Licensed Patents to make, use, sell, offer 
to sell, import and otherwise transfer the Software, if any, in source code 
and object code form. This license shall include changes to the Software 
that are error corrections or other minor changes to the Software that do 
not add functionality or features when the Software is incorporated in any 
version of an operating system that has been distributed under the GNU 
General Public License 2.0 or later. This patent license shall apply to the 
combination of the Software and any operating system licensed under the GNU 
Public License version 2.0 or later if, at the time Intel provides the 
Software to Recipient, such addition of the Software to the then publicly 
available versions of such operating systems available under the GNU Public 
License version 2.0 or later (whether in gold, beta or alpha form) causes 
such combination to be covered by the Licensed Patents. The patent license 
shall not apply to any other combinations which include the Software. NO 
hardware per se is licensed hereunder.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/

/*
*                                                                     		*
* This software is supplied under the terms of the license included   		*
* above.  All use of this driver must be in accordance with the terms 		*
* of that license.                                                    		*
*                                                                                        *
* Module Name:                                                                           *
*     eeprom.h                                                                           *
*                                                                                        *
* Abstract:                                                                              *
*     This module contains procedure declarations to read and write to a serial EEPROM   *
*                                                                                        *
*     This driver runs on the following hardware:                                        *
*     8255x based PCI 10/100Mb ethernet adapters                                         *
*                                                                                        *
******************************************************************************************/

#ifndef _EEPROM_H_
#define _EEPROM_H_

#include "e100.h"


#define EEPROM_SEMAPHORE_TIMEOUT		500

#define CSR_EEPROM_CONTROL_FIELD(bdp) ((bdp)->scbp->scb_eprm_cntrl)

#define CSR_GENERAL_CONTROL2_FIELD(bdp) ((bdp)->scbp->scb_ext.d102_scb.scb_gen_ctrl2)

#define WAIT_FOR_CONDITION(adapter, count, expr)                \
{   unsigned int    counter = (count) / 2;                      \
    while (!(expr) ) {                                          \
        udelay(2);                                              \
        if (!--counter) {                                       \
            break;                                              \
}}}

/*             */

#define STALL_TIME          100
#define EEPROM_CHECKSUM     (__u16)0xBABA
#define EEPROM_MAX_WORD_SIZE  256


int InitializeEEpromStructure(bd_config_t *adapter);

void InitializeEEpromBuffer(bd_config_t *adapter);
void ShiftOutBits(bd_config_t *adapter, __u16 data, __u16 count);
void RaiseClock(bd_config_t *adapter, __u16 *x);
void LowerClock(bd_config_t *adapter, __u16 *x);
void EEpromCleanup(bd_config_t *adapter);
void UpdateChecksum(bd_config_t *adapter);
void WriteEEprom(bd_config_t *adapter, __u16 reg, __u16 data);
void StandBy(bd_config_t *adapter);

__u16 GetEEpromSize(bd_config_t *adapter);
__u16 ReadEEprom(bd_config_t *adapter, __u16 reg);
__u16 ShiftInBits(bd_config_t *adapter);
__u16 WaitEEpromCmdDone(bd_config_t *adapter);


unsigned char ReadEEpromNodeAddress(bd_config_t *adapter, __u8 *buffer, unsigned int size);


//----------------------------------------------------------------------------------------
// Procedure:   EepromSetSemaphore
//
// Description: This function set (write 1) Gamla EEPROM semaphore bit (bit 23 word 0x1C in the CSR).
//
// Arguments:
//      Adapter                 - Adapter context
//
// Returns:  TRUE if success
//           else return FALSE 
//
//----------------------------------------------------------------------------------------

inline unsigned char EepromSetSemaphore(bd_config_t *adapter)
{
    __u16  data=0;
    
    // Get current value of General Control 2
    data = readb(&CSR_GENERAL_CONTROL2_FIELD(adapter));
    
    // Set bit 23 word 0x1C in the CSR.
    data |= SCB_GCR2_EEPROM_ACCESS_SEMAPHORE;
    writeb(data, &CSR_GENERAL_CONTROL2_FIELD(adapter));

    // Check to see if this bit set or not.
    data = readb(&CSR_GENERAL_CONTROL2_FIELD(adapter));
    
    return ((data & SCB_GCR2_EEPROM_ACCESS_SEMAPHORE) ? B_TRUE: B_FALSE);
}

//----------------------------------------------------------------------------------------
// Procedure:   EepromResetSemaphore
//
// Description: This function reset (write 0) Gamla EEPROM semaphore bit (bit 23 word 0x1C in the CSR).
//
// Arguments:
//      Adapter                 - Adapter context
//
// Returns:  Nothing
//
//----------------------------------------------------------------------------------------

inline void EepromResetSemaphore(bd_config_t *adapter)
{
    __u16  data=0;

    // Get current value of General Control 2
    data = readb(&CSR_GENERAL_CONTROL2_FIELD(adapter));
    
    // Reset bit 23 word 0x1C in the CSR.
    data &= ~(SCB_GCR2_EEPROM_ACCESS_SEMAPHORE) ;
    writeb(data, &CSR_GENERAL_CONTROL2_FIELD(adapter));
}

#endif      // _EEPROM_H_
