/**********************************************************************
This software program is available to you under a choice of one of two 
licenses. You may choose to be licensed under either the GNU General Public 
License (GPL) Version 2, June 1991, available at 
http://www.fsf.org/copyleft/gpl.html, or the Intel BSD + Patent License, the 
text of which follows:

Recipient has requested a license and Intel Corporation ("Intel") is willing
to grant a license for the software entitled Linux Base Driver for the 
Intel(R) PRO/100 Family of Adapters (e100) (the "Software") being provided 
by Intel Corporation. The following definitions apply to this license:

"Licensed Patents" means patent claims licensable by Intel Corporation which 
are necessarily infringed by the use of sale of the Software alone or when 
combined with the operating system referred to below.

"Recipient" means the party to whom Intel delivers this Software.

"Licensee" means Recipient and those third parties that receive a license to 
any operating system available under the GNU Public License version 2.0 or 
later.

Copyright (c) 1999 - 2002 Intel Corporation.
All rights reserved.

The license is provided to Recipient and Recipient's Licensees under the 
following terms.

Redistribution and use in source and binary forms of the Software, with or 
without modification, are permitted provided that the following conditions 
are met:

Redistributions of source code of the Software may retain the above 
copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form of the Software may reproduce the above 
copyright notice, this list of conditions and the following disclaimer in 
the documentation and/or materials provided with the distribution.

Neither the name of Intel Corporation nor the names of its contributors 
shall be used to endorse or promote products derived from this Software 
without specific prior written permission.

Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
royalty-free patent license under Licensed Patents to make, use, sell, offer 
to sell, import and otherwise transfer the Software, if any, in source code 
and object code form. This license shall include changes to the Software 
that are error corrections or other minor changes to the Software that do 
not add functionality or features when the Software is incorporated in any 
version of an operating system that has been distributed under the GNU 
General Public License 2.0 or later. This patent license shall apply to the 
combination of the Software and any operating system licensed under the GNU 
Public License version 2.0 or later if, at the time Intel provides the 
Software to Recipient, such addition of the Software to the then publicly 
available versions of such operating systems available under the GNU Public 
License version 2.0 or later (whether in gold, beta or alpha form) causes 
such combination to be covered by the Licensed Patents. The patent license 
shall not apply to any other combinations which include the Software. NO 
hardware per se is licensed hereunder.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/

/**********************************************************************
*                                                                     *
* INTEL CORPORATION                                                   *
*                                                                     *
* This software is supplied under the terms of the license included   *
* above.  All use of this driver must be in accordance with the terms *
* of that license.                                                    *
*                                                                     *
* Module Name:  base_comm.h                                           *
*                                                                     *
* Abstract: iANS to base communication defines                        *
*                                                                     *
* Environment:                                                        *
*                                                                     *
**********************************************************************/

#ifndef _IANS_BASE_COMM_H
#define _IANS_BASE_COMM_H


#include <linux/sockios.h> /* for SIOCDEVPRIVATE */

#define UINT16 __u16
#define UINT32 __u32
#define UCHAR  __u8


/* Make sure all communications parties use the same packing mode
 * for the shared structures. */
#ifdef __ia64__
#pragma pack(8)
#else
#pragma pack(4)
#endif /*  __ia64__ */ 

#ifdef _IANS_MAIN_MODULE_C_
#define IntOrExt
#else
#define IntOrExt extern
#endif


/*--------------------------------------------------------------------*
 | PRIMITIVES baring iANS communications
 | =====================================
 *--------------------------------------------------------------------*/

/* The proprietary iANS IOCTL code */
#define IANS_BASE_SIOC          (SIOCDEVPRIVATE+1)
/* The proprietary event notifications code */
#define IANS_BASE_NOTIFY        (('S'<<24)|('N'<<16)|('A'<<8)|('i')) /* "iANS" */


/*------------------------------------------------------------------*
|   Communication version : 
|   this is the version of the communication protocol described in 
|   this header file. 
|   This information will be passed in the IANS_BD_IDENTIFY ioctl 
*------------------------------------------------------------------*/

/* iANS's communications version */
#define IANS_COMM_VERSION_MAJOR (UINT16)1
#define IANS_COMM_VERSION_MINOR (UINT16)0

/* Base driver's version */ 
#define IANS_BD_COMM_VERSION_MAJOR (UINT16)1
#define IANS_BD_COMM_VERSION_MINOR (UINT16)0

#define IANS_SIGNATURE_LENGTH 80

IntOrExt char IntelCopyrightString[IANS_SIGNATURE_LENGTH]
#ifdef _IANS_MAIN_MODULE_C_
= "Intel Copyright 1999, all rights reserved\n";
#else
;
#endif




/* ================================================================== *
 *                                                                    *
 *                               IOCTLs                               *
 *                                                                    *
 * ================================================================== */



/*--------------------------------------------------------------------*
 |                 Proprietary Opcodes
 *--------------------------------------------------------------------*/

typedef enum _IANS_BASE_OPCODE
{

    /* ----------  Basic Extension Commands  ---------- */
    IANS_OP_BD_IDENTIFY,          /* Identify BD to make sure it 
                                     supports iANS comm.*/
    /* BD fills Struct:  IANS_BD_PARAM_IDENTIFY */
    IANS_OP_BD_DISCONNECT,        /* Tell the BD that iANS is about to unload */
    IANS_OP_EXT_GET_CAPABILITY,   /* Get extended capabilities */
    /* BD fills struct: _IANS_BD_PARAM_EXT_CAP */
    IANS_OP_EXT_SET_MODE,         /* Set extended capabilities */
    /* iANS fills struct: _IANS_BD_PARAM_EXT_SET_MODE */
    IANS_OP_EXT_GET_STATUS,               /* Get status from base driver */
    /* BD fills status struct: IANS_BD_IOC_PARAM_STATUS */


    IANS_OP_ANS_SET_CB, /* pass ans function's pointers to base */

#ifdef IANS_BASE_ADAPTER_TEAMING
    /* ----------  Adapter Teaming Commands  ---------- */
    IANS_OP_IAT_FIRST=0x0100,     /* Skip over reserved area */
    /* There are no commands specific to adapter teaming */
    /* Capabilities are included in "Extended capabilities" */
#endif /* IANS_BASE_ADAPTER_TEAMING */

#ifdef IANS_BASE_VLAN_TAGGING
    /* ----------  VLan Tagging Commands  ---------- */
    IANS_OP_ITAG_FIRST=0x0200,          /* Skip over reserved area */
    IANS_OP_ITAG_GET_CAPABILITY,        /* Get tagging capabilities */
    /* BD fills struct: IANS_BD_PARAM_ITAG_CAP */
    IANS_OP_ITAG_SET_MODE,                      /* None/ISL/802.3ac */
    /* IANS fills struct: IANS_BD_PARAM_ITAG_SET_MODE */
#endif /* IANS_BASE_VLAN_TAGGING */

#ifdef IANS_BASE_VLAN_ID
    /* ----------  VLan ID Commands  ---------- */
    IANS_OP_IVLAN_ID_FIRST=0x0300,       /* Skip over reserved area */
    IANS_OP_IVLAN_ID_GET_CAPABILITY, /* Get VLan ID capabilities */
    /* BD fills struct: IANS_BD_PARAM_IVLAN_CAP */
    IANS_OP_IVLAN_ID_SET_MODE,           /* Set Vlan ID mode */
    /* iANS fills struct: IANS_BD_PARAM_IVLAN_SET_MODE*/
    IANS_OP_IVLAN_ID_SET_TABLE,          /* ID list */
    /* iANS fills struct: IANS_BD_PARAM_IVLAN_TABLE */
#endif /* IANS_BASE_VLAN_ID */

    /* ---------- */
    IANS_OP_COMMA       /* Dummy to satisfy last ifdef'ed commma */

} IANS_BASE_OPCODE, *PIANS_BASE_OPCODE;


/*--------------------------------------------------------------------*
 |                Enumerated types for field values
 *--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*
 |             Enumerated types for Status struct field values
 *--------------------------------------------------------------------*
 | In every field, if a base driver doesn't support a valid indication 
 | on that field it should set it to zero. This value was picked in 
 | every enumerated type to denote "not supported" value.
 *--------------------------------------------------------------------*/


/* Used in IANS_BD_PARAM_STATUS.LinkStatus */
typedef enum _IANS_BD_LINK_STATUS 
{
    IANS_STATUS_LINK_NOT_SUPPORTED = 0,
    IANS_STATUS_LINK_OK,
    IANS_STATUS_LINK_FAIL
} IANS_BD_LINK_STATUS, *PIANS_BD_LINK_STATUS;

/* Used in IANS_BD_PARAM_STATUS.Duplex */
typedef enum _IANS_BD_DUPLEX_STATUS 
{
    IANS_STATUS_DUPLEX_NOT_SUPPORTED = 0,
    IANS_STATUS_DUPLEX_HALF,
    IANS_STATUS_DUPLEX_FULL
} IANS_BD_DUPLEX_STATUS, *PIANS_BD_DUPLEX_STATUS;

/* Used in IANS_BD_PARAM_STATUS.LinkSpeed */

typedef enum _IANS_BD_LINK_SPEED {
    IANS_STATUS_LINK_SPEED_NOT_SUPPORTED = 0,
    IANS_STATUS_LINK_SPEED_1MBPS = 0x1,
    IANS_STATUS_LINK_SPEED_10MBPS = 0x2,
    IANS_STATUS_LINK_SPEED_100MBPS = 0x4,
    IANS_STATUS_LINK_SPEED_1000MBPS = 0x8
}IANS_BD_LINK_SPEED, *PIANS_BD_LINK_SPEED;


/* Used in IANS_BD_PARAM_STATUS.HardwareFailure */
typedef enum _IANS_BD_HW_STATUS {
    IANS_STATUS_HARDWARE_NOT_SUPPORTED = 0,
    IANS_STATUS_HARDWARE_OK,
    IANS_STATUS_HARDWARE_FAILURE
} IANS_BD_HW_STATUS, *PIANS_BD_HW_STATUS;

/* Used in IANS_BD_PARAM_STATUS.DuringResetProcess */
typedef enum _IANS_BD_RESET_STAGE {
    IANS_STATUS_RESET_NOT_SUPPORTED =0,
    IANS_STATUS_NOT_DURING_RESET,
    IANS_STATUS_DURING_RESET
} IANS_BD_RESET_STAGE, *PIANS_BD_RESET_STAGE;

/* Used in IANS_BD_PARAM_STATUS.Suspended */
typedef enum _IANS_BD_SUSPENDED_STAGE {
    IANS_STATUS_SUSPENDED_NOT_SUPPORTED =0,
    IANS_STATUS_NOT_SUSPENDED,
    IANS_STATUS_SUSPENDED
} IANS_BD_SUSPENDED_STAGE, *PIANS_BD_SUSPENDED_STAGE;

/* Rx and event notification routing mechanisms (bitmask ready) */
typedef enum _IANS_BD_ROUTING {
    IANS_ROUTING_NOT_SUPPORTED  = 0x00,
    IANS_ROUTING_RX_PROTOCOL    = 0x01,
} IANS_BD_ROUTING, *PIANS_BD_ROUTING;

typedef enum _IANS_BD_HOT_PLUG_STATUS {
    IANS_STATUS_HOT_PLUG_NOT_SUPPORTED = 0,
    IANS_STATUS_HOT_PLUG_NOT_DONE,
    IANS_STATUS_HOT_PLUG_WAS_DONE
} IANS_BD_HOT_PLUG_STATUS, *PIANS_BD_HOT_PLUG_STATUS;

/*--------------------------------------------------------------------*
 |         Enumerated types for general structs field values
 *--------------------------------------------------------------------*/

/* general typedef for various features - whether BD supports a feature 
   or not. To be used on "capabilites" structs */

typedef enum _IANS_BD_SUPPORT {
    IANS_BD_DOES_NOT_SUPPORT = 0,
    IANS_BD_SUPPORTS
} IANS_BD_SUPPORT, *PIANS_BD_SUPPORT;

/* general typedef for various features - whether iANS requests the BD 
   to support a feature or not. To be used on "set mode" structs. */
typedef enum _IANS_BD_REQUEST_SUPPORT {
    IANS_DONT_SUPPORT = 0,
    IANS_REQUEST_SUPPORT
} IANS_BD_REQUEST_SUPPORT, *PIANS_BD_REQUEST_SUPPORT;



/*--------------------------------------------------------------------*
 |                    Ioctl parameter structs
 |                    =======================
 | The following structures are used by the different IOCTLs to pass
 | parameters between the Base driver and iANS.
 *--------------------------------------------------------------------*/


/*--------------------------------------------------------------------*
 |                 Common Command/Parameter Header
 |                 ===============================
 | The 1st field of every parameter struct.
 *--------------------------------------------------------------------*/

typedef struct _IANS_BD_PARAM_HEADER
{
    // Cast from IANS_BASE_OPCODE to insure forward size compatibility 
    /* UINT32 */ int    Opcode; 
} IANS_BD_PARAM_HEADER, *PIANS_BD_PARAM_HEADER;


/*--------------------------------------------------------------------*
 |                 Status result
 |                 =============
 | This struct is sent with as a response to GET_STATUS request.
 | The status struct contains a version number : in case we will wish to 
 | extend the status result, we will need a way to indicate which 
 | version of the status struct we support. 
 *--------------------------------------------------------------------*/
#define IANS_STATUS_VERSION        0x00000001

typedef struct _IANS_BD_PARAM_STATUS
{  
    UINT32     StatusVersion;       /* The version of this struct */
    
    UINT32     LinkStatus;          /* Cast from IANS_BD_LINK_STATUS */
    UINT32     LinkSpeed;           /* Cast from IANS_BD_LINK_SPEED */
    UINT32     Duplex;              /* Cast from IANS_BD_DUPLEX_STATUS  */
    UINT32     HardwareFailure;     /* Cast from IANS_BD_HW_FAILURE */
    UINT32     DuringResetProcess;  /* Cast from IANS_BD_RESET_STAGE  */
    UINT32     Suspended;           /* Cast from IANS_BD_SUSPENDED_STAGE  */

    UINT32     HotPlug;    /* Cast from IANS_BD_HOT_PLUG_STATUS  */
} IANS_BD_PARAM_STATUS, *PIANS_BD_PARAM_STATUS;

/*--------------------------------------------------------------------*
 |                 Status ioctl result
 |                 ===================
 | This structure is the struct sent as a response to the GET_STATUS 
 | request ioctl. It contains the ioctl header, and the status struct.
 *--------------------------------------------------------------------*/

typedef struct _IANS_BD_IOC_PARAM_STATUS
{
    IANS_BD_PARAM_HEADER           Header;                /* Common to all commands */
    IANS_BD_PARAM_STATUS   Status;
} IANS_BD_IOC_PARAM_STATUS, *PIANS_BD_IOC_PARAM_STATUS;



/*--------------------------------------------------------------------*
 |                    Identify yourself struct
 |                    ========================
 | This struct is sent with the IANS_BD_IDENTIFY request. 
 | iANS fills its signature string and version number, and sends it to
 | the base driver. The base driver fills its own signature string and
 | version adn returns it.
 *--------------------------------------------------------------------*/

typedef struct _IANS_BD_PARAM_IDENTIFY
{
    IANS_BD_PARAM_HEADER           Header;                 /* Common to all commands */

    UCHAR      iANSSignature[IANS_SIGNATURE_LENGTH]; 
    /* iANS fills copyright string*/
    UCHAR      BDSignature[IANS_SIGNATURE_LENGTH];   
    /* BD fills copyright string*/
    UINT32     iANSCommVersion;  /* iANS supported comm. version */
    /* Upper word = major version number */
    /* lower word = minor version number */
    UINT32     BDCommVersion;    /* Base driver supported comm. version */
} IANS_BD_PARAM_IDENTIFY, *PIANS_BD_PARAM_IDENTIFY;



/*--------------------------------------------------------------------*
 |                 Get Extended capabilities parameters struct
 |                 =========================================== 
 | This struct is sent with IANS_OP_EXT_GET_CAPABILITY - to be filled 
 | by the base driver and sent to iANS
 *--------------------------------------------------------------------*/ 
#define IANS_BD_FLAG1           0x0001
#define IANS_BD_FLAG2           0x0002
#define IANS_BD_FLAG3           0x0004
#define IANS_BD_FLAG4           0x0008
#define IANS_BD_FLAG5           0x0010
#define IANS_BD_FLAG6           0x0020
#define IANS_BD_FLAG7           0x0040
#define IANS_BD_FLAG8           0x0080


typedef struct _IANS_BD_PARAM_EXT_CAP
{
    IANS_BD_PARAM_HEADER           Header;                 /* Common to all commands */

    UINT32 BDCanSetMacAddress;    /* MAC Address setting - cast from 
                                     IANS_BD_SUPPORT*/
    UINT32 BDIansStatusVersion;    /* Status indication with iANS struct 
                                      - which version is supported  */
    UINT32 BDAllAvailableRouting;               /* Bitmask of all available Rx/Event
                                                 * routings. IANS_BD_ROUTING */

    UINT32     BDFlags;    /* The adapter's flags */

    UINT32     BDAllAvailableSpeeds; /* A bit mask of all available speeds */

} IANS_BD_PARAM_EXT_CAP, *PIANS_BD_PARAM_EXT_CAP;


/*--------------------------------------------------------------------*
 |                    Set Extended mode parameters struct
 |                    ======================================== 
 | This struct is sent with IANS_OP_EXT_SET_MODE - to be filled 
 | by iANS and sent to the base driver
 |
 | iANS tells the base driver whether to report its status through
 | the extended struct or not.
 *--------------------------------------------------------------------*/ 


typedef struct _IANS_BD_PARAM_EXT_SET_MODE
{
    IANS_BD_PARAM_HEADER           Header; /* Common to all commands */

    UINT32 BDIansStatusReport;   /* Ask the base driver to report status through 
                                  * status struct.  
                                  * Cast from IANS_BD_REQUEST. */

    UINT32 BDIansAttributedMode; /* Ask the base driver to send and receive
                                  * packets accompanied by a per-frame data structure
                                  * Cast from IANS_BD_REQUEST. */

    UINT32 BDIansRoutingMode;    /* Bitmask of one Rx and one IANS_BD_ROUTING */


} IANS_BD_PARAM_EXT_SET_MODE, *PIANS_BD_PARAM_EXT_SET_MODE;



#ifdef IANS_BASE_VLAN_TAGGING

/*--------------------------------------------------------------------*
 |                  Get Vlan tagging capabilities
 |                  =============================
 | This struct is sent with the IANS_OP_ITAG_GET_CAPABILITY ioctl, to be filled 
 | by the base driver.
 *--------------------------------------------------------------------*/

typedef struct _IANS_BD_PARAM_ITAG_CAP
{
    IANS_BD_PARAM_HEADER           Header;                 /* Common to all commands */

    UINT32                 ISLTagMode;         /* cast from IANS_BD_SUPPORT */
    UINT32                 IEEE802_3acTagMode; /* cast from IANS_BD_SUPPORT */

} IANS_BD_PARAM_ITAG_CAP, *PIANS_BD_PARAM_ITAG_CAP;

/*--------------------------------------------------------------------*
 |                  Set Vlan tagging mode
 |                  =====================
 | This struct is sent with the IANS_OP_ITAG_SET_MODE ioctl, to be filled 
 | by iANS.
 *--------------------------------------------------------------------*/

typedef enum _IANS_BD_TAGGING_MODE 
{
    IANS_BD_TAGGING_NONE =0,
    IANS_BD_TAGGING_802_3AC,
    IANS_BD_TAGGING_ISL,
    IANS_BD_TAGGING_UNDEFINED
}IANS_BD_TAGGING_MODE , *PIANS_BD_TAGGING_MODE ;

typedef struct _IANS_BD_PARAM_ITAG_SET_MODE
{
    IANS_BD_PARAM_HEADER           Header;              /* Common to all commands */

    UINT32                SetTagMode;  /* cast from IANS_BD_TAGGING_MODE  */
} IANS_BD_PARAM_ITAG_SET_MODE, *PIANS_BD_PARAM_ITAG_SET_MODE;

#endif /* IANS_BASE_VLAN_TAGGING */


#ifdef IANS_BASE_VLAN_ID

/*--------------------------------------------------------------------*
 |            Get Vlan ID capabilities
 |            ========================
 | This struct is sent with the IANS_OP_IVLAN_ID_GET_CAPABILITY ioctl, 
 | to be filled by the base driver
 *--------------------------------------------------------------------*/

typedef struct _IANS_BD_PARAM_IVLAN_CAP
{
    IANS_BD_PARAM_HEADER           Header;                 /* Common to all commands */

    UINT32           VlanIDCapable;          /* Cast from IANS_BD_SUPPORT */
    UINT32           VlanIDFilteringAble;    /* Cast from IANS_BD_SUPPORT */
    UINT16           MaxVlanIDSupported;     /* Max. VLan ID supported by BD */
    UINT32           MaxVlanTableSize;       /* Max. number of VLan IDs in a table */
} IANS_BD_PARAM_IVLAN_CAP, *PIANS_BD_PARAM_IVLAN_CAP;

/*--------------------------------------------------------------------*
 |           Set Vlan ID mode
 |           ================ 
 | This struct is sent with the IANS_OP_IVLAN_ID_SET_MODE ioctl, filled
 | by the iANS 
 *--------------------------------------------------------------------*/ 

typedef struct _IANS_BD_PARAM_IVLAN_SET_MODE
{
    IANS_BD_PARAM_HEADER           Header;                    /* Common to all commands */
    UINT32           VlanIDRequest;           /* Cast from IANS_BD_REQUEST */
    UINT32           VlanIDFilteringRequest;  /* Cast from IANS_BD_REQUEST */
} IANS_BD_PARAM_IVLAN_SET_MODE, *PIANS_BD_PARAM_IVLAN_SET_MODE;

/*--------------------------------------------------------------------*
 |          Set Vlan ID filtering table
 |          ===========================
 | This struct is sent with the IANS_OP_IVLAN_ID_SET_TABLE request
 *--------------------------------------------------------------------*/

typedef struct _IANS_BD_PARAM_IVLAN_TABLE
{
    IANS_BD_PARAM_HEADER           Header;         /* Common to all commands */

    UINT32        VLanIDNum;       /* Number of VLan IDs defined in 
                                      this table */
    UINT16        *VLanIDTable;  /* Beginning of ID list. 
                                    * iANS will allocate enough space 
                                    * for the whole table, and it will 
                                    * start from this field - we don't 
                                    * want to force this struct to be 
                                    * as big as the maximum number of 
                                    * VLan IDs. */

} IANS_BD_PARAM_IVLAN_TABLE, *PIANS_BD_PARAM_IVLAN_TABLE;

#endif /* IANS_BASE_VLAN_ID */



/*--------------------------------------------------------------------*
 |                PER_FRAME_ATTRIBUE_HEADER
 |                *************************
 | This header will be included in every TLV 
 *--------------------------------------------------------------------*/

typedef struct _Per_Frame_Attribute_Header
{
    UINT32               AttributeID;   /* Indicates which kind of data is contained
                                           in this field */
    UINT32               AttributeLength; /* Length of this attribute */
} Per_Frame_Attribute_Header, *pPer_Frame_Attribute_Header;


/* ================================================================= *
 *                                                                   *
 *                           Per-Message Attributes                  *
 *                                                                   *
 * ================================================================= */

typedef struct _IANS_ATTR_HEADER
{
    pPer_Frame_Attribute_Header         pFirstTLV;              /* NULL if not attributed */
    UINT32                                      OriginalProtocol;
} IANS_ATTR_HEADER, *PIANS_ATTR_HEADER;

/* Turn into a legal pointer */
#if defined(__i386__)
#define CelingAlignPtr(p)       ( p )
#else
#define CelingAlignPtr(p)       ( p )
#endif

/* The attribute header is kept at the beginning of the allocated buffer */
#define iANSGetReceiveAttributeHeader(skb) \
                ( (IANS_ATTR_HEADER*) CelingAlignPtr ( (char*)((skb)->head) ) ) 
#define iANSGetTransmitAttributeHeader(skb) \
                ( (IANS_ATTR_HEADER*) CelingAlignPtr ( (char*)((skb)->cb) ) ) 





/*--------------------------------------------------------------------*
 |                Attribute IDs
 |                *************
 | These values indicate which type of attribute is contained in a
 | certain TLV.
 *--------------------------------------------------------------------*/

typedef enum _iANS_Attribute_ID
{
    IANS_ATTR_LAST_ATTR=0, /* Marks the last attribute in a list */
    IANS_ATTR_DUMMY,       /* Non-initiating side should ignore this attribute */

#ifdef IANS_BASE_VLAN_ID 
    IANS_ATTR_VLAN_FIRST = 0x100, /* skip over reserved area */
    IANS_ATTR_VLAN_ID,     /* This attribute contains the VLan ID */
#endif /* IANS_BASE_VLAN_ID */ 

#ifdef IANS_BASE_VLAN_TAGGING
    IANS_ATTR_TAGGING_FIRST = 0x200, /* skip over reserved area */
    IANS_ATTR_TAGGING_UNTAGGED,     /* This determines that frame is untagged */
#endif /* IANS_BASE_VLAN_TAGGING */ 

    IANS_ATTR_COMMA
} iANS_Attribute_ID,  *piANS_Attribute_ID; 




#ifdef IANS_BASE_VLAN_ID

/*-------------------------------------------------------------------
|                       VLAN_ID_PER_FRAME_INFO
|                       **********************
| This structure contains only the VLanID per-frame information.
 -------------------------------------------------------------------*/
typedef struct _VLAN_ID_Per_Frame_Info 
{
    Per_Frame_Attribute_Header  AttrHeader;

    UINT16 VLanID;
    UCHAR  Padding[2];

} VLAN_ID_Per_Frame_Info  , *pVLAN_ID_Per_Frame_Info ;

#endif /* IANS_BASE_VLAN_ID */


#ifdef IANS_BASE_VLAN_TAGGING

/*-------------------------------------------------------------------
|                       Untagged_Attribute
|                       ******************
| This structure is for the "untagged" attribute (used to indicate
| that frame is untagged).
 -------------------------------------------------------------------*/

typedef struct _Untagged_Attribute
{
    Per_Frame_Attribute_Header  AttrHeader;

} Untagged_Attribute  , *pUntagged_Attribute ;

#endif /* IANS_BASE_VLAN_TAGGING */


/*-------------------------------------------------------------------
|                       LAST_ATTRIBUTE
|                       **************
| This structure is for the last attribute in the TLV list.
 -------------------------------------------------------------------*/

typedef struct _Last_Attribute
{
    Per_Frame_Attribute_Header  LastHeader;

} Last_Attribute, *pLast_Attribute ;


/*--------------------------------------------------------------------*
 |                      Indication 
 |                     ============                   
 | This enum value is sent by the notify call back function
 | called by the base driver for indication purposes.
 *--------------------------------------------------------------------*/

typedef enum _IANS_INDICATION 
{
    /* ----------  Basic Extention Indications  ---------- */
    IANS_IND_EXT_HWMODIFY,                          
                                   
    IANS_IND_EXT_STATUS_CHANGE,     /* Report a new status */
                                      
    IANS_IND_XMIT_QUEUE_FULL, // tell ANS to stop transmit through this member

    IANS_IND_XMIT_QUEUE_READY, // tell ANS to start transmit through this member
                                      
    IANS_IND_COMMA  /* Dummy to satisfy last ifdef'ed commma */
        
} IANS_INDICATION, *PIANS_INDICATION;




typedef struct _IANS_BD_ANS_SET_CB {
    IANS_BD_PARAM_HEADER           Header;
    void *notify;
} IANS_BD_ANS_SET_CB, *PIANS_BD_ANS_SET_CB;



/* ================================================================= *
 *                                                                   *
 *                              Rx Routing                           *
 *                                                                   *
 * ================================================================= */
// temp debug
#define IANS_FRAME_TYPE         0x6D88  /*  Network order is 0x886D */


/* Restore packing mode. */
#pragma pack()


#endif /* _IANS_BASE_COMM_H */


