/*
    parted - a frontend to libparted
    Copyright (C) 1999, 2000 Free Software Foundation, Inc.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef STRLIST_H_INCLUDED
#define STRLIST_H_INCLUDED

#include <wchar.h>

typedef struct _StrList StrList;
struct _StrList {
	StrList*	next;
	const wchar_t*	str;
};

extern char* language;
extern char* gettext_charset;
extern char* term_charset;

extern int init_str_list ();
extern int done_str_list ();

extern StrList* str_list_create (const char* first, ...);
extern StrList* str_list_create_unique (const char* first, ...);
extern void str_list_destroy (StrList* list);

extern StrList* str_list_append (StrList* list, const char* str);
extern StrList* str_list_append_unique (StrList* list, const char* str);
extern char* str_list_convert (const StrList* list);
extern char* str_list_convert_node (const StrList* list);

extern void str_list_print (const StrList* list);
extern void str_list_print_wrap (const StrList* list, int line_length,
				 int offset, int indent);
extern int str_list_match (StrList* list, char* str);
extern int str_list_match_node (StrList* list, char* str);

#endif /* STRLIST_H_INCLUDED */
