##
##  snmpdx -- SNMP Daemon Extension
##  Copyright (c) 2003 The OSSP Project <http://www.ossp.org/>
##  Copyright (c) 2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##
##  sysFs: System, Filesystem
##

package My::Probe::sysFs;
our @ISA = qw(My::Probe);

sub oids ($) {
    my ($self) = @_;
    return $self->{-ctx}->{-mib}->oids("*.snmpdx.host.system.sysFs.*");
}

sub probe ($$) {
    my ($self, $obj) = @_;

    if ($self->{-ctx}->{-platform}->id() =~ m/FreeBSD/i) {
    	my @sysFsInfoENTRY  = undef;
        
        #   local workspace
		my $out; my $raw; my $n2i; my @dat; my $new;

        #  	process df
        $out = $self->{-ctx}->{-sys}->run("/bin/df -m", "1m");
        $raw = $out->{-stdout};
		$n2i = {};
		if ($raw =~ m/^([^\n]*\bFilesystem\b[^\n]*)\n(.*)$/s) {
			$n2i = &mkn2i(split / +/, $1);
			foreach $line (split "\n", $2) {
				@dat = split(/ +/, $line);
				if (@dat[$n2i->{Filesystem}] =~ m|^/dev/|) {
					$new = {};
					if (defined $n2i->{Filesystem}) {
						$new->{sysFsDevice} = @dat[$n2i->{Filesystem}];
					}
					if (defined $n2i->{Mounted}) {
						$new->{sysFsMountpoint} = @dat[$n2i->{Mounted}];
					}
					if (defined $n2i->{_1M_blocks}) {
						$new->{sysFsMax} = @dat[$n2i->{_1M_blocks}];
					}
					if (defined $n2i->{Avail}) {
						$new->{sysFsFree} = @dat[$n2i->{Avail}];
					}
					if (defined $new->{sysFsMax} and defined $new->{sysFsFree}) {
						$new->{sysFsUsed} = $new->{sysFsMax} - $new->{sysFsFree};
					}
					push(@sysFsInfoENTRY, $new);
				}
			}
        }

        if ($obj->{-name} =~ m/\.sysFsInfoENTRY\.([^.]+)\.(\d+)$/) {
            my $col = $1;
            my $row = ($2 > 0 ? $2 - 1 : 0);
            $self->{-ctx}->{-log}->printf(4, "col=%s row=%s", $col, $row);
            $obj->{-value} = @sysFsInfoENTRY[$row]->{$col} if (defined @sysFsInfoENTRY[$row] and defined @sysFsInfoENTRY[$row]->{$col});
        }
    }
    elsif ($self->{-ctx}->{-platform}->id() =~ m/Linux/i) {
    	my @sysFsInfoENTRY  = undef;
        
        #   local workspace
		my $out; my $raw; my $n2i; my @dat; my $new;

        #  	process df
        $out = $self->{-ctx}->{-sys}->run("/bin/df -m", "1m");
        $raw = $out->{-stdout};
		$n2i = {};
		if ($raw =~ m/^([^\n]*\bFilesystem\b[^\n]*)\n(.*)$/s) {
			$n2i = &mkn2i(split / +/, $1);
			foreach $line (split "\n", $2) {
				@dat = split(/ +/, $line);
				if (@dat[$n2i->{Filesystem}] =~ m|^/dev/|) {
					$new = {};
					if (defined $n2i->{Filesystem}) {
						$new->{sysFsDevice} = @dat[$n2i->{Filesystem}];
					}
					if (defined $n2i->{Mounted}) {
						$new->{sysFsMountpoint} = @dat[$n2i->{Mounted}];
					}
					if (defined $n2i->{_1M_blocks}) {
						$new->{sysFsMax} = @dat[$n2i->{_1M_blocks}];
					}
					if (defined $n2i->{Available}) {
						$new->{sysFsFree} = @dat[$n2i->{Available}];
					}
					if (defined $new->{sysFsMax} and defined $new->{sysFsFree}) {
						$new->{sysFsUsed} = $new->{sysFsMax} - $new->{sysFsFree};
					}
					push(@sysFsInfoENTRY, $new);
				}
			}
        }

        if ($obj->{-name} =~ m/\.sysFsInfoENTRY\.([^.]+)\.(\d+)$/) {
            my $col = $1;
            my $row = ($2 > 0 ? $2 - 1 : 0);
            $self->{-ctx}->{-log}->printf(4, "col=%s row=%s", $col, $row);
            $obj->{-value} = @sysFsInfoENTRY[$row]->{$col} if (defined @sysFsInfoENTRY[$row] and defined @sysFsInfoENTRY[$row]->{$col});
        }
    }
    elsif($self->{-ctx}->{-platform}->id() =~ m/SunOS/i) {
    	my @sysFsInfoENTRY  = undef;
        
        #   local workspace
		my $out; my $raw; my $n2i; my @dat; my $new;

        #  	process df
        $out = $self->{-ctx}->{-sys}->run("/bin/df -k", "1m");
        $raw = $out->{-stdout};
		$n2i = {};
		if ($raw =~ m/^([^\n]*\bFilesystem\b[^\n]*)\n(.*)$/s) {
			$n2i = &mkn2i(split / +/, $1);
			foreach $line (split "\n", $2) {
				@dat = split(/ +/, $line);
				if (@dat[$n2i->{Filesystem}] =~ m|^/dev/|) {
					$new = {};
					if (defined $n2i->{Filesystem}) {
						$new->{sysFsDevice} = @dat[$n2i->{Filesystem}];
					}
					if (defined $n2i->{Mounted}) {
						$new->{sysFsMountpoint} = @dat[$n2i->{Mounted}];
					}
					if (defined $n2i->{kbytes}) {
						$new->{sysFsMax} = int(@dat[$n2i->{kbytes}] / 1024);
					}
					if (defined $n2i->{avail}) {
						$new->{sysFsFree} = int(@dat[$n2i->{avail}] / 1024);
					}
					if (defined $new->{sysFsMax} and defined $new->{sysFsFree}) {
						$new->{sysFsUsed} = $new->{sysFsMax} - $new->{sysFsFree};
					}
					push(@sysFsInfoENTRY, $new);
				}
			}
        }

        if ($obj->{-name} =~ m/\.sysFsInfoENTRY\.([^.]+)\.(\d+)$/) {
            my $col = $1;
            my $row = ($2 > 0 ? $2 - 1 : 0);
            $self->{-ctx}->{-log}->printf(4, "col=%s row=%s", $col, $row);
            $obj->{-value} = @sysFsInfoENTRY[$row]->{$col} if (defined @sysFsInfoENTRY[$row] and defined @sysFsInfoENTRY[$row]->{$col});
        }
    }
    return;
}

# name to index
sub mkn2i ($) {
    my (@name) = @_;
    my $rc = {};
    my $i = 0;
    foreach my $f (@name) {
        $f =~ s/[^\w]/_/;
        $f =~ s/^([^a-zA-Z_])/_$1/;
        $rc->{$f} = $i++;
    };
    return $rc;
}

1;

