#!@PATH_PERL@
eval 'exec @PATH_PERL@ -S $0 ${1+"$@"}'
    if $running_under_some_shell;
##
##  gfont_mkgdf -- Make GdF Files
##  Copyright (c) 1996-1997 Ralf S. Engelschall, <rse@engelschall.com>
##
##  Usage: gfont_mkgdf [type:]fontname[-size]
##

require 5.003;
use strict;

use vars qw($gfontpath $fontmap $tmpgdfdir $prg_pktopx $prg_pxtogdf);
use vars qw($origfont $type $font $size $mapline);

$gfontpath   = $ENV{'GFONT_BASE'} || "@libdir@@libsubdir@";
$fontmap     = "$gfontpath/etc/Fontmap";
$prg_pktopx  = "$gfontpath/exec/gfont_pktopx";
$prg_pxtogdf = "$gfontpath/exec/gfont_pxtogdf";
$tmpgdfdir   = $ENV{'GDFPATH'} || "@tmpgdfdir@";

sub system {
    my ($cmd) = @_;

    print "$cmd\n";
    system($cmd);
}

sub mf2gdf {
    my ($origfont, $font, $mag) = @_;
    my ($dpi, $dpiM, $dpiP, $cwd);

    #   determine DPI
    $dpi = int(85 * (1.2 ** $mag));
    $dpiM = $dpi - 1; 
    $dpiP = $dpi + 1;

    #   prepare
    if ($tmpgdfdir !~ m|^/.+|) {
        $cwd = `pwd`;
        $cwd =~ s|\n$||;
        $cwd =~ s|/$||;
        $tmpgdfdir =~ s|^\./||;
        $tmpgdfdir = "$cwd/$tmpgdfdir";
    }
    unlink("$tmpgdfdir/$font.gdf.gz");
    chdir("/tmp");

    #   create PK file via METAFONT and GFtoPK
    print "[Create PK file via METAFONT and GFtoPK]\n";
    &system('mf "\mode:=sun; mag:=magstep(' . $mag . '); scrollmode; input ' . $font . '"');
    unlink("$font.log");
    unlink("$font.tfm");
    $dpi = $dpiM if (-f "$font.${dpiM}gf");
    $dpi = $dpiP if (-f "$font.${dpiP}gf");
    &system("gftopk $font.${dpi}gf $font.${dpi}pk");
    unlink("$font.${dpi}gf");

    #   convert PK to GdF
    print "[Convert PK to GdF]\n";
    $dpi = $dpiM if (-f "./pk/$font.${dpiM}pk");
    $dpi = $dpiP if (-f "./pk/$font.${dpiP}pk");
    unlink("$font.${dpi}px");
    &system("$prg_pktopx $font.${dpi}pk $font.${dpi}px");
    &system("$prg_pxtogdf $font.${dpi}px $font.gdf $font.gdi");
    unlink("$font.${dpi}px");
    unlink("$font.gdi");

    #   create GdF file in final place
    print "[Compress GdF]\n";
    &system("gzip -9 <$font.gdf >$tmpgdfdir/$origfont.gdf.gz");

    #   cleanup
    unlink("$font.gdf");
}

sub ps2gdf {
    my ($origfont, $font, $pt, $mapline) = @_;
    my ($dpi, $dpiM, $dpiP, $cwd);

    #   determine DPI
    $dpi = int((72/12)*$pt);
    $dpiM = $dpi - 1; 
    $dpiP = $dpi + 1;

    #   prepare
    if ($tmpgdfdir !~ m|^/.+|) {
        $cwd = `pwd`;
        $cwd =~ s|\n$||;
        $cwd =~ s|/$||;
        $tmpgdfdir =~ s|^\./||;
        $tmpgdfdir = "$cwd/$tmpgdfdir";
    }
    unlink("$tmpgdfdir/$font.gdf.gz");
    chdir("/tmp");

    #   test whether Postscript commands were defined in Fontmap
    $mapline = "--mapline='$font $mapline'" if $mapline ne '';

    #   create PK file via GSFtoPK (uses Ghostscript in background)
    print "[Create PK file via GSFtoPK/Ghostscript]\n";
    &system("gsftopk $mapline -q $font $dpi");
    $dpi = $dpiM if (-f "$font.${dpiM}gf");
    $dpi = $dpiP if (-f "$font.${dpiP}gf");

    #   convert PK to GdF
    print "[Convert PK to GdF]\n";
    $dpi = $dpiM if (-f "$font.${dpiM}pk");
    $dpi = $dpiP if (-f "$font.${dpiP}pk");
    unlink("$font.${dpi}px");
    &system("$prg_pktopx $font.${dpi}pk $font.${dpi}px");
    &system("$prg_pxtogdf $font.${dpi}px $font.gdf $font.gdi");
    unlink("$font.${dpi}px");
    unlink("$font.gdi");

    #   create GdF file in final place
    print "[Compress GdF]\n";
    &system("gzip -9 <$font.gdf >$tmpgdfdir/$origfont.gdf.gz");

    #   cleanup
    unlink("$font.gdf");
}

if ($#ARGV != 0) {
    print STDERR "Usage: mkgdf fontname[-size]\n";
    exit(1);
}

$origfont = $ARGV[0];

$type = "ps";
$font = $origfont;
$size = 12;
$mapline = "";

if ($font =~ m/^(ps|mf):(.+)$/) {
    $type = $1;
    $font = $2;
}
if ($font =~ m|^(.+)-([0-9.]+)$|) {
    $font = $1;
    $size = $2;
}

open(FP, "<$fontmap");
while (<FP>) {
    next if (m|^\s*#|);
    next if (m|^\s*$|);
    if (m|^(\S+)\s+(.*)\n?$|) {
        my ($in, $out) = ($1, $2);
        if ($font eq $in) {
            $font = $out;
            if ($font =~ m|^(\S+)\s+(\S.*)$|) {
              ($font, $mapline) = ($1, $2);
            }
        }
    }
}
close(FP);

if ($font =~ m/^(ps|mf):(.+)$/) {
    $type = $1;
    $font = $2;
}
if ($font =~ m|^(.+)-([0-9.]+)$|) {
    $font = $1;
    $size = $2;
}

if ($type eq "ps") {
    &ps2gdf($origfont, $font, $size, $mapline);
}
else {
    &mf2gdf($origfont, $font, $size);
}

##EOF##
