//
//  OSSP asgui - Accounting system graphical user interface
//  Copyright (c) 2002-2003 The OSSP Project (http://www.ossp.org/)
//  Copyright (c) 2002-2003 Cable & Wireless Deutschland (http://www.cw.com/de/)
//  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
//  Copyright (c) 2002-2003 Michael Schloh von Bennewitz <michael@schloh.com>
//
//  This file is part of OSSP asgui, an accounting system graphical user
//  interface which can be found at http://www.ossp.org/pkg/tool/asgui/.
//
//  Permission to use, copy, modify, and distribute this software for
//  any purpose with or without fee is hereby granted, provided that
//  the above copyright notice and this permission notice appear in all
//  copies.
//
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
//  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
//  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
//  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
//  SUCH DAMAGE.
//
//  as_uuid.h: ISO C++ interface
//

#ifndef UUIDGEN_H
#define UUIDGEN_H

#include <string>

#ifdef HAVE_CONFIG_H
#include "ac_config.h"
#endif

namespace AS {

#ifdef HAVE_CONFIG_H
#if (SIZEOF_CHAR == 1)
typedef unsigned char        __u8;
#else
?==Error: Undefined 8 bit type
#endif // __u8

#if (SIZEOF_SHORT == 2)
typedef unsigned short       __u16;
#elif (SIZEOF_INT == 2)
typedef unsigned int         __u16;
#elif (SIZEOF_LONG == 2)
typedef unsigned long        __u16;
#else
?==Error: Undefined 16 bit type
#endif // __u16

#if (SIZEOF_SHORT == 4)
typedef unsigned short       __u32;
#elif (SIZEOF_INT == 4)
typedef unsigned int         __u32;
#elif (SIZEOF_LONG == 4)
typedef unsigned long        __u32;
#else
?==Error: Undefined 32 bit type
#endif // __u32

#if (SIZEOF_SHORT == 8)
typedef unsigned short       __u64;
#elif (SIZEOF_INT == 8)
typedef unsigned int         __u64;
#elif (SIZEOF_LONG == 8)
typedef unsigned long        __u64;
#elif (SIZEOF_LONG_LONG == 8)
typedef unsigned long long   __u64;
#else
?==Error: Undefined 64 bit type
#endif // __u64

#else // HAVE_CONFIG_H (not defined)
typedef unsigned char        __u8;
#if (4 == 8)
typedef unsigned int         __u64;
#elif (4 == 8)
typedef unsigned long        __u64;
#elif (8 == 8)
typedef unsigned long long   __u64;
#else
?==Error: Undefined 64 bit type
#endif

#if (4 == 2)
typedef	unsigned int         __u16;
#elif (2 == 2)
typedef	unsigned short       __u16;
#else
?==Error: Undefined 16 bit type
#endif

#if (4 == 4)
typedef	unsigned int         __u32;
#elif (4 == 4)
typedef	unsigned long        __u32;
#elif (2 == 4)
typedef	unsigned short       __u32;
#else
?== Error: Undefined 32 bit type
#endif
#endif // HAVE_CONFIG_H


//
// A DCE standard UUID, can generate (multiple)
// IDs and format them for a printed output
//
class Uuid
{
private:
    std::string m_Fmtstr;               // Human readable format
    __u32   time_low;                   //
    __u16   time_mid;                   // Fields according to
    __u16   time_hi_and_version;        // the IETF specification
    __u16   clock_seq;                  // draft-mealling-uuid-urn-00
    __u8    node[6];                    //

public:
    void genId(void);                   // Generate an UUID
    void setString(void);               // Sets the formatted representation
    std::string getString(void);        // Return a formatted representation

private:
    void setId(const unsigned char *);  // Helper method to set data members
    int setMac(unsigned char *);        // Helper method to set MAC node ID
};
} // namespace AS

#endif // UUIDGEN_H
