//
//  OSSP asgui - Accounting system graphical user interface
//  Copyright (c) 2002-2003 The OSSP Project (http://www.ossp.org/)
//  Copyright (c) 2002-2003 Cable & Wireless Deutschland (http://www.cw.com/de/)
//  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
//  Copyright (c) 2002-2003 Michael Schloh von Bennewitz <michael@schloh.com>
//
//  This file is part of OSSP asgui, an accounting system graphical user
//  interface which can be found at http://www.ossp.org/pkg/tool/asgui/.
//
//  Permission to use, copy, modify, and distribute this software for
//  any purpose with or without fee is hereby granted, provided that
//  the above copyright notice and this permission notice appear in all
//  copies.
//
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
//  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
//  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
//  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
//  SUCH DAMAGE.
//
//  as_panel.h: ISO C++ interface
//

#ifndef PREFPANEL_H
#define PREFPANEL_H

#include <qvariant.h>
#include <qdialog.h>


// Forward class definitions to avoid including qt headers,
// rather include them in the implementation file
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QButtonGroup;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QCheckBox;
class QGroupBox;
class QTabWidget;
class QWidget;

class Prefpanel : public QDialog
{
    Q_OBJECT

public:
    Prefpanel(QWidget *pParent = 0, const char *kszName = 0, bool bModal = true, WFlags Flags = 0);
//    ~Prefpanel(void); // No need to destroy widgets, because qt does it for us

    QGroupBox *m_pGenbox, *m_pRembox;
    QVBoxLayout *m_pStylelay, *m_pSwitchlay;
    QVBoxLayout *m_pVlayout;
    QHBoxLayout *m_pBoolayout, *m_pGenlayout, *m_pRemlayout;
    QHBoxLayout *m_pGenboxlay, *m_pRemboxlay;
    QGridLayout *m_pGeninner, *m_pReminner;

    QWidget *m_pBoolpage, *m_pGeneralpage, *m_pRemotepage;

    QHBoxLayout *m_pButtlay;
    QPushButton *m_pOkaybutton;
    QPushButton *m_pApplybutton;
    QPushButton *m_pCancelbutton;
    QTabWidget *m_pTabselect;

    QLabel *m_pAcctlabel, *m_pEventlabel;
    QLabel *m_pUserlabel, *m_pHomelabel;
    QLabel *m_pCorbalabel, *m_pSoaplabel;
    QLineEdit *m_pAcctline, *m_pEventline;
    QLineEdit *m_pUserline, *m_pHomeline;
    QLineEdit *m_pCorbaline, *m_pSoapline;
    QCheckBox *m_pCorbacheck, *m_pSoapcheck;

    QButtonGroup *m_pStylegroup, *m_pSwitchgroup;
    QCheckBox *m_pBackupcheck, *m_pExtendcheck;

protected slots:
    virtual void textChange(void);
    void apply(void);
};

#endif // PREFPANEL_H
