//
//  OSSP asgui - Accounting system graphical user interface
//  Copyright (c) 2002-2003 The OSSP Project (http://www.ossp.org/)
//  Copyright (c) 2002-2003 Cable & Wireless Deutschland (http://www.cw.com/de/)
//  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
//  Copyright (c) 2002-2003 Michael Schloh von Bennewitz <michael@schloh.com>
//
//  This file is part of OSSP asgui, an accounting system graphical user
//  interface which can be found at http://www.ossp.org/pkg/tool/asgui/.
//
//  Permission to use, copy, modify, and distribute this software for
//  any purpose with or without fee is hereby granted, provided that
//  the above copyright notice and this permission notice appear in all
//  copies.
//
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
//  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
//  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
//  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
//  SUCH DAMAGE.
//
//  titable.cpp: ISO C++ implementation
//

#include <qheader.h>

#include "as_gui.h"


// Implements an event filter for catching header double click events
bool TiTable::eventFilter(QObject *pObject, QEvent *pEvent)
{
    if (pObject == horizontalHeader() && pEvent->type() == QEvent::MouseButtonDblClick)
        return true;
    if (pEvent->type() == QEvent::MouseButtonPress &&   // Ignore mid, right clicks
        ((QMouseEvent *)pEvent)->button() == QMouseEvent::RightButton ||
        ((QMouseEvent *)pEvent)->button() == QMouseEvent::MidButton)
        return true;
    else if (pEvent->type() == QEvent::KeyPress) {
        if (((QKeyEvent *)pEvent)->key() == Qt::Key_Tab) {          // Handle tab key
            if (this->getEdition() >= 0) {
                int nColadvance = ((currentColumn() + 1) % TITRAQ_IDXTAIL);
                if (nColadvance == 0)   // Advance the column and possibly the row too
                    this->setCurrentCell(currentRow() + 1, nColadvance);
                else
                    this->setCurrentCell(currentRow(), nColadvance);
                this->setReadOnly(false);
                this->editCell(currentRow(), currentColumn());
                this->setEdition(currentColumn());
                this->setReadOnly(true);
            }
            return true;    // Handled the tab key event and cancel its progress
        }
        else if (((QKeyEvent *)pEvent)->key() == Qt::Key_Escape)    // Handle escape key
            this->setEdition();

        // Forward incompletely handled key events
        return QTable::eventFilter(pObject, pEvent);
    }
    else                    // Default behaviour is to pass the event onwards
        return QTable::eventFilter(pObject, pEvent);
}

// Overridden member hack to allow externally connected control
// widgets to influence dirty or clean state of table data
void TiTable::setText(int nRow, int nCol, const QString &nText)
{
    if (this->numRows() > 0) {
        // If a cell was edited, emit a signal indicating so
        // We can't rely on valueChanged for unknown reasons
        if (nText != this->text(nRow, nCol))
            emit textEdited();

        QTable::setText(nRow, nCol, nText);
    }
}
