//
//  OSSP asgui - Accounting system graphical user interface
//  Copyright (c) 2002-2003 The OSSP Project (http://www.ossp.org/)
//  Copyright (c) 2002-2003 Cable & Wireless Deutschland (http://www.cw.com/de/)
//  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
//  Copyright (c) 2002-2003 Michael Schloh von Bennewitz <michael@schloh.com>
//
//  This file is part of OSSP asgui, an accounting system graphical user
//  interface which can be found at http://www.ossp.org/pkg/tool/asgui/.
//
//  Permission to use, copy, modify, and distribute this software for
//  any purpose with or without fee is hereby granted, provided that
//  the above copyright notice and this permission notice appear in all
//  copies.
//
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
//  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
//  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
//  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
//  SUCH DAMAGE.
//
//  titconst.h: ISO C++ interface
//

#ifndef TITCONST_H
#define TITCONST_H


// Preferences string constants
#define TITRAQ_PREFNAME         "as_gui.conf"
#define TITRAQ_APPTITLE         "AS Gui"
#define TITRAQ_PREFVER          "0.5"
#define TITRAQ_PREFUSER         "user"
#define TITRAQ_DEFUSER          "username"
#define TITRAQ_PREFASFILE       "asfile"
#define TITRAQ_DEFASFILE        "/e/dev/as"
#define TITRAQ_PREFSTYLE        "uistyle"
#define TITRAQ_PREFVIEW         "view"
#define TITRAQ_DEFVIEW          "normal"
#define TITRAQ_PREFREMOTELOG    "logremote"
#define TITRAQ_DEFREMOTELOG     "no"
#define TITRAQ_PREFLOCALLOG     "loglocal"
#define TITRAQ_DEFLOCALLOG      "no"
#define TITRAQ_SAVEFIRST        "The timesheet contains unsaved changes\nDo you want to save the changes or discard them?"

// Other string constants
#define TITRAQ_DATEZERO         "0000-00-00"
#define TITRAQ_SEPARATORTOK     " "

// Indexes of table columns
#define TITRAQ_IDXALLCTRLS     -1
#define TITRAQ_IDXDATE          0
#define TITRAQ_IDXSTART         1
#define TITRAQ_IDXFINISH        2
#define TITRAQ_IDXAMOUNT        3
#define TITRAQ_IDXTASK          4
#define TITRAQ_IDXREMARK        5
#define TITRAQ_IDXEND           6

// Indexes of popup menu submenus
#define TITRAQ_IDXFILEBAR       1
#define TITRAQ_IDXEDITBAR       2
#define TITRAQ_IDXWHATBAR       3

// Values
#define TITRAQ_MAINWINWIDTH     640         // Default main window width
#define TITRAQ_MAINWINHEIGHT    480         // Default main window height
#define TITRAQ_MARGIN           10          // Default layout margin
#define TITRAQ_SPACING          6           // Default layout spacing
#define TITRAQ_MAXAMOUNT        960         // Maximum valid amount
#define TITRAQ_MINAMOUNT        0           // Minimum valid amount
#define TITRAQ_STEPAMOUNT       15          // Line step interval
#define TITRAQ_MINSINHOUR       60          // Only idiots don't know this
#define TITRAQ_YES              1           // To signal yes in general
#define TITRAQ_NO               0           // To signal no in general
#define TITRAQ_CANCEL           -1          // To not signal anything

#endif // TITCONST_H
