untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46GBOYAqUPJbtWA+QlR39t417kYQ/iN3XP44N7j6o1aaGDiLPnwhy+B0yP0jYwX3/E6JJqPcugNs7GOwwiMzMmQo=

OpenBSD 6.9 errata 017, September 27, 2021:

A stack overread could occur when checking X.509 name constraints.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 017_x509.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto and unwind:
    cd /usr/src/lib/libcrypto
    make obj
    make includes
    make
    make install
    cd /usr/src/sbin/unwind
    make obj
    make
    make install

Index: lib/libcrypto/x509/x509_constraints.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/x509/x509_constraints.c,v
diff -u -p -r1.15 x509_constraints.c
--- lib/libcrypto/x509/x509_constraints.c	12 Mar 2021 15:57:30 -0000	1.15
+++ lib/libcrypto/x509/x509_constraints.c	23 Sep 2021 17:00:30 -0000
@@ -334,16 +334,16 @@ x509_constraints_parse_mailbox(uint8_t *
 			if (c == '.')
 				goto bad;
 		}
-		if (wi > DOMAIN_PART_MAX_LEN)
-			goto bad;
 		if (accept) {
+			if (wi >= DOMAIN_PART_MAX_LEN)
+				goto bad;
 			working[wi++] = c;
 			accept = 0;
 			continue;
 		}
 		if (candidate_local != NULL) {
 			/* We are looking for the domain part */
-			if (wi > DOMAIN_PART_MAX_LEN)
+			if (wi >= DOMAIN_PART_MAX_LEN)
 				goto bad;
 			working[wi++] = c;
 			if (i == len - 1) {
@@ -358,7 +358,7 @@ x509_constraints_parse_mailbox(uint8_t *
 			continue;
 		}
 		/* We are looking for the local part */
-		if (wi > LOCAL_PART_MAX_LEN)
+		if (wi >= LOCAL_PART_MAX_LEN)
 			break;
 
 		if (quoted) {
@@ -378,6 +378,8 @@ x509_constraints_parse_mailbox(uint8_t *
 			 */
 			if (c == 9)
 				goto bad;
+			if (wi >= LOCAL_PART_MAX_LEN)
+				goto bad;
 			working[wi++] = c;
 			continue; /* all's good inside our quoted string */
 		}
@@ -406,6 +408,8 @@ x509_constraints_parse_mailbox(uint8_t *
 			accept = 1;
 		}
 		if (!local_part_ok(c))
+			goto bad;
+		if (wi >= LOCAL_PART_MAX_LEN)
 			goto bad;
 		working[wi++] = c;
 	}
