untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46IcwnrRxR3UMCxD2bASJq5VA7LsEwy7vRXDOL2T4BBjX8GVbqXVKzJkAeu0WJy0KkhrLgZj7uKR1lbCizLy7bAM=

OpenBSD 6.9 errata 015, August 20, 2021:

Printing a certificate can result in a crash in X509_CERT_AUX_print().

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 015_x509.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto and unwind:
    cd /usr/src/lib/libcrypto
    make obj
    make includes
    make
    make install
    cd /usr/src/sbin/unwind
    make obj
    make
    make install

Index: lib/libcrypto/asn1/t_x509a.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/asn1/t_x509a.c,v
retrieving revision 1.8
diff -u -p -r1.8 t_x509a.c
--- lib/libcrypto/asn1/t_x509a.c	11 Jul 2014 08:44:47 -0000	1.8
+++ lib/libcrypto/asn1/t_x509a.c	17 Aug 2021 16:31:29 -0000
@@ -105,8 +105,8 @@ X509_CERT_AUX_print(BIO *out, X509_CERT_
 	} else
 		BIO_printf(out, "%*sNo Rejected Uses.\n", indent, "");
 	if (aux->alias)
-		BIO_printf(out, "%*sAlias: %s\n", indent, "",
-		    aux->alias->data);
+		BIO_printf(out, "%*sAlias: %.*s\n", indent, "",
+		    aux->alias->length, aux->alias->data);
 	if (aux->keyid) {
 		BIO_printf(out, "%*sKey Id: ", indent, "");
 		for (i = 0; i < aux->keyid->length; i++)
