/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv.opencsv;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class CSVWriter
implements Closeable,
Flushable {
    public static final int INITIAL_STRING_SIZE = 1024;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    public static final String RFC4180_LINE_END = "\r\n";
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\"', lineEnd);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeAll(List<String[]> allLines, boolean applyQuotesToAll) {
        for (String[] line : allLines) {
            this.writeNext(line, applyQuotesToAll);
        }
    }

    public void writeAll(List<String[]> allLines) {
        for (String[] line : allLines) {
            this.writeNext(line);
        }
    }

    public void writeNext(String[] nextLine, boolean applyQuotesToAll) {
        if (nextLine == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(nextLine.length * 2);
        for (int i = 0; i < nextLine.length; ++i) {
            String nextElement;
            if (i != 0) {
                sb.append(this.separator);
            }
            if ((nextElement = nextLine[i]) == null) continue;
            Boolean stringContainsSpecialCharacters = this.stringContainsSpecialCharacters(nextElement);
            if ((applyQuotesToAll || stringContainsSpecialCharacters.booleanValue()) && this.quotechar != '\u0000') {
                sb.append(this.quotechar);
            }
            if (stringContainsSpecialCharacters.booleanValue()) {
                sb.append((CharSequence)this.processLine(nextElement));
            } else {
                sb.append(nextElement);
            }
            if (!applyQuotesToAll && !stringContainsSpecialCharacters.booleanValue() || this.quotechar == '\u0000') continue;
            sb.append(this.quotechar);
        }
        sb.append(this.lineEnd);
        this.pw.write(sb.toString());
    }

    public void writeNext(String[] nextLine) {
        this.writeNext(nextLine, true);
    }

    protected boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(this.quotechar) != -1 || line.indexOf(this.escapechar) != -1 || line.indexOf(this.separator) != -1 || line.contains(DEFAULT_LINE_END) || line.contains("\r");
    }

    protected StringBuilder processLine(String nextElement) {
        StringBuilder sb = new StringBuilder(nextElement.length() * 2);
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            this.processCharacter(sb, nextChar);
        }
        return sb;
    }

    private void processCharacter(StringBuilder sb, char nextChar) {
        if (this.escapechar != '\u0000' && this.checkCharactersToEscape(nextChar)) {
            sb.append(this.escapechar).append(nextChar);
        } else {
            sb.append(nextChar);
        }
    }

    private boolean checkCharactersToEscape(char nextChar) {
        return this.quotechar == '\u0000' ? nextChar == this.quotechar || nextChar == this.escapechar || nextChar == this.separator : nextChar == this.quotechar || nextChar == this.escapechar;
    }

    @Override
    public void flush() throws IOException {
        this.pw.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.pw.close();
        this.rawWriter.close();
    }

    public boolean checkError() {
        return this.pw.checkError();
    }

    public void flushQuietly() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

