/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.http;

import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.http.HTTPData;
import org.pentaho.di.trans.steps.http.HTTPMeta;
import org.pentaho.di.trans.steps.http.Messages;

public class HTTP
extends BaseStep
implements StepInterface {
    private HTTPMeta meta;
    private HTTPData data;

    public HTTP(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] execHttp(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.argnrs = new int[this.meta.getArgumentField().length];
            for (int i = 0; i < this.meta.getArgumentField().length; ++i) {
                this.data.argnrs[i] = rowMeta.indexOfValue(this.meta.getArgumentField()[i]);
                if (this.data.argnrs[i] >= 0) continue;
                this.logError(Messages.getString("HTTP.Log.ErrorFindingField") + this.meta.getArgumentField()[i] + "]");
                throw new KettleStepException(Messages.getString("HTTP.Exception.CouldnotFindField", this.meta.getArgumentField()[i]));
            }
        }
        return this.callHttpService(rowMeta, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] callHttpService(RowMetaInterface rowMeta, Object[] rowData) throws KettleException {
        String url = this.determineUrl(rowMeta, rowData);
        try {
            Object[] objectArray;
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("HTTP.Log.Connecting", url));
            }
            HttpClient httpclient = new HttpClient();
            GetMethod method = new GetMethod(this.environmentSubstitute(url));
            try {
                int c;
                int result = httpclient.executeMethod((HttpMethod)method);
                if (this.log.isDebug()) {
                    this.log.logDebug(this.toString(), Messages.getString("HTTP.Log.ResponseStatusCode", "" + result), new Object[0]);
                }
                InputStream inputStream = method.getResponseBodyAsStream();
                StringBuffer bodyBuffer = new StringBuffer();
                while ((c = inputStream.read()) != -1) {
                    bodyBuffer.append((char)c);
                }
                inputStream.close();
                String body = bodyBuffer.toString();
                if (this.log.isDebug()) {
                    this.log.logDebug(this.toString(), "Response body: " + body, new Object[0]);
                }
                objectArray = RowDataUtil.addValueData((Object[])rowData, (int)rowMeta.size(), (Object)body);
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                method.releaseConnection();
                throw throwable;
            }
            method.releaseConnection();
            return objectArray;
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("HTTP.Log.UnableGetResult", url), (Throwable)e);
        }
    }

    private String determineUrl(RowMetaInterface outputRowMeta, Object[] row) throws KettleValueException, KettleException {
        try {
            if (this.meta.isUrlInField()) {
                this.data.realUrl = outputRowMeta.getString(row, this.data.indexOfUrlField);
            }
            StringBuffer url = new StringBuffer(this.data.realUrl);
            for (int i = 0; i < this.data.argnrs.length; ++i) {
                if (i == 0 && url.indexOf("?") < 0) {
                    url.append('?');
                } else {
                    url.append('&');
                }
                url.append(URIUtil.encodeWithinQuery((String)this.meta.getArgumentParameter()[i]));
                url.append('=');
                String s = outputRowMeta.getString(row, this.data.argnrs[i]);
                if (s != null) {
                    s = URIUtil.encodeWithinQuery((String)s);
                }
                url.append(s);
            }
            return url.toString();
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("HTTP.Log.UnableCreateUrl"), (Throwable)e);
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block11: {
            this.meta = (HTTPMeta)smi;
            this.data = (HTTPData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                if (this.meta.isUrlInField()) {
                    if (Const.isEmpty((String)this.meta.getUrlField())) {
                        this.logError(Messages.getString("HTTP.Log.NoField"));
                        throw new KettleException(Messages.getString("HTTP.Log.NoField"));
                    }
                    if (this.data.indexOfUrlField < 0) {
                        String realUrlfieldName = this.environmentSubstitute(this.meta.getUrlField());
                        this.data.indexOfUrlField = this.getInputRowMeta().indexOfValue(realUrlfieldName);
                        if (this.data.indexOfUrlField < 0) {
                            this.logError(Messages.getString("HTTP.Log.ErrorFindingField", realUrlfieldName));
                            throw new KettleException(Messages.getString("HTTP.Exception.ErrorFindingField", realUrlfieldName));
                        }
                    }
                } else {
                    this.data.realUrl = this.environmentSubstitute(this.meta.getUrl());
                }
            }
            try {
                Object[] outputRowData = this.execHttp(this.getInputRowMeta(), r);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("HTTP.LineNumber") + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("HTTP.ErrorInStepRunning") + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block11;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "HTTP001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPMeta)smi;
        this.data = (HTTPData)sdi;
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (HTTPMeta)smi;
        this.data = (HTTPData)sdi;
        super.dispose(smi, sdi);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

