/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import java.util.Iterator;
import java.util.List;

public class VMUtil {
    private static List s_connectors = Bootstrap.virtualMachineManager().allConnectors();

    private VMUtil() {
    }

    public static final Connector getConnector(String name) {
        Iterator iter = s_connectors.iterator();
        while (iter.hasNext()) {
            Connector connector = (Connector)iter.next();
            if (!connector.name().equals(name)) continue;
            return connector;
        }
        return null;
    }

    public static void shutdown(VirtualMachine vm) {
        Process process = null;
        if (vm != null) {
            try {
                process = vm.process();
                vm.dispose();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        if (process != null) {
            process.destroy();
        }
    }
}

