%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/displaying-grob-ancestry.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: a8a85e19654e46d725563e6deba44083ef137a2c
  texidocja = "
Grob のコールバックを使用する際、Grob の親子関係を理解すると役立つ場合が@c
あります。多くの Grob は親を持ち、Grob が表示される位置の基準点となります。@c
X 軸方向の親 (X-parent) と Y 軸方向の親 (Y-parent) はそれぞれ@c
横方向と縦方向の位置の基準となります。@c
同様に、親の Grob にもそれぞれの親が存在します。


残念ながら、Grob の親子関係を分かりにくくしていることがいくつかあります:

* Grob が持つ親の種類はコンテキストに依存する場合があります。

* いくつかの Grob では、X 軸方向の親と Y 軸方向の親が同じです。

* Grob の親が位置の基準以外の役割を果たす場合があります。

* \"世代\" として考えるのは誤解を生みます。

例えば、@code{System} Grob は @code{VerticalAlignment} の
(Y 軸方向の) 親にも、(X 軸方向の両方の) 祖父母にもなっています。


このマクロは、Grob の親子関係を (コンソールに) 分かりやすく表示します。

このように呼び出します:

@code{@{ \\once \\override NoteHead.before-line-breaking =
#display-ancestry c @}}

以下のような出力を得ます:


@code{NoteHead X,Y: NoteColumn
     X: PaperColumn
        X,Y: System
     Y: VerticalAxisGroup
        X: NonMusicalPaperColumn
           X,Y: System
        Y: VerticalAlignment
           X: NonMusicalPaperColumn
              X,Y: System
           Y: System}

"
  doctitleja = "Grob の親子関係を表示する"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Lorsque l'on manipule des rappels d'objet (@emph{grob callbacks}), il
peut être intéressant d'en maîtriser les ascendants. La plupart des
objets graphiques ont des parents, lesquels auront une influence sur le
positionnement de l'objet en question. Ainsi, les parents des côtés X et
Y influenceront respectivement les positions horizontale et verticale de
l'objet. De plus, chacun des parents peut avoir ses propres parents.

Certains aspects de la lignée d'un objet peuvent toutefois porter à
confusion :

@itemize
@item
Les types de parents d'un @emph{grob} peuvent dépendre du contexte.
@item
Dans le cas de certains @emph{grobs}, les parents X et Y peuvent être
le même.
@item
Un « ascendant » particulier peut dépendre d'un @emph{grob} de
différentes manières.
@item
Le concept de « générations » est trompeur.
@end itemize

Par exemple, l'objet @code{System} peut, vis à vis d'un objet
@code{VerticalAlignment}, être à la fois parent (par son côté Y) et
grand parent (par deux fois du côté X).

La macro ci-dessous affiche à l'écran une représentation textuelle de
l'ascendance d'un @emph{grob}.

Elle se lance ainsi :

@verbatim
{ \\once \\override NoteHead.before-line-breaking = #display-ancestry c }
@end verbatim

@noindent
et génère la sortie suivante :

@verbatim
NoteHead
X,Y: NoteColumn
     X: PaperColumn
        X,Y: System
     Y: VerticalAxisGroup
        X: NonMusicalPaperColumn
           X,Y: System
        Y: VerticalAlignment
           X: NonMusicalPaperColumn
              X,Y: System
           Y: System
@end verbatim
"

  doctitlefr = "Affichage de la généalogie d'un objet"

%% Translation of GIT committish: 66944d2d921889a3c45ef0db23171a9f48a46825
  texidoces = "
Al trabajar con los callbacks de un grob, puede ser de mucha ayuda
entender el árbol genealógico de un grob.  La mayor parte de los
grobs tienen padres que influyen en el posicionamiento del grob.
los padres X e Y influyen en las posiciones horizontal y vertical del
grob, respectivamente.  Además, cada pade puede tener padres a su vez.


Por desgracia, existen varios aspectos de la genealogía de un grob que
pueden llevar a confusión:


* Los tipos de padre que tiene un grob pueden depender del
contexto.

* Para ciertos grobs, los padres X e Y son el mismo.

* Un \"ancestro\" concreto puede estar relacionado con un grob de
más de una manera.

* El concepto de \"generaciones\" es engañoso.


Por ejemplo, el grob @code{System} puede ser tanto un padre (sobre el
lado Y) como un abuelo (dos veces en el lado X) de un grob
@code{VerticalAlignment}.


Este macro imprime, en la consola, una representación textual de la
genealogía de un grob.


Cuando se llama de esta forma:

@code{@{ \\once \\override NoteHead.before-line-breaking =
#display-ancestry c @}}

Se genera la siguiente salida:


@code{NoteHead X,Y: NoteColumn
     X: PaperColumn
        X,Y: System
     Y: VerticalAxisGroup
        X: NonMusicalPaperColumn
           X,Y: System
        Y: VerticalAlignment
           X: NonMusicalPaperColumn
              X,Y: System
           Y: System}

"
  doctitlees = "Imprimir el árbol genealógico de un grob"

%% Translation of GIT committish: 66944d2d921889a3c45ef0db23171a9f48a46825
  texidocca = "
En treballar amb les crides d'un grob, pot ser de molta utilitat
entendre  l'arbre genealògic d'un grob.  La major part dels grobs
tenen pares que influeixen en el posicionament del grob.  Els
pares X i Y influeixen en les posisions horitzontal i vertical del
grob, respectivament.  A més, cada pare pot tenir al seu cop pares.

Desafortunadament, hi ha diversos aspectes de la geneaologia d'un
grob que pot portar a confusió:

* Els tipus de pare que té un grob poden dependre del context.

* Per a certs grobs, els pares X i Y són el mateix.

* Un \"ancestre\" concret pot estar relacionat amb un grob de més
d'una manera.

* El concepte de \"generacions\" és enganyós.


Por exemple, el grob @code{System} pot ser tant un pare (sobre la
vorfa Y) com un avi (dues vegades a la vora X) d'un grob
@code{VerticalAlignment}.


Aquest macro imprimeix, en la consola, una representació textual
de la genealogia d'un grob.

Quan es crida d'aquesta forma:

@code{@{ \\once \\override NoteHead.before-line-breaking =
#display-ancestry c @}}

Es general la sortida següent:


@code{NoteHead X,Y: NoteColumn
     X: PaperColumn
        X,Y: System
     Y: VerticalAxisGroup
        X: NonMusicalPaperColumn
           X,Y: System
        Y: VerticalAlignment
           X: NonMusicalPaperColumn
              X,Y: System
           Y: System}

"
  doctitleca = "Imprimir l'arbre genealògic d'un grob"

  lsrtags = "devel, scheme-language, tweaks-and-overrides"

  texidoc = "
When working with grob callbacks, it can be helpful to understand a
grob's ancestry.  Most grobs have parents which influence the
positioning of the grob.  X- and Y-parents influence the horizontal and
vertical positions for the grob, respectively.  Additionally, each
parent may have parents of its own.

Unfortunately, there are several aspects of a grob's ancestry that can
lead to confusion:

@itemize
@item
The types of parents a grob has may depend on context.
@item
For some grobs, the X- and Y-parents are the same.
@item
A particular @emph{ancestor} may be related to a grob in multiple ways.
@item
The concept of @emph{generations} is misleading.
@end itemize

For example, the @code{System} grob can be both parent (on the Y-side)
and grandparent (twice on the X-side) to a @code{VerticalAlignment}
grob.

This macro prints (to the console) a textual representation of a grob's
ancestry.

When called this way:

@verbatim
{ \\once \\override NoteHead.before-line-breaking = #display-ancestry c }
@end verbatim

The following output is generated:

@verbatim
NoteHead
X,Y: NoteColumn
     X: PaperColumn
        X,Y: System
     Y: VerticalAxisGroup
        X: NonMusicalPaperColumn
           X,Y: System
        Y: VerticalAlignment
           X: NonMusicalPaperColumn
              X,Y: System
           Y: System
@end verbatim
"

  doctitle = "Displaying grob ancestry"
} % begin verbatim


%% http://lsr.di.unimi.it/LSR/Item?id=622
%% see also http://www.lilypond.org/doc/v2.18/Documentation/snippets/tweaks-and-overrides#tweaks-and-overrides-displaying-grob-ancestry

%% Remark:
%% grob::name is in the source since 2.19.x could be deleted during next LSR-upgrade
#(define (grob::name grob)
  (assq-ref (ly:grob-property grob 'meta) 'name))

#(define (get-ancestry grob)
  (if (not (null? (ly:grob-parent grob X)))
      (list (grob::name grob)
            (get-ancestry (ly:grob-parent grob X))
            (get-ancestry (ly:grob-parent grob Y)))
      (grob::name grob)))

#(define (format-ancestry lst padding)
   (string-append
    (symbol->string (car lst))
    "\n"
    (let ((X-ancestry
           (if (list? (cadr lst))
               (format-ancestry (cadr lst) (+ padding 3))
               (symbol->string (cadr lst))))
          (Y-ancestry
           (if (list? (caddr lst))
               (format-ancestry (caddr lst) (+ padding 3))
               (symbol->string (caddr lst)))))
      (if (equal? X-ancestry Y-ancestry)
          (string-append
           (format #f "~&")
           (make-string padding #\space)
           "X,Y: "
           (if (list? (cadr lst))
               (format-ancestry (cadr lst) (+ padding 5))
               (symbol->string (cadr lst))))
          (string-append
           (format #f "~&")
           (make-string padding #\space)
           "X: " X-ancestry
           "\n"
           (make-string padding #\space)
           "Y: " Y-ancestry
           (format #f "~&"))))
    (format #f "~&")))

#(define (display-ancestry grob)
   (format (current-error-port)
      "~3&~a~2%~a~&"
      (make-string 36 #\-)
      (if (ly:grob? grob)
          (format-ancestry (get-ancestry grob) 0)
          (format #f "~a is not a grob" grob))))

\relative c' {
  \once \override NoteHead.before-line-breaking = #display-ancestry
  f4
  \once \override Accidental.before-line-breaking = #display-ancestry
  \once \override Arpeggio.before-line-breaking = #display-ancestry
  <f as c>4\arpeggio
}



% ****************************************************************
% end ly snippet
% ****************************************************************
