%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/consistently-left-aligned-bar-numbers.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: a8a85e19654e46d725563e6deba44083ef137a2c
  texidocja = "
小節番号が左揃えされている場合、譜のブラケットと重なってしまうかもしれません。@c
このスニペットは、改行後の小節番号のみ右揃えのままにすることでそれを@c
解決しています。
"
  doctitleja = "小節番号を衝突を避けながら左揃えする"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
L'alignement des numéros de mesure par la gauche peut générer des
problèmes de chevauchement, notamment avec les crochets de regroupement
de portées.

L'exemple ci-dessous offre une solution en alignant par la droite le
numéro de la mesure suivant un saut de ligne.
"

  doctitlefr = "Adaptation de l'alignement des numéros de mesure"

%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidoces = "
Cuando se alinean los números de compás, pueden aparecer problemas de
superposición con los corchetes de sistema.  Este fragmento de código
lo resuelve dejando alineados a la derecha los números de compás
después de un salto de línea.

"
  doctitlees = "Números de compás alineados a la izquierda de forma consistente"

%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidocca = "
Quan s'alinien els números de compàs, poden aparèixer problemes de
superposició amb les claus de sistema.  Aquest fragment de codi ho
resoleu deixant alineats a la dreta els números de compàs després
d'un salt de línia.

"
  doctitleca = "Números de compàs alineats a l'esquerra de forma consistent"


  lsrtags = "rhythms"

  texidoc = "
When left aligning bar numbers, overlapping problems may occur with
Staves brackets.

The snippet solves this by keeping right aligned the first bar number
following line breaks.
"

  doctitle = "Consistently left aligned bar numbers"
} % begin verbatim


consistentlyLeftAlignedBarNumbers = {
  \override Score.BarNumber.break-visibility = #end-of-line-invisible
  \override Score.BarNumber.self-alignment-X =
    #(lambda (grob)
       (let ((break-dir (ly:item-break-dir grob)))
         (if (= break-dir RIGHT) RIGHT LEFT)))
}

\new ChoirStaff <<
  \new Staff {
    \relative c' {
      \set Score.barNumberVisibility = #(every-nth-bar-number-visible 3)
      \bar ""
      \consistentlyLeftAlignedBarNumbers

      \set Score.currentBarNumber = #112
      \repeat unfold 8 { R1 }
      \break
      \repeat unfold 9 { R1 }
      \break
      \repeat unfold 7 { R1 }
    }
  }
  \new Staff {
    \relative c' {
      \repeat unfold 24 { R1 }
    }
  }
>>

\layout {
  indent = #0
  ragged-right = ##t
  ragged-last = ##t
}



% ****************************************************************
% end ly snippet
% ****************************************************************
