/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.Column;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Table;
import net.sf.mpxj.common.MPPResourceField14;
import net.sf.mpxj.common.MPPTaskField14;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

final class TableFactory14 {
    private Integer m_tableColumnDataStandard;
    private Integer m_tableColumnDataEnterprise;
    private Integer m_tableColumnDataBaseline;

    public TableFactory14(Integer n, Integer n2, Integer n3) {
        this.m_tableColumnDataStandard = n;
        this.m_tableColumnDataEnterprise = n2;
        this.m_tableColumnDataBaseline = n3;
    }

    public Table createTable(ProjectFile projectFile, byte[] byArray, VarMeta varMeta, Var2Data var2Data) {
        Table table = new Table();
        table.setID(MPPUtility.getInt(byArray, 0));
        table.setResourceFlag(MPPUtility.getShort(byArray, 108) == 1);
        table.setName(MPPUtility.removeAmpersands(MPPUtility.getUnicodeString(byArray, 4)));
        byte[] byArray2 = null;
        Integer n = table.getID();
        if (this.m_tableColumnDataBaseline != null) {
            byArray2 = var2Data.getByteArray(varMeta.getOffset(n, this.m_tableColumnDataBaseline));
        }
        if (byArray2 == null && (byArray2 = var2Data.getByteArray(varMeta.getOffset(n, this.m_tableColumnDataEnterprise))) == null) {
            byArray2 = var2Data.getByteArray(varMeta.getOffset(n, this.m_tableColumnDataStandard));
        }
        this.processColumnData(projectFile, table, byArray2);
        return table;
    }

    private void processColumnData(ProjectFile projectFile, Table table, byte[] byArray) {
        if (byArray != null) {
            int n = MPPUtility.getShort(byArray, 4) + 1;
            int n2 = 12;
            for (int i = 0; i < n; ++i) {
                int n3;
                Column column = new Column(projectFile);
                int n4 = MPPUtility.getShort(byArray, n2);
                if (!table.getResourceFlag()) {
                    column.setFieldType(MPPTaskField14.getInstance(n4));
                } else {
                    column.setFieldType(MPPResourceField14.getInstance(n4));
                }
                column.setWidth(MPPUtility.getByte(byArray, n2 + 4));
                String string = MPPUtility.getUnicodeString(byArray, n2 + 13);
                if (string.length() != 0) {
                    column.setTitle(string);
                }
                if (((n3 = MPPUtility.getByte(byArray, n2 + 5)) & 0xF) == 0) {
                    column.setAlignTitle(1);
                } else if ((n3 & 0xF) == 1) {
                    column.setAlignTitle(2);
                } else {
                    column.setAlignTitle(3);
                }
                n3 = MPPUtility.getByte(byArray, n2 + 7);
                if ((n3 & 0xF) == 0) {
                    column.setAlignData(1);
                } else if ((n3 & 0xF) == 1) {
                    column.setAlignData(2);
                } else {
                    column.setAlignData(3);
                }
                table.addColumn(column);
                n2 += 115;
            }
        }
    }
}

