/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.reports.view;

import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.configuration.NamedItem;
import com.projectlibre1.configuration.ReportDefinition;
import com.projectlibre1.configuration.ScriptConfiguration;
import com.projectlibre1.contrib.ClassResolverFilter;
import com.projectlibre1.field.Field;
import com.projectlibre1.graphic.configuration.SpreadSheetFieldArray;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.help.HelpUtil;
import com.projectlibre1.pm.graphic.frames.DocumentFrame;
import com.projectlibre1.pm.graphic.frames.GraphicManager;
import com.projectlibre1.pm.graphic.model.cache.GeneralFilteredIterator;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projectlibre1.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projectlibre1.pm.graphic.model.event.CacheListener;
import com.projectlibre1.pm.graphic.model.event.CompositeCacheEvent;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheet;
import com.projectlibre1.pm.graphic.timescale.CoordinatesConverter;
import com.projectlibre1.pm.graphic.views.BaseView;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.reports.adapter.DataSource;
import com.projectlibre1.reports.adapter.DataSourceProvider;
import com.projectlibre1.reports.adapter.ReportUtil;
import com.projectlibre1.reports.adapter.ReportViewer;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.undo.UndoController;
import com.projectlibre1.util.Environment;
import com.projectlibre1.workspace.WorkspaceSetting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class ReportView
extends JPanel
implements BaseView,
CacheListener {
    private static final long serialVersionUID = 5457040745964404658L;
    protected JPanel report;
    protected Project project;
    private ReportViewer viewer = null;
    private DocumentFrame documentFrame;
    private boolean xmlFile = true;
    private ReportDefinition reportDefinition = null;
    JLabel reportLabel;
    JComboBox reportChoice;
    JLabel columnsLabel;
    JComboBox columnsChoice;
    CoordinatesConverter coord;
    SpreadSheetFieldArray fieldArray = null;
    BorderLayout layout = new BorderLayout();
    NodeModelCache cache;
    private boolean initializing;
    boolean dirty = true;
    NodeModelCache taskCache = null;
    NodeModelCache resourceCache = null;
    private String viewName = DataSourceProvider.TASK_REPORT_VIEW;
    private Closure transformerClosure;

    public ReportView(DocumentFrame documentFrame) {
        this.documentFrame = documentFrame;
        this.project = documentFrame.getProject();
        HelpUtil.addDocHelp(this, "Report_View");
        if (!Environment.getStandAlone()) {
            try {
                Class.forName("bsh.BshClassManager").getMethod("setClassResolverFilter", ClassResolverFilter.class).invoke(null, ScriptConfiguration.getInstance());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.transformerClosure = documentFrame.addTransformerInitializationClosure();
    }

    @Override
    public void cleanUp() {
        if (this.cache != null) {
            this.cache.removeNodeModelListener(this);
        }
        this.report = null;
        this.project = null;
        this.viewer = null;
        this.documentFrame = null;
        this.reportDefinition = null;
        this.reportLabel = null;
        this.reportChoice = null;
        this.columnsLabel = null;
        this.columnsChoice = null;
        this.coord = null;
        this.fieldArray = null;
        this.layout = null;
        this.cache = null;
        this.taskCache = null;
        this.resourceCache = null;
        this.viewName = null;
    }

    private NodeModelCache newFilteredCache(ReferenceNodeModelCache referenceNodeModelCache, String string) {
        NodeModelCache nodeModelCache = NodeModelCacheFactory.getInstance().createFilteredCache(referenceNodeModelCache, string, this.transformerClosure);
        nodeModelCache.update();
        return nodeModelCache;
    }

    private NodeModel updateCacheForView(String string) {
        if (string.equals(DataSourceProvider.TASK_REPORT_VIEW)) {
            if (this.taskCache == null) {
                this.taskCache = this.newFilteredCache(this.documentFrame.getTaskNodeModelCache(), string);
            }
            this.cache = this.taskCache;
        } else if (string.equals(DataSourceProvider.RESOURCE_REPORT_VIEW)) {
            if (this.resourceCache == null) {
                this.resourceCache = this.newFilteredCache(this.documentFrame.getResourceNodeModelCache(), string);
            }
            this.cache = this.resourceCache;
        } else if (string.equals(DataSourceProvider.PROJECT_REPORT_VIEW)) {
            this.cache = null;
            return GraphicManager.getInstance(this).getProjectFactory().getPortfolio().getNodeModel();
        }
        return this.cache.getModel();
    }

    private void showReport() {
        this.documentFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.makeViewer();
        }
        catch (JRException jRException) {
            System.out.println(jRException.getMessage());
            jRException.printStackTrace();
        }
        this.documentFrame.setCursor(Cursor.getDefaultCursor());
    }

    private void makeViewer() throws JRException {
        GeneralFilteredIterator generalFilteredIterator;
        Cloneable cloneable;
        if (!this.dirty) {
            return;
        }
        this.documentFrame.showWaitCursor(true);
        if (this.cache != null) {
            this.cache.removeNodeModelListener(this);
        }
        SpreadSheetFieldArray spreadSheetFieldArray = null;
        if (this.fieldArray != null) {
            spreadSheetFieldArray = (SpreadSheetFieldArray)this.fieldArray.clone();
            CollectionUtils.filter(spreadSheetFieldArray, new Predicate(){

                @Override
                public boolean evaluate(Object object) {
                    return !((Field)object).isGraphical();
                }
            });
        }
        JasperReport jasperReport = ReportUtil.getReport(this.reportDefinition, this.coord.getProjectTimeIterator(), spreadSheetFieldArray);
        this.viewName = DataSourceProvider.getViewName(jasperReport);
        this.documentFrame.setComboBoxesViewName(this.viewName);
        NodeModel nodeModel = null;
        if (this.viewName == DataSourceProvider.REPORT_VIEW) {
            this.cache = null;
            cloneable = new ArrayList<Project>();
            ((ArrayList)cloneable).add(this.project);
            generalFilteredIterator = GeneralFilteredIterator.instance(((ArrayList)cloneable).iterator());
        } else {
            nodeModel = this.updateCacheForView(this.viewName);
            generalFilteredIterator = this.cache == null ? GeneralFilteredIterator.instance(nodeModel.iterator()) : GeneralFilteredIterator.instance(this.cache.getIterator());
        }
        DataSource dataSource = DataSourceProvider.createDataSource(jasperReport, this.project, generalFilteredIterator, nodeModel);
        cloneable = new HashMap();
        ((HashMap)cloneable).put("projectName", this.project.getName());
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)((Object)cloneable), (JRDataSource)dataSource);
        if (this.viewer != null) {
            this.viewer.changeReport(jasperPrint);
        } else {
            this.viewer = new ReportViewer(jasperPrint);
            this.add((Component)((Object)this.viewer), "Center");
        }
        if (this.cache != null) {
            this.cache.addNodeModelListener(this);
        }
        this.dirty = false;
        this.documentFrame.showWaitCursor(false);
    }

    private JPanel header() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.reportLabel);
        jPanel.add(this.reportChoice);
        jPanel.add(this.columnsLabel);
        jPanel.add(this.columnsChoice);
        return jPanel;
    }

    private void initColumns() {
        String string = this.reportDefinition.getMainSpreadsheetCategory();
        if (string == null || string.equals("assignmentSpreadsheet")) {
            this.columnsChoice.setVisible(false);
            this.columnsLabel.setVisible(false);
            return;
        }
        this.columnsChoice.setVisible(true);
        this.columnsLabel.setVisible(true);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(Dictionary.getAll(string));
        this.columnsChoice.setModel(defaultComboBoxModel);
        this.columnsChoice.setSelectedItem(this.fieldArray);
    }

    public void init(CoordinatesConverter coordinatesConverter) {
        this.initializing = true;
        this.coord = coordinatesConverter;
        this.setLayout(this.layout);
        this.reportLabel = new JLabel(Messages.getString("ReportView.Report"));
        this.reportChoice = new JComboBox<Object>(ReportUtil.getReportDefinitions());
        this.reportChoice.setSelectedIndex(0);
        this.reportDefinition = (ReportDefinition)this.reportChoice.getSelectedItem();
        this.fieldArray = this.reportDefinition.getMainFieldArray();
        this.reportChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportView.this.reportDefinition = (ReportDefinition)((JComboBox)actionEvent.getSource()).getSelectedItem();
                ReportView.this.fieldArray = ReportView.this.reportDefinition.getMainFieldArray();
                ReportView.this.dirty = true;
                ReportView.this.showReport();
                ReportView.this.initColumns();
            }
        });
        this.columnsLabel = new JLabel(Messages.getString("ReportView.Columns"));
        this.columnsChoice = new JComboBox();
        this.initColumns();
        this.columnsChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportView.this.fieldArray = (SpreadSheetFieldArray)((JComboBox)actionEvent.getSource()).getSelectedItem();
                ReportView.this.dirty = true;
                ReportView.this.showReport();
            }
        });
        this.add((Component)this.header(), "First");
        this.showReport();
        this.initializing = false;
    }

    @Override
    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        if (this.initializing) {
            return;
        }
        this.dirty = true;
        if (!this.isShowing()) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        this.showReport();
    }

    @Override
    public UndoController getUndoController() {
        return null;
    }

    @Override
    public void zoomIn() {
        this.viewer.zoomIn();
    }

    @Override
    public void zoomOut() {
        this.viewer.zoomOut();
    }

    @Override
    public boolean canZoomIn() {
        return true;
    }

    @Override
    public boolean canZoomOut() {
        return true;
    }

    @Override
    public int getScale() {
        return -1;
    }

    @Override
    public SpreadSheet getSpreadSheet() {
        return null;
    }

    @Override
    public boolean hasNormalMinWidth() {
        return true;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public boolean showsTasks() {
        return false;
    }

    @Override
    public boolean showsResources() {
        return false;
    }

    @Override
    public void onActivate(boolean bl) {
        if (bl) {
            this.showReport();
        }
    }

    @Override
    public boolean isPrintable() {
        return false;
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        NamedItem namedItem;
        Workspace workspace = (Workspace)workspaceSetting;
        if (workspace.reportName != null && (namedItem = ReportUtil.getFromName(workspace.reportName)) != null) {
            this.reportChoice.setSelectedItem(namedItem);
        }
        if (workspace.fieldArrayName != null && (namedItem = (SpreadSheetFieldArray)Dictionary.get(this.reportDefinition.getMainSpreadsheetCategory(), workspace.fieldArrayName)) != null) {
            this.columnsChoice.setSelectedItem(namedItem);
        }
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        if (this.reportDefinition != null) {
            workspace.reportName = this.reportDefinition.getName();
        }
        if (this.fieldArray != null) {
            workspace.fieldArrayName = this.fieldArray.toString();
        }
        return workspace;
    }

    @Override
    public boolean canScrollToTask() {
        return false;
    }

    @Override
    public void scrollToTask() {
    }

    @Override
    public NodeModelCache getCache() {
        return this.cache;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -7768176701769503845L;
        String fieldArrayName = null;
        String reportName = null;

        public String getFieldArrayName() {
            return this.fieldArrayName;
        }

        public void setFieldArrayName(String string) {
            this.fieldArrayName = string;
        }

        public String getReportName() {
            return this.reportName;
        }

        public void setReportName(String string) {
            this.reportName = string;
        }
    }
}

