/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.resthandler.monitor;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.threatIntel.action.monitor.UpdateThreatIntelAlertStatusAction;
import org.opensearch.securityanalytics.threatIntel.action.monitor.request.UpdateThreatIntelAlertStatusRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestUpdateThreatIntelAlertsStatusAction
extends BaseRestHandler {
    public String getName() {
        return "update_threat_intel_alerts_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.getDefault(), "%s", "/_plugins/_security_analytics/threat_intel/alerts/status")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String state = request.param("state");
        if (StringUtils.isBlank((CharSequence)state)) {
            throw new IllegalArgumentException("State param is required.");
        }
        Alert.State alertState = Alert.State.valueOf((String)state.toUpperCase());
        List<String> alertIds = List.of(Strings.commaDelimitedListToStringArray((String)request.param("alert_ids", "")));
        UpdateThreatIntelAlertStatusRequest req = new UpdateThreatIntelAlertStatusRequest(alertIds, alertState);
        return channel -> client.execute((ActionType)UpdateThreatIntelAlertStatusAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
    }
}

