/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.stats.suppliers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.ltr.stats.suppliers.utils.StoreUtils;
import org.opensearch.transport.client.Client;

public class StoreStatsSupplier
implements Supplier<Map<String, Map<String, Object>>> {
    static final String LTR_STORE_STATUS = "status";
    static final String LTR_STORE_FEATURE_COUNT = "feature_count";
    static final String LTR_STORE_FEATURE_SET_COUNT = "featureset_count";
    static final String LTR_STORE_MODEL_COUNT = "model_count";
    private final StoreUtils storeUtils;

    protected StoreStatsSupplier(StoreUtils storeUtils) {
        this.storeUtils = storeUtils;
    }

    @Override
    public Map<String, Map<String, Object>> get() {
        ConcurrentHashMap<String, Map<String, Object>> storeStats = new ConcurrentHashMap<String, Map<String, Object>>();
        List<String> storeNames = this.storeUtils.getAllLtrStoreNames();
        storeNames.forEach(s -> storeStats.put((String)s, this.getStoreStat((String)s)));
        return storeStats;
    }

    private Map<String, Object> getStoreStat(String storeName) {
        if (!this.storeUtils.checkLtrStoreExists(storeName)) {
            throw new IllegalArgumentException("LTR Store [" + storeName + "] doesn't exist.");
        }
        HashMap<String, Object> storeStat = new HashMap<String, Object>();
        storeStat.put(LTR_STORE_STATUS, this.storeUtils.getLtrStoreHealthStatus(storeName));
        Map<String, Integer> featureSets = this.storeUtils.extractFeatureSetStats(storeName);
        storeStat.put(LTR_STORE_FEATURE_COUNT, featureSets.values().stream().reduce(Integer::sum).orElse(0));
        storeStat.put(LTR_STORE_FEATURE_SET_COUNT, featureSets.size());
        storeStat.put(LTR_STORE_MODEL_COUNT, this.storeUtils.getModelCount(storeName));
        return storeStat;
    }

    public static StoreStatsSupplier create(Client client, ClusterService clusterService) {
        return new StoreStatsSupplier(new StoreUtils(client, clusterService));
    }
}

