/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.explore;

import com.o19s.es.ltr.utils.CheckedBiFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.IOSupplier;
import org.opensearch.ltr.settings.LTRSettings;

public class PostingsExplorerQuery
extends Query {
    private final Term term;
    private final Type type;

    PostingsExplorerQuery(Term term, Type type) {
        this.term = Objects.requireNonNull(term);
        this.type = Objects.requireNonNull(type);
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder("postings_explorer(");
        buffer.append(this.type.name()).append(", ");
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append(")");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        return this.sameClassAs(obj) && this.term.equals((Object)((PostingsExplorerQuery)((Object)obj)).term) && this.type.equals(((PostingsExplorerQuery)((Object)obj)).type);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.term, this.type);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (!LTRSettings.isLTRPluginEnabled()) {
            throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
        }
        assert (scoreMode.needsScores()) : "Should not be used in filtering mode";
        return new PostingsExplorerWeight(this, this.term, TermStates.build((IndexSearcher)searcher, (Term)this.term, (boolean)scoreMode.needsScores()), this.type);
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.term.field())) {
            visitor.consumeTerms((Query)this, new Term[]{this.term});
        }
    }

    static enum Type implements CheckedBiFunction<Weight, TermsEnum, Scorer, IOException>
    {
        TF((weight, terms) -> new TFScorer((Weight)weight, terms.postings(null, 8))),
        TP((weight, terms) -> new TPScorer((Weight)weight, terms.postings(null, 24)));

        private final CheckedBiFunction<Weight, TermsEnum, Scorer, IOException> func;

        private Type(CheckedBiFunction<Weight, TermsEnum, Scorer, IOException> func) {
            this.func = func;
        }

        @Override
        public Scorer apply(Weight weight, TermsEnum termsEnum) throws IOException {
            return this.func.apply(weight, termsEnum);
        }
    }

    static class PostingsExplorerWeight
    extends Weight {
        private final Term term;
        private final TermStates termStates;
        private final Type type;

        PostingsExplorerWeight(Query query, Term term, TermStates termStates, Type type) {
            super(query);
            this.term = term;
            this.termStates = termStates;
            this.type = type;
        }

        public void extractTerms(Set<Term> terms) {
            terms.add(this.term);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Scorer scorer = this.scorer(context);
            int newDoc = scorer.iterator().advance(doc);
            if (newDoc == doc) {
                return Explanation.match((Number)Float.valueOf(scorer.score()), (String)("weight(" + String.valueOf(this.getQuery()) + " in doc " + newDoc + ")"), (Explanation[])new Explanation[0]);
            }
            return Explanation.noMatch((String)"no matching term", (Explanation[])new Explanation[0]);
        }

        public Scorer getScorer(LeafReaderContext context) throws IOException {
            assert (this.termStates != null && this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext((IndexReaderContext)context)));
            IOSupplier termStateSupplier = this.termStates.get(context);
            if (termStateSupplier == null || termStateSupplier.get() == null) {
                return null;
            }
            TermState state = (TermState)termStateSupplier.get();
            TermsEnum terms = context.reader().terms(this.term.field()).iterator();
            terms.seekExact(this.term.bytes(), state);
            return this.type.apply(this, terms);
        }

        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            final Scorer scorer = this.getScorer(context);
            if (scorer == null) {
                return null;
            }
            final DocIdSetIterator iterator = scorer != null ? scorer.iterator() : DocIdSetIterator.empty();
            return new ScorerSupplier(this){

                public Scorer get(long leadCost) throws IOException {
                    return scorer;
                }

                public long cost() {
                    return iterator.cost();
                }
            };
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }

    static class TPScorer
    extends PostingsExplorerScorer {
        TPScorer(Weight weight, PostingsEnum postingsEnum) {
            super(weight, postingsEnum);
        }

        public float score() throws IOException {
            if (this.postingsEnum.freq() <= 0) {
                return 0.0f;
            }
            ArrayList<Float> positions = new ArrayList<Float>();
            for (int i = 0; i < this.postingsEnum.freq(); ++i) {
                positions.add(Float.valueOf((float)this.postingsEnum.nextPosition() + 1.0f));
            }
            return switch (this.typeConditional) {
                case "avg_raw_tp" -> {
                    float sum = 0.0f;
                    Iterator var6_7 = positions.iterator();
                    while (var6_7.hasNext()) {
                        float position = ((Float)var6_7.next()).floatValue();
                        sum += position;
                    }
                    yield sum / (float)positions.size();
                }
                case "max_raw_tp" -> ((Float)Collections.max(positions)).floatValue();
                case "min_raw_tp" -> ((Float)Collections.min(positions)).floatValue();
                default -> 0.0f;
            };
        }

        public float getMaxScore(int upTo) throws IOException {
            return Float.POSITIVE_INFINITY;
        }
    }

    static class TFScorer
    extends PostingsExplorerScorer {
        TFScorer(Weight weight, PostingsEnum postingsEnum) {
            super(weight, postingsEnum);
        }

        public float score() throws IOException {
            return this.postingsEnum.freq();
        }

        public float getMaxScore(int upTo) throws IOException {
            return Float.POSITIVE_INFINITY;
        }
    }

    public static abstract class PostingsExplorerScorer
    extends Scorer {
        final PostingsEnum postingsEnum;
        protected String typeConditional;

        PostingsExplorerScorer(Weight weight, PostingsEnum postingsEnum) {
            this.postingsEnum = postingsEnum;
        }

        public void setType(String type) {
            this.typeConditional = type;
        }

        public int docID() {
            return this.postingsEnum.docID();
        }

        public DocIdSetIterator iterator() {
            return this.postingsEnum;
        }
    }
}

