/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkUserAppException;
import org.apache.spark.api.python.Py4JServer;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class PythonRunner$ {
    public static final PythonRunner$ MODULE$ = new PythonRunner$();

    public void main(String[] args) {
        String pythonFile = args[0];
        String pyFiles = args[1];
        String[] otherArgs = (String[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])args), 2, args.length);
        SparkConf sparkConf = new SparkConf();
        String pythonExec = (String)((Option)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.PYSPARK_DRIVER_PYTHON())).orElse((Function0 & Serializable)() -> (Option)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.PYSPARK_PYTHON())).orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"PYSPARK_DRIVER_PYTHON")).orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"PYSPARK_PYTHON")).getOrElse((Function0 & Serializable)() -> "python3");
        String formattedPythonFile = this.formatPath(pythonFile, this.formatPath$default$2());
        String[] formattedPyFiles = this.resolvePyFiles(this.formatPaths(pyFiles, this.formatPaths$default$2()));
        Py4JServer gatewayServer = new Py4JServer(sparkConf);
        Thread thread = new Thread(() -> Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable)() -> gatewayServer.start()));
        thread.setName("py4j-gateway-init");
        thread.setDaemon(true);
        thread.start();
        thread.join();
        ArrayBuffer pathElements = new ArrayBuffer();
        pathElements.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])formattedPyFiles));
        pathElements.$plus$eq((Object)PythonUtils$.MODULE$.sparkPythonPath());
        pathElements.$plus$eq(scala.sys.package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> ""));
        String pythonPath = PythonUtils$.MODULE$.mergePythonPaths((scala.collection.immutable.Seq<String>)pathElements.toSeq());
        ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{pythonExec, formattedPythonFile})).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])otherArgs))).asJava());
        Map<String, String> env = builder.environment();
        sparkConf.getOption("spark.remote").foreach((Function1 & Serializable)url -> env.put("SPARK_REMOTE", (String)url));
        env.put("PYTHONPATH", pythonPath);
        env.put("PYTHONUNBUFFERED", "YES");
        env.put("PYSPARK_GATEWAY_PORT", String.valueOf(BoxesRunTime.boxToInteger((int)gatewayServer.getListeningPort())));
        env.put("PYSPARK_GATEWAY_SECRET", gatewayServer.secret());
        ((Option)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.PYSPARK_PYTHON())).foreach((Function1 & Serializable)x$1 -> env.put("PYSPARK_PYTHON", (String)x$1));
        scala.sys.package$.MODULE$.env().get((Object)"PYTHONHASHSEED").foreach((Function1 & Serializable)x$2 -> env.put("PYTHONHASHSEED", (String)x$2));
        if (sparkConf.getOption("spark.yarn.appMasterEnv.OMP_NUM_THREADS").isEmpty() && sparkConf.getOption("spark.mesos.driverEnv.OMP_NUM_THREADS").isEmpty() && sparkConf.getOption("spark.kubernetes.driverEnv.OMP_NUM_THREADS").isEmpty()) {
            sparkConf.getOption("spark.driver.cores").foreach((Function1 & Serializable)x$3 -> env.put("OMP_NUM_THREADS", (String)x$3));
        }
        builder.redirectErrorStream(true);
        try {
            Process process = builder.start();
            new RedirectThread(process.getInputStream(), System.out, "redirect output", RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new SparkUserAppException(exitCode);
            }
        }
        finally {
            gatewayServer.shutdown();
        }
    }

    public String formatPath(String path, boolean testWindows) {
        String formattedPath;
        block11: {
            String string;
            block10: {
                block9: {
                    if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.nonLocalPaths(path, testWindows)))) {
                        throw new IllegalArgumentException(new StringBuilder(38).append("Launching Python applications through ").append(new StringBuilder(58).append("spark-submit is currently only supported for local files: ").append(path).toString()).toString());
                    }
                    URI uri = (URI)Try$.MODULE$.apply((Function0 & Serializable)() -> new URI(path)).getOrElse((Function0 & Serializable)() -> new File(path).toURI());
                    String string2 = uri.getScheme();
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 0: {
                            if (string2 != null) break block9;
                            string = path;
                            break block10;
                        }
                        case 3143036: {
                            if ("file".equals(string2)) {
                                break;
                            }
                            break block9;
                        }
                        case 103145323: {
                            if ("local".equals(string2)) {
                                break;
                            }
                            break block9;
                        }
                        default: {
                            break block9;
                        }
                    }
                    string = uri.getPath();
                    break block10;
                }
                string = null;
            }
            formattedPath = string;
            if (formattedPath == null) {
                throw new IllegalArgumentException(new StringBuilder(31).append("Python file path is malformed: ").append(path).toString());
            }
            if (!Utils$.MODULE$.isWindows() || !formattedPath.matches("/[a-zA-Z]:/.*")) break block11;
            formattedPath = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(formattedPath), "/");
        }
        return formattedPath;
    }

    public boolean formatPath$default$2() {
        return false;
    }

    public String[] formatPaths(String paths, boolean testWindows) {
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])((String)Option$.MODULE$.apply((Object)paths).getOrElse((Function0 & Serializable)() -> "")).split(",")), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4))))), (Function1 & Serializable)p -> MODULE$.formatPath((String)p, testWindows), ClassTag$.MODULE$.apply(String.class));
    }

    public boolean formatPaths$default$2() {
        return false;
    }

    private String[] resolvePyFiles(String[] pyFiles) {
        LazyRef dest$lzy = new LazyRef();
        return (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])pyFiles), (Function1 & Serializable)pyFile -> {
            Some some;
            if (pyFile.endsWith(".py")) {
                File source = new File((String)pyFile);
                if (source.exists() && source.isFile() && source.canRead()) {
                    Files.copy(source.toPath(), new File(PythonRunner$.dest$1(dest$lzy), source.getName()).toPath(), new CopyOption[0]);
                    some = new Some((Object)PythonRunner$.dest$1(dest$lzy).getAbsolutePath());
                } else {
                    some = None$.MODULE$;
                }
            } else {
                some = new Some(pyFile);
            }
            return some;
        }, ClassTag$.MODULE$.apply(String.class))));
    }

    private static final /* synthetic */ File dest$lzycompute$1(LazyRef dest$lzy$1) {
        File file;
        LazyRef lazyRef = dest$lzy$1;
        synchronized (lazyRef) {
            File file2;
            if (dest$lzy$1.initialized()) {
                file2 = (File)dest$lzy$1.value();
            } else {
                String x$1 = "localPyFiles";
                String x$2 = Utils$.MODULE$.createTempDir$default$1();
                file2 = (File)dest$lzy$1.initialize((Object)Utils$.MODULE$.createTempDir(x$2, "localPyFiles"));
            }
            file = file2;
        }
        return file;
    }

    private static final File dest$1(LazyRef dest$lzy$1) {
        return dest$lzy$1.initialized() ? (File)dest$lzy$1.value() : PythonRunner$.dest$lzycompute$1(dest$lzy$1);
    }

    private PythonRunner$() {
    }
}

