/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.system;

import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.lang.PPLLangSpec;

public final class SystemFunctions {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(SystemFunctions.typeof());
    }

    private static FunctionResolver typeof() {
        return new FunctionResolver(){

            @Override
            public Pair<FunctionSignature, FunctionBuilder> resolve(FunctionSignature unresolvedSignature) {
                return Pair.of((Object)unresolvedSignature, (functionProperties, arguments) -> new FunctionExpression(this, BuiltinFunctionName.TYPEOF.getName(), arguments){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        super(functionName, arguments);
                    }

                    @Override
                    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
                        ExprType type = this.getArguments().get(0).type();
                        return new ExprStringValue((functionProperties.getQueryType() == QueryType.PPL ? PPLLangSpec.PPL_SPEC.typeName(type) : type.legacyTypeName()).toUpperCase(Locale.ROOT));
                    }

                    @Override
                    public ExprType type() {
                        return ExprCoreType.STRING;
                    }
                });
            }

            @Override
            public FunctionName getFunctionName() {
                return BuiltinFunctionName.TYPEOF.getName();
            }
        };
    }

    @Generated
    private SystemFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

