/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.expression.function.SerializableBiFunction;
import org.opensearch.sql.expression.function.SerializableFunction;
import org.opensearch.sql.expression.function.SerializableNoArgFunction;
import org.opensearch.sql.expression.function.SerializableQuadFunction;
import org.opensearch.sql.expression.function.SerializableTriFunction;

public final class FunctionDSL {
    public static DefaultFunctionResolver define(FunctionName functionName, SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> ... functions) {
        return FunctionDSL.define(functionName, List.of(functions));
    }

    public static DefaultFunctionResolver define(FunctionName functionName, List<SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>>> functions) {
        DefaultFunctionResolver.DefaultFunctionResolverBuilder builder = DefaultFunctionResolver.builder();
        builder.functionName(functionName);
        for (Function function : functions) {
            Pair functionBuilder = (Pair)function.apply(functionName);
            builder.functionBundle((FunctionSignature)functionBuilder.getKey(), (FunctionBuilder)functionBuilder.getValue());
        }
        return builder.build();
    }

    public static SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> implWithProperties(final SerializableFunction<FunctionProperties, ExprValue> function, final ExprType returnType) {
        return functionName -> {
            FunctionSignature functionSignature = new FunctionSignature((FunctionName)functionName, Collections.emptyList());
            FunctionBuilder functionBuilder = (functionProperties, arguments) -> new FunctionExpression((FunctionName)functionName, Collections.emptyList(), (FunctionName)functionName){
                final /* synthetic */ FunctionName val$functionName;
                {
                    this.val$functionName = functionName2;
                    super(functionName, arguments);
                }

                @Override
                public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
                    return (ExprValue)function.apply(functionProperties);
                }

                @Override
                public ExprType type() {
                    return returnType;
                }

                @Override
                public String toString() {
                    return String.format("%s()", this.val$functionName);
                }
            };
            return Pair.of((Object)functionSignature, (Object)functionBuilder);
        };
    }

    public static SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> implWithProperties(final SerializableBiFunction<FunctionProperties, ExprValue, ExprValue> function, final ExprType returnType, ExprType argsType) {
        return functionName -> {
            FunctionSignature functionSignature = new FunctionSignature((FunctionName)functionName, Collections.singletonList(argsType));
            FunctionBuilder functionBuilder = (functionProperties, arguments) -> new FunctionExpression((FunctionName)functionName, arguments, (FunctionName)functionName){
                final /* synthetic */ FunctionName val$functionName;
                {
                    this.val$functionName = functionName2;
                    super(functionName, arguments2);
                }

                @Override
                public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
                    ExprValue value = ((Expression)arguments.get(0)).valueOf(valueEnv);
                    return (ExprValue)function.apply(functionProperties, value);
                }

                @Override
                public ExprType type() {
                    return returnType;
                }

                @Override
                public String toString() {
                    return String.format("%s(%s)", this.val$functionName, arguments.stream().map(Object::toString).collect(Collectors.joining(", ")));
                }
            };
            return Pair.of((Object)functionSignature, (Object)functionBuilder);
        };
    }

    public static SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> implWithProperties(final SerializableTriFunction<FunctionProperties, ExprValue, ExprValue, ExprValue> function, final ExprType returnType, ExprType args1Type, ExprType args2Type) {
        return functionName -> {
            FunctionSignature functionSignature = new FunctionSignature((FunctionName)functionName, Arrays.asList(args1Type, args2Type));
            FunctionBuilder functionBuilder = (functionProperties, arguments) -> new FunctionExpression((FunctionName)functionName, arguments, (FunctionName)functionName){
                final /* synthetic */ FunctionName val$functionName;
                {
                    this.val$functionName = functionName2;
                    super(functionName, arguments2);
                }

                @Override
                public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
                    ExprValue arg1 = ((Expression)arguments.get(0)).valueOf(valueEnv);
                    ExprValue arg2 = ((Expression)arguments.get(1)).valueOf(valueEnv);
                    return (ExprValue)function.apply(functionProperties, arg1, arg2);
                }

                @Override
                public ExprType type() {
                    return returnType;
                }

                @Override
                public String toString() {
                    return String.format("%s(%s)", this.val$functionName, arguments.stream().map(Object::toString).collect(Collectors.joining(", ")));
                }
            };
            return Pair.of((Object)functionSignature, (Object)functionBuilder);
        };
    }

    public static SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> implWithProperties(final SerializableQuadFunction<FunctionProperties, ExprValue, ExprValue, ExprValue, ExprValue> function, final ExprType returnType, ExprType args1Type, ExprType args2Type, ExprType args3Type) {
        return functionName -> {
            FunctionSignature functionSignature = new FunctionSignature((FunctionName)functionName, Arrays.asList(args1Type, args2Type, args3Type));
            FunctionBuilder functionBuilder = (functionProperties, arguments) -> new FunctionExpression((FunctionName)functionName, arguments, (FunctionName)functionName){
                final /* synthetic */ FunctionName val$functionName;
                {
                    this.val$functionName = functionName2;
                    super(functionName, arguments2);
                }

                @Override
                public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
                    ExprValue arg1 = ((Expression)arguments.get(0)).valueOf(valueEnv);
                    ExprValue arg2 = ((Expression)arguments.get(1)).valueOf(valueEnv);
                    ExprValue arg3 = ((Expression)arguments.get(2)).valueOf(valueEnv);
                    return (ExprValue)function.apply(functionProperties, arg1, arg2, arg3);
                }

                @Override
                public ExprType type() {
                    return returnType;
                }

                @Override
                public String toString() {
                    return String.format("%s(%s)", this.val$functionName, arguments.stream().map(Object::toString).collect(Collectors.joining(", ")));
                }
            };
            return Pair.of((Object)functionSignature, (Object)functionBuilder);
        };
    }

    public static SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> impl(SerializableNoArgFunction<ExprValue> function, ExprType returnType) {
        return FunctionDSL.implWithProperties(fp -> (ExprValue)function.get(), returnType);
    }

    public static SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> impl(SerializableFunction<ExprValue, ExprValue> function, ExprType returnType, ExprType argsType) {
        return FunctionDSL.implWithProperties((fp, arg) -> (ExprValue)function.apply((ExprValue)arg), returnType, argsType);
    }

    public static SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> impl(SerializableBiFunction<ExprValue, ExprValue, ExprValue> function, ExprType returnType, ExprType args1Type, ExprType args2Type) {
        return FunctionDSL.implWithProperties((fp, arg1, arg2) -> (ExprValue)function.apply((ExprValue)arg1, (ExprValue)arg2), returnType, args1Type, args2Type);
    }

    public static SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> impl(final SerializableTriFunction<ExprValue, ExprValue, ExprValue, ExprValue> function, final ExprType returnType, ExprType args1Type, ExprType args2Type, ExprType args3Type) {
        return functionName -> {
            FunctionSignature functionSignature = new FunctionSignature((FunctionName)functionName, Arrays.asList(args1Type, args2Type, args3Type));
            FunctionBuilder functionBuilder = (functionProperties, arguments) -> new FunctionExpression((FunctionName)functionName, arguments, (FunctionName)functionName){
                final /* synthetic */ FunctionName val$functionName;
                {
                    this.val$functionName = functionName2;
                    super(functionName, arguments2);
                }

                @Override
                public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
                    ExprValue arg1 = ((Expression)arguments.get(0)).valueOf(valueEnv);
                    ExprValue arg2 = ((Expression)arguments.get(1)).valueOf(valueEnv);
                    ExprValue arg3 = ((Expression)arguments.get(2)).valueOf(valueEnv);
                    return (ExprValue)function.apply(arg1, arg2, arg3);
                }

                @Override
                public ExprType type() {
                    return returnType;
                }

                @Override
                public String toString() {
                    return String.format("%s(%s, %s, %s)", this.val$functionName, ((Expression)arguments.get(0)).toString(), ((Expression)arguments.get(1)).toString(), ((Expression)arguments.get(2)).toString());
                }
            };
            return Pair.of((Object)functionSignature, (Object)functionBuilder);
        };
    }

    public static SerializableFunction<FunctionName, Pair<FunctionSignature, FunctionBuilder>> impl(final SerializableQuadFunction<ExprValue, ExprValue, ExprValue, ExprValue, ExprValue> function, final ExprType returnType, ExprType args1Type, ExprType args2Type, ExprType args3Type, ExprType args4Type) {
        return functionName -> {
            FunctionSignature functionSignature = new FunctionSignature((FunctionName)functionName, Arrays.asList(args1Type, args2Type, args3Type, args4Type));
            FunctionBuilder functionBuilder = (functionProperties, arguments) -> new FunctionExpression((FunctionName)functionName, arguments, (FunctionName)functionName){
                final /* synthetic */ FunctionName val$functionName;
                {
                    this.val$functionName = functionName2;
                    super(functionName, arguments2);
                }

                @Override
                public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
                    ExprValue arg1 = ((Expression)arguments.get(0)).valueOf(valueEnv);
                    ExprValue arg2 = ((Expression)arguments.get(1)).valueOf(valueEnv);
                    ExprValue arg3 = ((Expression)arguments.get(2)).valueOf(valueEnv);
                    ExprValue arg4 = ((Expression)arguments.get(3)).valueOf(valueEnv);
                    return (ExprValue)function.apply(arg1, arg2, arg3, arg4);
                }

                @Override
                public ExprType type() {
                    return returnType;
                }

                @Override
                public String toString() {
                    return String.format("%s(%s, %s, %s, %s)", this.val$functionName, ((Expression)arguments.get(0)).toString(), ((Expression)arguments.get(1)).toString(), ((Expression)arguments.get(2)).toString(), ((Expression)arguments.get(3)).toString());
                }
            };
            return Pair.of((Object)functionSignature, (Object)functionBuilder);
        };
    }

    public static SerializableFunction<ExprValue, ExprValue> nullMissingHandling(SerializableFunction<ExprValue, ExprValue> function) {
        return value -> {
            if (value.isMissing()) {
                return ExprValueUtils.missingValue();
            }
            if (value.isNull()) {
                return ExprValueUtils.nullValue();
            }
            return (ExprValue)function.apply((ExprValue)value);
        };
    }

    public static SerializableBiFunction<ExprValue, ExprValue, ExprValue> nullMissingHandling(SerializableBiFunction<ExprValue, ExprValue, ExprValue> function) {
        return (v1, v2) -> {
            if (v1.isMissing() || v2.isMissing()) {
                return ExprValueUtils.missingValue();
            }
            if (v1.isNull() || v2.isNull()) {
                return ExprValueUtils.nullValue();
            }
            return (ExprValue)function.apply((ExprValue)v1, (ExprValue)v2);
        };
    }

    public static SerializableTriFunction<ExprValue, ExprValue, ExprValue, ExprValue> nullMissingHandling(SerializableTriFunction<ExprValue, ExprValue, ExprValue, ExprValue> function) {
        return (v1, v2, v3) -> {
            if (v1.isMissing() || v2.isMissing() || v3.isMissing()) {
                return ExprValueUtils.missingValue();
            }
            if (v1.isNull() || v2.isNull() || v3.isNull()) {
                return ExprValueUtils.nullValue();
            }
            return (ExprValue)function.apply((ExprValue)v1, (ExprValue)v2, (ExprValue)v3);
        };
    }

    public static SerializableBiFunction<FunctionProperties, ExprValue, ExprValue> nullMissingHandlingWithProperties(SerializableBiFunction<FunctionProperties, ExprValue, ExprValue> implementation) {
        return (functionProperties, v1) -> {
            if (v1.isMissing()) {
                return ExprValueUtils.missingValue();
            }
            if (v1.isNull()) {
                return ExprValueUtils.nullValue();
            }
            return (ExprValue)implementation.apply((FunctionProperties)functionProperties, (ExprValue)v1);
        };
    }

    public static SerializableTriFunction<FunctionProperties, ExprValue, ExprValue, ExprValue> nullMissingHandlingWithProperties(SerializableTriFunction<FunctionProperties, ExprValue, ExprValue, ExprValue> implementation) {
        return (functionProperties, v1, v2) -> {
            if (v1.isMissing() || v2.isMissing()) {
                return ExprValueUtils.missingValue();
            }
            if (v1.isNull() || v2.isNull()) {
                return ExprValueUtils.nullValue();
            }
            return (ExprValue)implementation.apply((FunctionProperties)functionProperties, (ExprValue)v1, (ExprValue)v2);
        };
    }

    public static SerializableQuadFunction<FunctionProperties, ExprValue, ExprValue, ExprValue, ExprValue> nullMissingHandlingWithProperties(SerializableQuadFunction<FunctionProperties, ExprValue, ExprValue, ExprValue, ExprValue> implementation) {
        return (functionProperties, v1, v2, v3) -> {
            if (v1.isMissing() || v2.isMissing() || v3.isMissing()) {
                return ExprValueUtils.missingValue();
            }
            if (v1.isNull() || v2.isNull() || v3.isNull()) {
                return ExprValueUtils.nullValue();
            }
            return (ExprValue)implementation.apply((FunctionProperties)functionProperties, (ExprValue)v1, (ExprValue)v2, (ExprValue)v3);
        };
    }

    @Generated
    private FunctionDSL() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

